/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wscloud.latest.GetPODsRequest;
import org.hpccsystems.ws.client.gen.axis2.wscloud.latest.GetPODsResponse;
import org.hpccsystems.ws.client.gen.axis2.wscloud.latest.WsCloud;
import org.hpccsystems.ws.client.gen.axis2.wscloud.latest.WsCloudPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wscloud.latest.WsCloudStub;
import org.hpccsystems.ws.client.utils.Connection;

public class HPCCWsCloudClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsCloudClient.class);
    public static final String WSCLOUDURI = "/wscloud";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsCloudClient.getServiceWSDLURL(new WsCloudStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return WSCLOUDURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsCloudClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsCloudClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsCloudStub();
    }

    public static HPCCWsCloudClient get(Connection connection) {
        return new HPCCWsCloudClient(connection);
    }

    public static HPCCWsCloudClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsCloudClient(conn);
    }

    public static HPCCWsCloudClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsCloudClient(conn);
    }

    protected HPCCWsCloudClient(Connection baseConnection) {
        this.initWsCloudClientStub(baseConnection);
    }

    protected void initWsCloudClientStub(Connection conn) {
        this.setActiveConnectionInfo(conn);
        try {
            this.stub = HPCCWsCloudClient.setStubOptions(new WsCloudStub(conn.getBaseUrl() + WSCLOUDURI), conn);
        }
        catch (Exception e) {
            this.stub = null;
            this.initErrMessage = "Could not initialize WsCloudClient - Review all HPCC connection values";
            if (!e.getLocalizedMessage().isEmpty()) {
                this.initErrMessage = this.initErrMessage + "\n" + e.getLocalizedMessage();
            }
            log.error(this.initErrMessage);
        }
    }

    public String getPods() throws Exception {
        this.verifyStub();
        GetPODsResponse resp = null;
        try {
            resp = ((WsCloud)this.stub).getPODs(new GetPODsRequest());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsCloud.getPods() encountered RemoteException.", e);
        }
        if (resp == null || !resp.isResultSpecified()) {
            throw new Exception("HPCCWsCloud.getPods() received invalid respose.");
        }
        return resp.getResult();
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        try {
            ((WsCloudStub)this.stub).ping(new WsCloudPingRequest());
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

