/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.crypto.Cipher;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.hpccsystems.commons.utils.CryptoHelper;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.CreateStoreRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.CreateStoreResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.DeleteNamespaceRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.DeleteNamespaceResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.DeleteRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.DeleteResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchAllRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchAllResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchKeyMDRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchKeyMDResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.FetchResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.KVPair;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.KeySet_type0;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.ListKeysRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.ListKeysResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.ListNamespacesRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.ListNamespacesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.Namespaces_type0;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.Pairs_type0;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.Pairs_type1;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.SetRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.SetResponse;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.WsstorePingRequest;
import org.hpccsystems.ws.client.gen.axis2.wsstore.latest.WsstoreStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;

public class HPCCWsStoreClient
extends BaseHPCCWsClient {
    public static final String WSStoreWSDLURI = "/wsstore";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsStoreClient.getServiceWSDLURL(new WsstoreStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return WSStoreWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsStoreClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsStoreClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsStoreClient get(Connection connection) {
        return new HPCCWsStoreClient(connection);
    }

    public static HPCCWsStoreClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsStoreClient(conn);
    }

    public static HPCCWsStoreClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsStoreClient(conn);
    }

    protected HPCCWsStoreClient(Connection baseConnection) {
        this.initWSStoreStub(baseConnection);
    }

    private void initWSStoreStub(Connection connection) {
        block3: {
            this.initBaseWsClient(connection, true);
            try {
                this.stub = HPCCWsStoreClient.setStubOptions(new WsstoreStub(connection.getBaseUrl() + WSStoreWSDLURI), connection);
            }
            catch (AxisFault e) {
                this.initErrMessage = "Could not initialize WsStoreStub- Review all HPCC connection values";
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = this.initErrMessage + "\n" + e.getLocalizedMessage();
            }
        }
        if (!this.initErrMessage.isEmpty()) {
            log.error(this.initErrMessage);
        }
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        WsstorePingRequest request = new WsstorePingRequest();
        try {
            ((WsstoreStub)this.stub).ping(request);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public String[] listNamespaces(String storename, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        String[] namespaces = null;
        ListNamespacesRequest request = new ListNamespacesRequest();
        request.setStoreName(storename);
        request.setUserSpecific(global);
        try {
            Namespaces_type0 namespacesresp;
            ListNamespacesResponse response = ((WsstoreStub)this.stub).listNamespaces(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not list wsstore namespaces");
            }
            if ((namespacesresp = response.getNamespaces()) != null) {
                namespaces = namespacesresp.getNamespace();
            }
        }
        catch (RemoteException e) {
            log.error("Could not list namespaces");
            log.error((Object)e);
        }
        catch (EspSoapFault e) {
            log.error("Could not list namespaces");
            log.error((Object)e);
        }
        return namespaces;
    }

    public String[] listNSKeys(String storename, String namespace, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        String[] keyset = null;
        ListKeysRequest request = new ListKeysRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setUserSpecific(!global);
        try {
            KeySet_type0 keysetresp;
            ListKeysResponse response = ((WsstoreStub)this.stub).listKeys(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not list keys for store: " + storename + " namespace: '" + namespace + "'");
            }
            if ((keysetresp = response.getKeySet()) != null) {
                keyset = keysetresp.getKey();
            }
        }
        catch (RemoteException e) {
            log.error("Could not list namespace keys");
            log.error((Object)e);
        }
        catch (EspSoapFault e) {
            log.error("Could not list namespace keys");
            log.error((Object)e);
        }
        return keyset;
    }

    public String fetchValue(String storename, String namespace, String key, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        String value = null;
        FetchRequest request = new FetchRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setUserSpecific(!global);
        request.setKey(key);
        try {
            FetchResponse response = ((WsstoreStub)this.stub).fetch(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Fetch value for store: " + storename + " namespace: '" + namespace + "' key: '" + key + "'");
            }
            value = response.getValue();
        }
        catch (RemoteException e) {
            log.error("Could not fetch value");
            log.error((Object)e);
        }
        catch (EspSoapFault e) {
            log.error("Could not fetch value");
            log.error((Object)e);
        }
        return value;
    }

    public String fetchValueEncrypted(String storename, String namespace, String key, boolean global, Cipher cipher) throws Exception, ArrayOfEspExceptionWrapper {
        String value = this.fetchValue(storename, namespace, key, global);
        if (value == null || value.isEmpty()) {
            throw new Exception("Could not fetch value");
        }
        value = CryptoHelper.decrypt((String)value, (Cipher)cipher);
        return value;
    }

    public String fetchValueEncrypted(String storename, String namespace, String key, boolean global, String secretKey) throws Exception, ArrayOfEspExceptionWrapper {
        return this.fetchValueEncrypted(storename, namespace, secretKey, global, CryptoHelper.createDefaultCipher((String)secretKey, (boolean)false));
    }

    public Properties fetchKeyMetaData(String storename, String namespace, String key, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        Properties props = new Properties();
        FetchKeyMDRequest request = new FetchKeyMDRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setUserSpecific(!global);
        request.setKey(key);
        try {
            Pairs_type1 pairs;
            FetchKeyMDResponse response = ((WsstoreStub)this.stub).fetchKeyMetadata(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Fetch key meteadata for store: " + storename + " namespace: '" + namespace + "' key: '" + key + "'");
            }
            if ((pairs = response.getPairs()) != null) {
                KVPair[] pair;
                for (KVPair kvPair : pair = pairs.getPair()) {
                    props.setProperty(kvPair.getKey(), kvPair.getValue());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return props;
    }

    public Properties fetchAllNSKeys(String storename, String namespace, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        Properties props = new Properties();
        FetchAllRequest request = new FetchAllRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setUserSpecific(!global);
        try {
            Pairs_type0 pairs;
            FetchAllResponse response = ((WsstoreStub)this.stub).fetchAll(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not fetch all namespaces keys for store: " + storename + " namespace: '" + namespace + "'");
            }
            if ((pairs = response.getPairs()) != null) {
                KVPair[] pair;
                for (KVPair kvPair : pair = pairs.getPair()) {
                    props.setProperty(kvPair.getKey(), kvPair.getValue());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return props;
    }

    public boolean setValue(String storename, String namespace, String key, String value, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        SetRequest request = new SetRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setKey(key);
        request.setValue(value);
        request.setUserSpecific(!global);
        try {
            SetResponse response = ((WsstoreStub)this.stub).set(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not Set " + key + "=" + value + " for store: " + storename + " namespace: '" + namespace + "'");
            }
            return response.getSuccess();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setValueEncrypted(String storename, String namespace, String key, String value, boolean global, Cipher cipher) throws Exception, ArrayOfEspExceptionWrapper {
        return this.setValue(storename, namespace, key, CryptoHelper.encrypt((String)value, (Cipher)cipher), global);
    }

    public boolean setValueEncrypted(String storename, String namespace, String key, String value, boolean global, String secretKey) throws Exception, ArrayOfEspExceptionWrapper {
        return this.setValue(storename, namespace, key, CryptoHelper.encryptSHA512AES((String)value, (String)secretKey), global);
    }

    public boolean deleteValue(String storename, String namespace, String key, boolean global) throws Exception, ArrayOfEspExceptionWrapper {
        DeleteRequest request = new DeleteRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setKey(key);
        request.setUserSpecific(!global);
        try {
            DeleteResponse response = ((WsstoreStub)this.stub).delete(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not delete " + key + " for store: " + storename + " namespace: '" + namespace + "'");
            }
            return response.getSuccess();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean deleteNamespace(String storename, String namespace, boolean global, String targetuser) throws Exception, ArrayOfEspExceptionWrapper {
        DeleteNamespaceRequest request = new DeleteNamespaceRequest();
        request.setStoreName(storename);
        request.setNamespace(namespace);
        request.setTargetUser(targetuser);
        request.setUserSpecific(!global);
        try {
            DeleteNamespaceResponse response = ((WsstoreStub)this.stub).deleteNamespace(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not delete namespace" + storename + "." + namespace + " (" + (global ? "global" : (targetuser != null && !targetuser.isEmpty() ? targetuser : "user")) + ")");
            }
            return response.getSuccess();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean createStore(String storename, String description, String type) throws Exception, ArrayOfEspExceptionWrapper {
        CreateStoreRequest request = new CreateStoreRequest();
        request.setName(storename);
        request.setDescription(description);
        request.setType(type);
        try {
            CreateStoreResponse response = ((WsstoreStub)this.stub).createStore(request);
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not create store " + storename);
            }
            return response.getSuccess();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (EspSoapFault e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsstoreStub();
    }
}

