/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.access.AccessTokenGrantType;
import org.hspconsortium.client.auth.access.AccessTokenRequest;
import org.hspconsortium.client.auth.credentials.Credentials;

public abstract class AbstractAccessTokenRequest<T extends Credentials>
implements AccessTokenRequest {
    private Map<String, String> tokenRequestParams = new HashMap<String, String>();
    private String clientId;
    private T credentials;

    protected AbstractAccessTokenRequest(String clientId, T credentials, AccessTokenGrantType grantType) {
        Validate.notNull((Object)clientId, (String)"ClientId must not be null", (Object[])new Object[0]);
        Validate.notNull(credentials, (String)"Credentials must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)grantType), (String)"GrantType must not be null", (Object[])new Object[0]);
        this.tokenRequestParams.put("grant_type", grantType.getParamValue());
        this.clientId = clientId;
        this.credentials = credentials;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public T getCredentials() {
        return this.credentials;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.getMergedParameters();
    }

    private Map<String, String> getMergedParameters() {
        HashMap<String, String> mergedParams = new HashMap<String, String>(this.tokenRequestParams);
        Map<String, String> additionalParams = this.getAdditionalParameters();
        if (additionalParams != null) {
            mergedParams.putAll(this.getAdditionalParameters());
        }
        return mergedParams;
    }

    public abstract Map<String, String> getAdditionalParameters();
}

