/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.hspconsortium.client.auth.access.AccessToken;
import org.hspconsortium.client.auth.access.IdToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

public abstract class AbstractOAuth2AccessToken
implements Serializable,
AccessToken {
    protected final OAuth2AccessToken oAuth2AccessToken;

    public AbstractOAuth2AccessToken(String accessToken, String tokenType, String expires, String scope, String refreshToken, final String idToken) {
        Validate.notNull((Object)accessToken, (String)"AccessToken must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)tokenType, (String)"TokenType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)expires, (String)"Expires must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)scope, (String)"Scope must not be null", (Object[])new Object[0]);
        this.oAuth2AccessToken = new DefaultOAuth2AccessToken(accessToken);
        ((DefaultOAuth2AccessToken)this.oAuth2AccessToken).setTokenType(tokenType);
        ((DefaultOAuth2AccessToken)this.oAuth2AccessToken).setExpiration(this.createExpirationDate(expires));
        ((DefaultOAuth2AccessToken)this.oAuth2AccessToken).setScope(this.createScopeSet(scope));
        ((DefaultOAuth2AccessToken)this.oAuth2AccessToken).setRefreshToken((OAuth2RefreshToken)new DefaultOAuth2RefreshToken(refreshToken));
        ((DefaultOAuth2AccessToken)this.oAuth2AccessToken).setAdditionalInformation((Map)new HashMap<String, Object>(){
            {
                this.put("id_token", idToken);
            }
        });
    }

    private Date createExpirationDate(String expiresIn) {
        return DateUtils.addSeconds((Date)new Date(), (int)Integer.parseInt(expiresIn));
    }

    private Set<String> createScopeSet(String scope) {
        String[] scopeArray = StringUtils.split((String)scope, (String)" ");
        return new HashSet<String>(Arrays.asList(scopeArray));
    }

    public Map<String, Object> getAdditionalInformation() {
        return this.oAuth2AccessToken.getAdditionalInformation();
    }

    public Set<String> getScope() {
        return this.oAuth2AccessToken.getScope();
    }

    public OAuth2RefreshToken getRefreshToken() {
        return this.oAuth2AccessToken.getRefreshToken();
    }

    public String getTokenType() {
        return this.oAuth2AccessToken.getTokenType();
    }

    public boolean isExpired() {
        return this.oAuth2AccessToken.isExpired();
    }

    public Date getExpiration() {
        return this.oAuth2AccessToken.getExpiration();
    }

    public int getExpiresIn() {
        return this.oAuth2AccessToken.getExpiresIn();
    }

    public String getValue() {
        return this.oAuth2AccessToken.getValue();
    }

    @Override
    public String getIdTokenStr() {
        return (String)this.oAuth2AccessToken.getAdditionalInformation().get("id_token");
    }

    public IdToken getIdToken() {
        return new IdToken(this.getIdTokenStr());
    }
}

