/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.codehaus.jackson.map.ObjectMapper;

public class IdToken
implements Serializable {
    String token;
    String joseHeader;
    String claims;
    Map<String, Object> claimsMap;
    String idSignature;

    public IdToken(String token) {
        Validate.notNull((Object)token);
        this.token = token;
        String[] idTokenSegments = token.split("\\.");
        Base64 decoder = new Base64(true);
        byte[] bytes0 = decoder.decode(idTokenSegments[0]);
        this.joseHeader = new String(bytes0);
        byte[] bytes1 = decoder.decode(idTokenSegments[1]);
        this.claims = new String(bytes1);
        try {
            this.claimsMap = (Map)new ObjectMapper().readValue(this.claims, HashMap.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes2 = decoder.decode(idTokenSegments[2]);
        this.idSignature = new String(bytes2);
    }

    public String getToken() {
        return this.token;
    }

    public String getJoseHeader() {
        return this.joseHeader;
    }

    public String getClaims() {
        return this.claims;
    }

    public Map<String, Object> getClaimsMap() {
        return Collections.unmodifiableMap(this.claimsMap);
    }

    public String getIdSignature() {
        return this.idSignature;
    }
}

