/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.hspconsortium.client.auth.access.AbstractOAuth2AccessToken;
import org.hspconsortium.client.auth.access.AccessToken;

public class JsonAccessToken
extends AbstractOAuth2AccessToken
implements AccessToken {
    private JsonObject rootResponse;
    private final String intent;
    private final String smartStyleUrl;
    private final String encounterId;
    private final String patientId;
    private final String locationId;
    private final boolean needPatientBanner;
    private final String resource;

    public JsonAccessToken(JsonObject rootResponse, String accessToken, String tokenType, String expires, String scope, String intent, String smartStyleUrl, String patientId, String encounterId, String locationId, boolean needPatientBanner, String resource, String refreshToken, String idTokenStr) {
        super(accessToken, tokenType, expires, scope, refreshToken, idTokenStr);
        Validate.notNull((Object)rootResponse, (String)"The rootResponse must not be null", (Object[])new Object[0]);
        this.rootResponse = rootResponse;
        this.intent = intent;
        this.smartStyleUrl = smartStyleUrl;
        this.encounterId = encounterId;
        this.patientId = patientId;
        this.locationId = locationId;
        this.needPatientBanner = needPatientBanner;
        this.resource = resource;
    }

    @Override
    public JsonObject getRootResponse() {
        return this.rootResponse;
    }

    @Override
    public String getIntent() {
        return this.intent;
    }

    @Override
    public String getSmartStyleUrl() {
        return this.smartStyleUrl;
    }

    @Override
    public String getEncounterId() {
        return this.encounterId;
    }

    @Override
    public String getPatientId() {
        return this.patientId;
    }

    @Override
    public String getLocationId() {
        return this.locationId;
    }

    @Override
    public boolean needPatientBanner() {
        return this.needPatientBanner;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public List<NameValuePair> asNameValuePairList() {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.intent})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("intent", this.intent));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.smartStyleUrl})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("smart_style_url", this.smartStyleUrl));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.encounterId})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("encounter", this.encounterId));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.patientId})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("patient", this.patientId));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.locationId})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("location", this.locationId));
        }
        if (this.needPatientBanner) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("need_patient_banner", "true"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.resource})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("resource", this.resource));
        }
        return nameValuePairs;
    }
}

