/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import ca.uhn.fhir.context.FhirContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hspconsortium.client.auth.access.AccessToken;
import org.hspconsortium.client.auth.access.AccessTokenProvider;
import org.hspconsortium.client.auth.access.AccessTokenRequest;
import org.hspconsortium.client.auth.access.JsonAccessToken;
import org.hspconsortium.client.auth.access.JsonUserInfo;
import org.hspconsortium.client.auth.access.UserInfo;
import org.hspconsortium.client.auth.credentials.ClientSecretCredentials;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.auth.credentials.JWTCredentials;
import org.hspconsortium.client.auth.validation.IdTokenValidator;

public class JsonAccessTokenProvider
implements AccessTokenProvider<JsonAccessToken> {
    private final FhirContext fhirContext;
    private IdTokenValidator idTokenValidator = new IdTokenValidator.Impl();

    public JsonAccessTokenProvider(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    @Override
    public JsonAccessToken getAccessToken(String tokenEndpointUrl, AccessTokenRequest request) {
        boolean idTokenValidationSuccess;
        JsonObject rootResponse;
        JsonAccessToken jsonAccessToken;
        String idToken;
        String clientId = request.getClientId();
        Credentials clientSecretCredentials = request.getCredentials();
        ArrayList<NameValuePair> paramPairs = new ArrayList<NameValuePair>();
        Map<String, String> parameters = request.getParameters();
        if (parameters != null) {
            for (String param : parameters.keySet()) {
                paramPairs.add((NameValuePair)new BasicNameValuePair(param, parameters.get(param)));
            }
        }
        if ((idToken = (jsonAccessToken = this.buildAccessToken(rootResponse = this.post(tokenEndpointUrl, clientId, clientSecretCredentials, paramPairs), null)).getIdTokenStr()) != null && !(idTokenValidationSuccess = this.idTokenValidator.validate(jsonAccessToken.getIdToken(), tokenEndpointUrl, clientId))) {
            throw new RuntimeException("IdToken is not valid");
        }
        return jsonAccessToken;
    }

    @Override
    public JsonAccessToken refreshAccessToken(String tokenEndpointUrl, AccessTokenRequest request, AccessToken accessToken) {
        String clientId = request.getClientId();
        Credentials clientSecretCredentials = request.getCredentials();
        JsonObject rootResponse = this.post(tokenEndpointUrl, clientId, clientSecretCredentials, accessToken.asNameValuePairList());
        return this.buildAccessToken(rootResponse, new String[0]);
    }

    @Override
    public UserInfo getUserInfo(String userInfoEndpointUrl, JsonAccessToken jsonAccessToken) {
        HttpGet getRequest = new HttpGet(userInfoEndpointUrl);
        getRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
        getRequest.addHeader("Authorization", String.format("Bearer %s", jsonAccessToken.getValue()));
        JsonObject jsonObject = this.processRequest((HttpUriRequest)getRequest);
        return this.buildUserInfo(jsonObject);
    }

    protected JsonAccessToken buildAccessToken(JsonObject rootResponse, String[] params) {
        return new JsonAccessToken(rootResponse, this.getResponseElement("access_token", rootResponse), this.getResponseElement("token_type", rootResponse), this.getResponseElement("expires_in", rootResponse), this.getResponseElement("scope", rootResponse), this.getResponseElement("intent", rootResponse), this.getResponseElement("smart_style_url", rootResponse), this.getResponseElement("patient", rootResponse), this.getResponseElement("encounter", rootResponse), this.getResponseElement("location", rootResponse), Boolean.parseBoolean(this.getResponseElement("need_patient_banner", rootResponse)), this.getResponseElement("resource", rootResponse), this.getResponseElement("refresh_token", rootResponse), this.getResponseElement("id_token", rootResponse));
    }

    protected JsonUserInfo buildUserInfo(JsonObject rootResponse) {
        return new JsonUserInfo(rootResponse, this.getResponseElement("sub", rootResponse), this.getResponseElement("name", rootResponse), this.getResponseElement("preferred_username", rootResponse));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonObject post(String serviceUrl, String clientId, Credentials clientCredentials, List<NameValuePair> transferParams) {
        HttpPost postRequest = new HttpPost(serviceUrl);
        postRequest.addHeader("Content-Type", "application/x-www-form-urlencoded");
        if (clientCredentials instanceof ClientSecretCredentials) {
            Object credentialsObj = clientCredentials.getCredentials();
            if (!(credentialsObj instanceof String)) throw new IllegalArgumentException("Credentials not supported");
            String credentialsStr = (String)credentialsObj;
            if (!StringUtils.isNotBlank((String)clientId) || !StringUtils.isNotBlank((String)credentialsStr)) throw new RuntimeException("Confidential client authorization requires clientId and client secret.");
            JsonAccessTokenProvider.setAuthorizationHeader((HttpRequest)postRequest, clientId, credentialsStr);
        } else {
            if (!(clientCredentials instanceof JWTCredentials)) throw new IllegalArgumentException("Credentials type not supported");
            ((JWTCredentials)clientCredentials).setAudience(serviceUrl);
        }
        try {
            postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(transferParams));
            return this.processRequest((HttpUriRequest)postRequest);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setAuthorizationHeader(HttpRequest request, String clientId, String clientSecret) {
        String authHeader = String.format("%s:%s", clientId, clientSecret);
        String encoded = Base64.encode(authHeader.getBytes());
        request.addHeader("Authorization", String.format("Basic %s", encoded));
    }

    protected JsonObject processRequest(HttpUriRequest request) {
        JsonObject rootResponse = null;
        try {
            HttpResponse response = this.fhirContext.getRestfulClientFactory().getHttpClient().execute(request);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                throw new RuntimeException(String.format("There was a problem attempting to get the access token.\nResponse Status : %s .\nResponse Detail :%s.", response.getStatusLine(), responseString));
            }
            try {
                JsonParser parser = new JsonParser();
                rootResponse = (JsonObject)parser.parse((Reader)new InputStreamReader(response.getEntity().getContent()));
            }
            catch (IOException io_ex) {
                throw new RuntimeException("There was a problem attempting to get the access token", io_ex);
            }
            return rootResponse;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending HTTP Post Payload", ioe);
        }
    }

    protected String getResponseElement(String elementKey, JsonObject rootResponse) {
        JsonElement jsonElement = rootResponse.get(elementKey);
        if (jsonElement != null) {
            return jsonElement.getAsString();
        }
        return null;
    }
}

