/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.hspconsortium.client.auth.access.UserInfo;

public class JsonUserInfo
implements UserInfo {
    private JsonObject rootResponse;
    private final String sub;
    private final String name;
    private final String preferredUsername;

    public JsonUserInfo(JsonObject rootResponse, String sub, String name, String preferredUsername) {
        Validate.notNull((Object)rootResponse, (String)"The rootResponse must not be null", (Object[])new Object[0]);
        this.rootResponse = rootResponse;
        this.sub = sub;
        this.name = name;
        this.preferredUsername = preferredUsername;
    }

    @Override
    public JsonObject getRootResponse() {
        return this.rootResponse;
    }

    @Override
    public String getSub() {
        return this.sub;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public List<NameValuePair> asNameValuePairList() {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sub})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("sub", this.sub));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.name})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("name", this.name));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.preferredUsername})) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("preferred_username", this.preferredUsername));
        }
        return nameValuePairs;
    }
}

