/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.access;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.access.AbstractAccessTokenRequest;
import org.hspconsortium.client.auth.access.AccessTokenGrantType;
import org.hspconsortium.client.auth.credentials.Credentials;

public class RefreshAccessTokenRequest<T extends Credentials>
extends AbstractAccessTokenRequest<T>
implements Serializable {
    private Map<String, String> tokenRequestParams = new HashMap<String, String>();

    public RefreshAccessTokenRequest(String clientId, T clientSecret, String refreshToken) {
        super(clientId, clientSecret, AccessTokenGrantType.REFRESH_TOKEN);
        Validate.notNull((Object)clientId, (String)"the clientId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)refreshToken, (String)"the refreshToken must not be null", (Object[])new Object[0]);
        this.tokenRequestParams.put("client_id", clientId);
        this.tokenRequestParams.put("refresh_token", refreshToken);
    }

    @Override
    public Map<String, String> getAdditionalParameters() {
        return this.tokenRequestParams;
    }
}

