/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.authorizationcode;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.AuthorizationRequest;
import org.hspconsortium.client.auth.Scopes;
import org.hspconsortium.client.controller.FhirEndpoints;

public class AuthorizationCodeRequest
implements AuthorizationRequest,
Serializable {
    private final FhirEndpoints fhirEndpoints;
    private final String clientId;
    private final String responseType;
    private final Scopes scopes;
    private String launchId;
    private final String redirectUri;
    private final String oauthState;

    AuthorizationCodeRequest(FhirEndpoints fhirEndpoints, String clientId, String responseType, Scopes scopes, String launchId, String redirectUri, String oauthState) {
        this(fhirEndpoints, clientId, responseType, scopes, redirectUri, oauthState);
        Validate.notNull((Object)launchId, (String)"the launchId must not be null", (Object[])new Object[0]);
        this.launchId = launchId;
    }

    AuthorizationCodeRequest(FhirEndpoints fhirEndpoints, String clientId, String responseType, Scopes scopes, String redirectUri, String oauthState) {
        Validate.notNull((Object)fhirEndpoints, (String)"the authorizationEndpoints must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)clientId, (String)"the clientId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)responseType, (String)"the responseType must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)scopes, (String)"the scopes must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"the redirectUri must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)oauthState, (String)"the oauthState must not be null", (Object[])new Object[0]);
        this.fhirEndpoints = fhirEndpoints;
        this.clientId = clientId;
        this.responseType = responseType;
        this.scopes = scopes;
        this.redirectUri = redirectUri;
        this.oauthState = oauthState;
    }

    @Override
    public FhirEndpoints getFhirEndpoints() {
        return this.fhirEndpoints;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getResponseType() {
        return this.responseType;
    }

    @Override
    public Scopes getScopes() {
        return this.scopes;
    }

    @Override
    public String getLaunchId() {
        return this.launchId;
    }

    @Override
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public String getOauthState() {
        return this.oauthState;
    }
}

