/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.authorizationcode;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.Scopes;
import org.hspconsortium.client.auth.SimpleScope;
import org.hspconsortium.client.auth.StateProvider;
import org.hspconsortium.client.auth.authorizationcode.AuthorizationCodeRequest;
import org.hspconsortium.client.controller.FhirEndpoints;
import org.hspconsortium.client.controller.FhirEndpointsProvider;

public class AuthorizationCodeRequestBuilder {
    static final String ISSUER_PARAMETER = "iss";
    static final String LAUNCH_ID_PARAMETER = "launch";
    private FhirEndpointsProvider fhirEndpointsProvider;
    private StateProvider stateProvider;

    public AuthorizationCodeRequestBuilder(FhirEndpointsProvider fhirEndpointsProvider, StateProvider stateProvider) {
        this.fhirEndpointsProvider = fhirEndpointsProvider;
        this.stateProvider = stateProvider;
    }

    public AuthorizationCodeRequest buildAuthorizationCodeRequest(HttpServletRequest request, String clientId, String scope, String redirectUri) {
        Map paramMap = request.getParameterMap();
        String launchId = ((String[])paramMap.get(LAUNCH_ID_PARAMETER))[0];
        String fhirServiceURL = ((String[])paramMap.get(ISSUER_PARAMETER))[0];
        return this.buildAuthorizationCodeRequest(fhirServiceURL, launchId, clientId, scope, redirectUri);
    }

    public AuthorizationCodeRequest buildAuthorizationCodeRequest(String fhirServiceURL, String launchId, String clientId, String scope, String redirectUri) {
        Validate.notNull((Object)launchId, (String)"the launchId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)fhirServiceURL, (String)"the fhirServiceURL must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)clientId, (String)"the clientId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)scope, (String)"the scope must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"the redirectUri must not be null", (Object[])new Object[0]);
        Scopes scopes = new Scopes();
        scopes.add(new SimpleScope(scope));
        FhirEndpoints authEndpoints = this.fhirEndpointsProvider.getEndpoints(fhirServiceURL);
        return new AuthorizationCodeRequest(authEndpoints, clientId, "code", scopes, launchId, redirectUri, this.stateProvider.getNewState());
    }

    public AuthorizationCodeRequest buildStandAloneAuthorizationCodeRequest(String fhirServiceURL, String clientId, String scope, String redirectUri) {
        Validate.notNull((Object)fhirServiceURL, (String)"the fhirServiceURL must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)clientId, (String)"the clientId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)scope, (String)"the scope must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"the redirectUri must not be null", (Object[])new Object[0]);
        Scopes scopes = new Scopes();
        scopes.add(new SimpleScope(scope));
        FhirEndpoints authEndpoints = this.fhirEndpointsProvider.getEndpoints(fhirServiceURL);
        return new AuthorizationCodeRequest(authEndpoints, clientId, "code", scopes, redirectUri, this.stateProvider.getNewState());
    }
}

