/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.credentials;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import org.hspconsortium.client.auth.credentials.Credentials;

public class JWTCredentials
implements Credentials<JWT> {
    private RSAPrivateKey rsaPrivateKey;
    private String issuer;
    private String subject;
    private String audience;
    private Long durationSeconds;
    private String tokenReference;

    public JWTCredentials(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public Long getDuration() {
        return this.durationSeconds;
    }

    public void setDuration(Long durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public String getTokenReference() {
        return this.tokenReference;
    }

    public void setTokenReference(String tokenReference) {
        this.tokenReference = tokenReference;
    }

    @Override
    public JWT getCredentials() {
        return this.generateAuthenticationJwt();
    }

    private JWT generateAuthenticationJwt() {
        RSASSASigner signer = new RSASSASigner(this.rsaPrivateKey);
        JWTClaimsSet claimsSet = new JWTClaimsSet();
        claimsSet.setIssuer(this.issuer);
        claimsSet.setSubject(this.subject);
        claimsSet.setAudience(this.audience);
        claimsSet.setIssueTime(new Date());
        claimsSet.setExpirationTime(new Date(new Date().getTime() + this.durationSeconds * 1000L));
        claimsSet.setJWTID(this.tokenReference);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), (ReadOnlyJWTClaimsSet)claimsSet);
        try {
            signedJWT.sign((JWSSigner)signer);
        }
        catch (JOSEException jose_ex) {
            throw new RuntimeException("Error signing JSON Web Token.", jose_ex);
        }
        return signedJWT;
    }
}

