/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.auth.validation;

import java.util.Date;
import java.util.Map;
import org.hspconsortium.client.auth.access.IdToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IdTokenValidator {
    public boolean validate(IdToken var1, String var2, String var3);

    public static class Impl
    implements IdTokenValidator {
        private static final Logger LOGGER = LoggerFactory.getLogger(Impl.class);

        @Override
        public boolean validate(IdToken idToken, String issuerUrl, String clientId) {
            Map<String, Object> claimsMap = idToken.getClaimsMap();
            String tokenIss = (String)claimsMap.get("iss");
            if (tokenIss == null || !issuerUrl.contains(tokenIss)) {
                LOGGER.error("Token ISS does not match! expected [" + issuerUrl + "] received: [" + tokenIss + "]");
                return false;
            }
            if (claimsMap.get("sub") == null) {
                LOGGER.error("Token Sub is required");
                return false;
            }
            String tokenAud = (String)claimsMap.get("aud");
            if (tokenAud == null || !tokenAud.equals(clientId)) {
                LOGGER.error("Token Aud does not match! expected [" + clientId + "] received: [" + tokenAud + "]");
                return false;
            }
            Object tokenExpObj = claimsMap.get("exp");
            if (tokenExpObj == null) {
                LOGGER.error("Token Exp is required");
                return false;
            }
            Long tokenExp = null;
            if (tokenExpObj instanceof Integer) {
                tokenExp = new Long(((Integer)tokenExpObj).intValue());
            } else if (tokenExpObj instanceof Long) {
                tokenExp = (Long)tokenExpObj;
            }
            Date now = new Date();
            if (now.getTime() > tokenExp * 1000L) {
                LOGGER.error("Token Exp has expired! now [" + now.getTime() + "] exp: [" + tokenExp * 1000L + "] diff: [" + (tokenExp * 1000L - now.getTime()) + "]");
                return false;
            }
            if (claimsMap.get("iat") == null) {
                LOGGER.error("Token Iat is required");
                return false;
            }
            return true;
        }
    }
}

