/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.controller;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.hspconsortium.client.auth.authorizationcode.AuthorizationCodeRequest;
import org.hspconsortium.client.auth.authorizationcode.AuthorizationCodeRequestBuilder;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.session.Session;
import org.hspconsortium.client.session.authorizationcode.AuthorizationCodeSessionFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AuthorizationController<C extends Credentials> {
    private final AuthorizationCodeSessionFactory<C> authorizationCodeSessionFactory;
    private final String appEntryPoint;
    private final String clientId;
    private final String redirectUri;
    private final String scope;
    private AuthorizationCodeRequestBuilder authorizationCodeRequestBuilder;

    @Inject
    public AuthorizationController(AuthorizationCodeSessionFactory<C> authorizationCodeSessionFactory, String appEntryPoint, String clientId, String redirectUri, String scope, AuthorizationCodeRequestBuilder authorizationCodeRequestBuilder) {
        Validate.notNull(authorizationCodeSessionFactory, (String)"AuthorizationCodeSessionFactory is required");
        Validate.notNull((Object)appEntryPoint, (String)"AppEntryPoint is required");
        Validate.notNull((Object)clientId, (String)"ClientId is required");
        Validate.notNull((Object)redirectUri, (String)"RedirectUri is required");
        Validate.notNull((Object)scope, (String)"Scope is required");
        Validate.notNull((Object)authorizationCodeRequestBuilder, (String)"AuthorizationCodeAuthorizer is required");
        this.authorizationCodeSessionFactory = authorizationCodeSessionFactory;
        this.appEntryPoint = appEntryPoint;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.authorizationCodeRequestBuilder = authorizationCodeRequestBuilder;
    }

    @RequestMapping(value={"/launch"}, method={RequestMethod.GET})
    public void handleLaunchRequest(HttpServletRequest request, HttpServletResponse response) {
        AuthorizationCodeRequest authorizationCodeRequest = this.authorizationCodeRequestBuilder.buildAuthorizationCodeRequest(request, this.clientId, this.scope, this.redirectUri);
        this.authorizationCodeSessionFactory.registerInContext(authorizationCodeRequest.getOauthState(), authorizationCodeRequest);
        response.setStatus(307);
        response.setHeader("Location", authorizationCodeRequest.getFhirEndpoints().getAuthorizationEndpoint() + "?client_id=" + authorizationCodeRequest.getClientId() + "&response_type=" + authorizationCodeRequest.getResponseType() + "&scope=" + authorizationCodeRequest.getScopes().asParamValue() + "&launch=" + authorizationCodeRequest.getLaunchId() + "&redirect_uri=" + authorizationCodeRequest.getRedirectUri() + "&aud=" + authorizationCodeRequest.getFhirEndpoints().getFhirServiceApi() + "&state=" + authorizationCodeRequest.getOauthState());
    }

    @RequestMapping(value={"/redirect"}, method={RequestMethod.GET})
    public void handleRedirectResponse(HttpServletRequest request, HttpServletResponse response) {
        Map params = request.getParameterMap();
        String oauthState = ((String[])params.get("state"))[0];
        String authorizationCode = ((String[])params.get("code"))[0];
        Session session = this.authorizationCodeSessionFactory.createSession(oauthState, authorizationCode);
        request.getSession().setAttribute(this.authorizationCodeSessionFactory.getSessionKey(), (Object)session);
        try {
            response.sendRedirect(this.appEntryPoint);
        }
        catch (IOException e) {
            throw new RuntimeException("Error sending handling redirect response", e);
        }
    }
}

