/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.controller;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import java.util.List;
import org.hspconsortium.client.controller.FhirEndpoints;

public interface FhirEndpointsProvider {
    public FhirEndpoints getEndpoints(String var1);

    public static class Impl
    implements FhirEndpointsProvider {
        private static final String AUTH_ENDPOINT_EXTENSION = "http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris#authorize";
        private static final String TOKEN_ENDPOINT_EXTENSION = "http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris#token";
        private static final String URIS_ENDPOINT_EXTENSION = "http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris";
        private final FhirContext fhirContext;

        public Impl(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
        }

        @Override
        public FhirEndpoints getEndpoints(String fhirServiceUrl) {
            Conformance conformance;
            try {
                IGenericClient client = this.fhirContext.newRestfulGenericClient(fhirServiceUrl);
                conformance = (Conformance)client.fetchConformance().ofType(Conformance.class).execute();
            }
            catch (FhirClientConnectionException e) {
                throw new FhirClientConnectionException(this.fhirContext.getLocalizer().getMessage(RestfulClientFactory.class, "failedToRetrieveConformance", new Object[]{fhirServiceUrl + "/" + "metadata"}), (Throwable)e);
            }
            Conformance.Rest rest = (Conformance.Rest)conformance.getRest().get(0);
            Conformance.RestSecurity restSecurity = rest.getSecurity();
            List extensions = restSecurity.getUndeclaredExtensions();
            String authEndpoint = null;
            String tokenEndpoint = null;
            String userInfoEndpoint = null;
            for (ExtensionDt extensionDt : extensions) {
                if (!extensionDt.getUrl().equalsIgnoreCase(URIS_ENDPOINT_EXTENSION)) continue;
                List urisExtensions = extensionDt.getUndeclaredExtensions();
                for (ExtensionDt uriExtensionDt : urisExtensions) {
                    if (uriExtensionDt.getUrl().equalsIgnoreCase("authorize")) {
                        authEndpoint = uriExtensionDt.getValueAsPrimitive().getValueAsString();
                        continue;
                    }
                    if (!uriExtensionDt.getUrl().equalsIgnoreCase("token")) continue;
                    tokenEndpoint = uriExtensionDt.getValueAsPrimitive().getValueAsString();
                    userInfoEndpoint = tokenEndpoint.replaceFirst("token", "userinfo");
                }
            }
            return new FhirEndpoints(fhirServiceUrl, authEndpoint, tokenEndpoint, userInfoEndpoint);
        }
    }
}

