/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.resource.BaseConformance;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.gclient.ICreate;
import ca.uhn.fhir.rest.gclient.IDelete;
import ca.uhn.fhir.rest.gclient.IFetchConformanceUntyped;
import ca.uhn.fhir.rest.gclient.IGetPage;
import ca.uhn.fhir.rest.gclient.IGetTags;
import ca.uhn.fhir.rest.gclient.IHistory;
import ca.uhn.fhir.rest.gclient.IMeta;
import ca.uhn.fhir.rest.gclient.IOperation;
import ca.uhn.fhir.rest.gclient.IRead;
import ca.uhn.fhir.rest.gclient.ITransaction;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import ca.uhn.fhir.rest.gclient.IUpdate;
import ca.uhn.fhir.rest.gclient.IValidate;
import ca.uhn.fhir.rest.server.EncodingEnum;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hspconsortium.client.auth.access.AccessToken;
import org.hspconsortium.client.auth.access.AccessTokenProvider;
import org.hspconsortium.client.auth.access.AccessTokenRequest;
import org.hspconsortium.client.auth.access.JsonAccessToken;
import org.hspconsortium.client.auth.access.JsonAccessTokenProvider;
import org.hspconsortium.client.auth.access.UserInfo;
import org.hspconsortium.client.session.FhirSession;

public abstract class AbstractFhirSession
implements FhirSession {
    protected final FhirContext hapiFhirContext;
    protected final IGenericClient client;
    protected AccessToken accessToken;
    protected final AccessTokenRequest refreshTokenRequest;
    protected final String tokenEndpoint;
    protected final UserInfo userInfo;
    protected IClientInterceptor clientInterceptor;
    protected AccessTokenProvider accessTokenProvider;

    public AbstractFhirSession(FhirContext hapiFhirContext, String fhirServiceApi, AccessToken accessToken, UserInfo userInfo, AccessTokenRequest refreshTokenRequest, String tokenEndpoint) {
        this.hapiFhirContext = hapiFhirContext;
        Validate.notNull((Object)fhirServiceApi, (String)"the fhirServiceApi must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)accessToken, (String)"the accessToken must not be null", (Object[])new Object[0]);
        this.accessToken = accessToken;
        this.refreshTokenRequest = refreshTokenRequest;
        this.tokenEndpoint = tokenEndpoint;
        this.client = this.hapiFhirContext.newRestfulGenericClient(fhirServiceApi);
        if (refreshTokenRequest == null) {
            this.client.registerInterceptor((IClientInterceptor)new BearerTokenAuthInterceptor(accessToken.getValue()));
        } else {
            this.client.registerInterceptor((IClientInterceptor)new AutoRefreshingBearerTokenAuthorizationHeaderInterceptor(30));
        }
        this.userInfo = userInfo;
    }

    public void setAccessTokenProvider(JsonAccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getIdTokenProfileClaim() {
        AccessToken accessToken = this.getAccessToken();
        if (accessToken instanceof JsonAccessToken) {
            Map<String, Object> claims = ((JsonAccessToken)accessToken).getIdToken().getClaimsMap();
            return (String)claims.get("profile");
        }
        return null;
    }

    public FhirContext getFhirContext() {
        return this.hapiFhirContext;
    }

    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    public void setEncoding(EncodingEnum encodingEnum) {
        this.client.setEncoding(encodingEnum);
    }

    public void setPrettyPrint(Boolean aBoolean) {
        this.client.setPrettyPrint(aBoolean);
    }

    public String getServerBase() {
        return this.client.getServerBase();
    }

    public BaseConformance conformance() {
        return this.client.conformance();
    }

    public IFetchConformanceUntyped fetchConformance() {
        return this.client.fetchConformance();
    }

    public ICreate create() {
        return this.client.create();
    }

    @Deprecated
    public MethodOutcome create(IBaseResource theResource) {
        return this.client.create(theResource);
    }

    public IDelete delete() {
        return this.client.delete();
    }

    @Deprecated
    public MethodOutcome delete(Class<? extends IBaseResource> theType, IdDt theId) {
        return this.client.delete(theType, theId);
    }

    @Deprecated
    public MethodOutcome delete(Class<? extends IBaseResource> theType, String theId) {
        return this.client.delete(theType, theId);
    }

    public void forceConformanceCheck() throws FhirClientConnectionException {
        this.client.forceConformanceCheck();
    }

    public IGetTags getTags() {
        return this.client.getTags();
    }

    public IHistory history() {
        return this.client.history();
    }

    @Deprecated
    public <T extends IBaseResource> Bundle history(Class<T> theType, IdDt theId, DateTimeDt theSince, Integer theLimit) {
        return this.client.history(theType, theId, theSince, theLimit);
    }

    @Deprecated
    public <T extends IBaseResource> Bundle history(Class<T> theType, String theId, DateTimeDt theSince, Integer theLimit) {
        return this.client.history(theType, theId, theSince, theLimit);
    }

    public IGetPage loadPage() {
        return this.client.loadPage();
    }

    public IOperation operation() {
        return this.client.operation();
    }

    public IRead read() {
        return this.client.read();
    }

    public <T extends IBaseResource> T read(Class<T> tClass, String s) {
        return (T)this.client.read(tClass, s);
    }

    public <T extends IBaseResource> T read(Class<T> tClass, UriDt uriDt) {
        return (T)this.client.read(tClass, uriDt);
    }

    public IBaseResource read(UriDt uriDt) {
        return this.client.read(uriDt);
    }

    public void registerInterceptor(IClientInterceptor iClientInterceptor) {
        this.client.registerInterceptor(iClientInterceptor);
    }

    public IUntypedQuery search() {
        return this.client.search();
    }

    public <T extends IBaseResource> Bundle search(Class<T> tClass, Map<String, List<IQueryParameterType>> stringListMap) {
        return this.client.search(tClass, stringListMap);
    }

    public <T extends IBaseResource> Bundle search(Class<T> tClass, UriDt uriDt) {
        return this.client.search(tClass, uriDt);
    }

    public Bundle search(UriDt uriDt) {
        return this.client.search(uriDt);
    }

    public void setLogRequestAndResponse(boolean b) {
        this.client.setLogRequestAndResponse(b);
    }

    public ITransaction transaction() {
        return this.client.transaction();
    }

    public IValidate validate() {
        return this.client.validate();
    }

    public List<IBaseResource> transaction(List<IBaseResource> iBaseResources) {
        return this.client.transaction(iBaseResources);
    }

    public void unregisterInterceptor(IClientInterceptor iClientInterceptor) {
        this.client.unregisterInterceptor(iClientInterceptor);
    }

    public IUpdate update() {
        return this.client.update();
    }

    public MethodOutcome update(IdDt theId, IBaseResource theResource) {
        return this.client.update(theId, theResource);
    }

    public MethodOutcome update(String theId, IBaseResource theResource) {
        return this.client.update(theId, theResource);
    }

    public MethodOutcome validate(IBaseResource theResource) {
        return this.client.validate(theResource);
    }

    public <T extends IBaseResource> T vread(Class<T> tClass, IdDt idDt) {
        return (T)this.client.vread(tClass, idDt);
    }

    @Deprecated
    public <T extends IBaseResource> T vread(Class<T> theType, IdDt theId, IdDt theVersionId) {
        return (T)this.client.vread(theType, theId, theVersionId);
    }

    public <T extends IBaseResource> T vread(Class<T> tClass, String s, String s1) {
        return (T)this.client.vread(tClass, s, s1);
    }

    public <T extends IBaseResource> T fetchResourceFromUrl(Class<T> aClass, String s) {
        return (T)this.client.fetchResourceFromUrl(aClass, s);
    }

    public IMeta meta() {
        return this.client.meta();
    }

    private class AutoRefreshingBearerTokenAuthorizationHeaderInterceptor
    implements IClientInterceptor {
        private final int refreshThreshold;

        public AutoRefreshingBearerTokenAuthorizationHeaderInterceptor(int refreshThreshold) {
            this.refreshThreshold = refreshThreshold;
        }

        public void interceptRequest(HttpRequestBase httpRequestBase) {
            if (AbstractFhirSession.this.accessToken.getExpiresIn() <= this.refreshThreshold) {
                AbstractFhirSession.this.accessToken = AbstractFhirSession.this.accessTokenProvider.refreshAccessToken(AbstractFhirSession.this.tokenEndpoint, AbstractFhirSession.this.refreshTokenRequest, AbstractFhirSession.this.accessToken);
            }
            httpRequestBase.addHeader("Authorization", String.format("Bearer %s", AbstractFhirSession.this.accessToken.getValue()));
        }

        public void interceptResponse(HttpResponse response) throws IOException {
        }
    }
}

