/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session;

import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hspconsortium.client.session.Session;

public class FluentPatientContextWrapper {
    private Session session;

    public FluentPatientContextWrapper(Session session) {
        this.session = session;
        if (session.getContext().getPatientResource() == null) {
            throw new RuntimeException("Cannot have PatientContextWrapper without Patient");
        }
    }

    public Patient get() {
        return this.session.getContext().getPatientResource();
    }

    public <T extends IBaseResource> Collection<T> find(Class<T> clazz, ICriterion<?> ... criterion) {
        String patientId = this.session.getContext().getPatientResource().getId().getIdPart();
        IQuery queryBuilder = this.session.search().forResource(clazz);
        queryBuilder.where(this.findPatientReferenceOnResource(clazz).hasId(patientId));
        for (ICriterion<?> theCriterion : criterion) {
            queryBuilder = queryBuilder.and(theCriterion);
        }
        Bundle results = (Bundle)queryBuilder.execute();
        return this.asCollection(results);
    }

    private <T extends IBaseResource> Collection<T> asCollection(Bundle results) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        for (BundleEntry entry : results.getEntries()) {
            list.add(entry.getResource());
        }
        return list;
    }

    private ReferenceClientParam findPatientReferenceOnResource(Class<? extends IBaseResource> clazz) {
        try {
            Field field = clazz.getDeclaredField("PATIENT");
            return (ReferenceClientParam)field.get(ReferenceClientParam.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Resource: [" + clazz + "] does not have a PATIENT field", e);
        }
    }
}

