/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import org.hspconsortium.client.session.FluentPatientContextWrapper;
import org.hspconsortium.client.session.Session;

public class FluentSessionContextWrapper {
    protected Session session;
    protected FluentPatientContextWrapper fluentPatientContextWrapper;
    protected boolean enableCaching = true;
    private Patient priorPatient;
    private Encounter priorEncounter;
    private Location priorLocation;
    private IResource priorUserResource;
    private boolean localizeClaimUrl = true;

    public FluentSessionContextWrapper(Session session) {
        this(session, true);
    }

    public FluentSessionContextWrapper(Session session, boolean localizeClaimUrl) {
        this.session = session;
        this.localizeClaimUrl = localizeClaimUrl;
    }

    public boolean getLocalizeClaimUrl() {
        return this.localizeClaimUrl;
    }

    public void setLocalizeClaimUrl(boolean doLocalizeClaimUrl) {
        this.localizeClaimUrl = doLocalizeClaimUrl;
    }

    public String getPatientId() {
        return this.session.getAccessToken().getPatientId();
    }

    public FluentPatientContextWrapper getPatientContext() {
        if (this.fluentPatientContextWrapper == null && this.session.getContext().getPatientResource() != null) {
            this.fluentPatientContextWrapper = new FluentPatientContextWrapper(this.session);
        }
        return this.fluentPatientContextWrapper;
    }

    public Patient getPatientResource() {
        String patientId = this.getPatientId();
        if (patientId != null) {
            if (this.enableCaching && this.priorPatient != null && this.priorPatient.getId() != null && patientId.equals(this.priorPatient.getId().getIdPart())) {
                return this.priorPatient;
            }
            this.priorPatient = (Patient)this.session.read().resource(Patient.class).withId(patientId).execute();
            return this.priorPatient;
        }
        this.priorPatient = null;
        return null;
    }

    public String getEncounterId() {
        return this.session.getAccessToken().getEncounterId();
    }

    public Encounter getEncounterResource() {
        String encounterId = this.getEncounterId();
        if (encounterId != null) {
            if (this.enableCaching && this.priorEncounter != null && this.priorEncounter.getId() != null && encounterId.equals(this.priorEncounter.getId().getIdPart())) {
                return this.priorEncounter;
            }
            this.priorEncounter = (Encounter)this.session.read().resource(Encounter.class).withId(encounterId).execute();
            return this.priorEncounter;
        }
        this.priorEncounter = null;
        return null;
    }

    public String getLocationId() {
        return this.session.getAccessToken().getLocationId();
    }

    public Location getLocationResource() {
        String locationId = this.getLocationId();
        if (locationId != null) {
            if (this.enableCaching && this.priorLocation != null && this.priorLocation.getId() != null && locationId.equals(this.priorLocation.getId().getIdPart())) {
                return this.priorLocation;
            }
            this.priorLocation = (Location)this.session.read().resource(Location.class).withId(locationId).execute();
            return this.priorLocation;
        }
        this.priorLocation = null;
        return null;
    }

    public String getIdTokenProfileClaim() {
        return this.session.getIdTokenProfileClaim();
    }

    public IResource getCurrentUserResource() {
        String profileClaim = this.getIdTokenProfileClaim();
        if (profileClaim != null) {
            String serverBase = this.extractClaimServerBase(profileClaim);
            if (this.localizeClaimUrl || serverBase.equalsIgnoreCase(this.session.getServerBase())) {
                String[] claimParts = profileClaim.split("/");
                String resourceType = this.extractClaimResource(claimParts);
                String resourceId = this.extractClaimResourceId(claimParts);
                if (this.enableCaching && this.priorUserResource != null && this.priorUserResource.getId() != null && resourceId.equals(this.priorUserResource.getId().getIdPart())) {
                    return this.priorUserResource;
                }
                if (!resourceId.isEmpty() && !resourceType.isEmpty()) {
                    this.priorUserResource = (IResource)this.session.read().resource(resourceType).withId(resourceId).execute();
                    return this.priorUserResource;
                }
            }
        } else {
            this.priorUserResource = null;
            return null;
        }
        return null;
    }

    private String extractClaimServerBase(String profileClaim) {
        if (profileClaim.contains("Practitioner")) {
            return profileClaim.substring(0, profileClaim.indexOf("Practitioner") - 1);
        }
        if (profileClaim.contains("Patient")) {
            return profileClaim.substring(0, profileClaim.indexOf("Patient") - 1);
        }
        throw new RuntimeException("Unsupported claim base");
    }

    private String extractClaimResource(String[] claimParts) {
        for (String token : claimParts) {
            if (token.equals("Practitioner")) {
                return token;
            }
            if (!token.equals("Patient")) continue;
            return token;
        }
        throw new RuntimeException("ClaimResource not supported");
    }

    private String extractClaimResourceId(String[] claimParts) {
        boolean returnNext = false;
        for (String token : claimParts) {
            if (returnNext) {
                return token;
            }
            if (token.equals("Practitioner")) {
                returnNext = true;
                continue;
            }
            if (!token.equals("Patient")) continue;
            returnNext = true;
        }
        throw new RuntimeException("ClaimResource not supported");
    }

    public IUntypedQuery search() {
        return this.session.search();
    }

    public void setEnableCaching(boolean enableCaching) {
        this.enableCaching = enableCaching;
    }

    public boolean getEnableCaching() {
        return this.enableCaching;
    }

    public void resetCache() {
        this.priorPatient = null;
        this.priorEncounter = null;
        this.priorLocation = null;
    }
}

