/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session.authorizationcode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.access.AbstractAccessTokenRequest;
import org.hspconsortium.client.auth.access.AccessTokenGrantType;
import org.hspconsortium.client.auth.credentials.Credentials;

public class AuthorizationCodeAccessTokenRequest<T extends Credentials>
extends AbstractAccessTokenRequest<T>
implements Serializable {
    private Map<String, String> tokenRequestParams = new HashMap<String, String>();

    public AuthorizationCodeAccessTokenRequest(String clientId, T clientCredentials, String authorizationCode, String redirectUri) {
        super(clientId, clientCredentials, AccessTokenGrantType.AUTHORIZATION_CODE);
        Validate.notNull((Object)authorizationCode, (String)"the authorizationCode must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"the redirectUri must not be null", (Object[])new Object[0]);
        this.tokenRequestParams.put("code", authorizationCode);
        this.tokenRequestParams.put("redirect_uri", redirectUri);
    }

    @Override
    public Map<String, String> getAdditionalParameters() {
        return this.tokenRequestParams;
    }
}

