/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session.authorizationcode;

import ca.uhn.fhir.context.FhirContext;
import org.apache.commons.lang.Validate;
import org.hspconsortium.client.auth.access.AccessToken;
import org.hspconsortium.client.auth.access.AccessTokenProvider;
import org.hspconsortium.client.auth.access.UserInfo;
import org.hspconsortium.client.auth.authorizationcode.AuthorizationCodeRequest;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.session.FhirSessionContext;
import org.hspconsortium.client.session.FhirSessionContextHolder;
import org.hspconsortium.client.session.Session;
import org.hspconsortium.client.session.SessionKeyRegistry;
import org.hspconsortium.client.session.authorizationcode.AuthorizationCodeAccessTokenRequest;

public class AuthorizationCodeSessionFactory<C extends Credentials> {
    private final FhirContext hapiFhirContext;
    private final String sessionKey;
    private final AccessTokenProvider accessTokenProvider;
    private final String clientId;
    private final C clientCredentials;
    private final String redirectUri;
    private FhirSessionContextHolder fhirSessionContextHolder;

    public AuthorizationCodeSessionFactory(FhirContext hapiFhirContext, SessionKeyRegistry sessionKeyRegistry, String sessionKey, FhirSessionContextHolder fhirSessionContextHolder, AccessTokenProvider accessTokenProvider, String clientId, C clientCredentials, String redirectUri) {
        this.hapiFhirContext = hapiFhirContext;
        sessionKeyRegistry.registerSessionKey(sessionKey);
        this.sessionKey = sessionKey;
        this.fhirSessionContextHolder = fhirSessionContextHolder;
        this.accessTokenProvider = accessTokenProvider;
        this.clientId = clientId;
        this.clientCredentials = clientCredentials;
        this.redirectUri = redirectUri;
    }

    public void registerInContext(String oauthState, AuthorizationCodeRequest authorizationCodeRequest) {
        FhirSessionContext fhirSessionContext = this.fhirSessionContextHolder.get(oauthState);
        if (fhirSessionContext == null) {
            fhirSessionContext = new FhirSessionContext(oauthState);
            this.fhirSessionContextHolder.put(oauthState, fhirSessionContext);
        }
        fhirSessionContext.setAuthorizationCodeRequest(authorizationCodeRequest);
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public Session createSession(String oauthState, String authorizationCode) {
        FhirSessionContext fhirSessionContext = this.fhirSessionContextHolder.get(oauthState);
        AuthorizationCodeRequest authorizationCodeRequest = fhirSessionContext.getAuthorizationCodeRequest();
        Validate.notNull((Object)authorizationCodeRequest, (String)("AuthorizationCodeRequest not found for oauthState: " + oauthState));
        Validate.isTrue((boolean)this.clientId.equals(authorizationCodeRequest.getClientId()), (String)"AuthorizationCodeRequest.clientId does not match");
        String fhirServiceUrl = authorizationCodeRequest.getFhirEndpoints().getFhirServiceApi();
        String tokenEndpoint = authorizationCodeRequest.getFhirEndpoints().getTokenEndpoint();
        String userInfoEndpoint = authorizationCodeRequest.getFhirEndpoints().getUserInfoEndpoint();
        AuthorizationCodeAccessTokenRequest<C> authorizationCodeAccessTokenRequest = new AuthorizationCodeAccessTokenRequest<C>(this.clientId, this.clientCredentials, authorizationCode, this.redirectUri);
        Object accessToken = this.accessTokenProvider.getAccessToken(tokenEndpoint, authorizationCodeAccessTokenRequest);
        UserInfo userInfo = null;
        if (accessToken.getIdTokenStr() != null) {
            userInfo = this.accessTokenProvider.getUserInfo(userInfoEndpoint, accessToken);
        }
        return new Session(this.hapiFhirContext, fhirServiceUrl, (AccessToken)accessToken, userInfo);
    }
}

