/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session.clientcredentials;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.client.auth.Scopes;
import org.hspconsortium.client.auth.access.AbstractAccessTokenRequest;
import org.hspconsortium.client.auth.access.AccessTokenGrantType;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.auth.credentials.JWTCredentials;

public class ClientCredentialsAccessTokenRequest<T extends Credentials>
extends AbstractAccessTokenRequest<T>
implements Serializable {
    private Map<String, String> tokenRequestParams = new HashMap<String, String>();

    public ClientCredentialsAccessTokenRequest(String clientId, T clientCredentials, Scopes scopes) {
        super(clientId, clientCredentials, AccessTokenGrantType.CLIENT_CREDENTIALS);
        Validate.notNull((Object)scopes, (String)"Scopes must not be null", (Object[])new Object[0]);
        this.tokenRequestParams.put("scope", scopes.asParamValue());
        if (clientCredentials instanceof JWTCredentials) {
            Validate.notNull((Object)((JWTCredentials)clientCredentials).getIssuer(), (String)"Issuer/Client ID must not ne null", (Object[])new Object[0]);
            Validate.notNull((Object)((JWTCredentials)clientCredentials).getSubject(), (String)"Subject/Client ID must not ne null", (Object[])new Object[0]);
            Validate.notNull((Object)((JWTCredentials)clientCredentials).getAudience(), (String)"Authorization server's token URL must not ne null", (Object[])new Object[0]);
            Validate.notNull((Object)((JWTCredentials)clientCredentials).getDuration(), (String)"Expiration time must not ne null", (Object[])new Object[0]);
            this.tokenRequestParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            this.tokenRequestParams.put("client_assertion", ((JWTCredentials)clientCredentials).getCredentials().serialize());
        }
    }

    @Override
    public Map<String, String> getAdditionalParameters() {
        return this.tokenRequestParams;
    }
}

