/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session.clientcredentials;

import ca.uhn.fhir.context.FhirContext;
import org.hspconsortium.client.auth.Scopes;
import org.hspconsortium.client.auth.access.AccessToken;
import org.hspconsortium.client.auth.access.AccessTokenProvider;
import org.hspconsortium.client.auth.access.UserInfo;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.auth.credentials.JWTCredentials;
import org.hspconsortium.client.controller.FhirEndpointsProvider;
import org.hspconsortium.client.session.Session;
import org.hspconsortium.client.session.clientcredentials.ClientCredentialsAccessTokenRequest;

public class ClientCredentialsSessionFactory<C extends Credentials> {
    private final FhirContext hapiFhirContext;
    private final AccessTokenProvider accessTokenProvider;
    private final FhirEndpointsProvider fhirEndpointsProvider;
    private final String fhirServiceUrl;
    private final String clientId;
    private final C clientCredentials;
    private final Scopes scopes;

    public ClientCredentialsSessionFactory(FhirContext hapiFhirContext, AccessTokenProvider accessTokenProvider, FhirEndpointsProvider fhirEndpointsProvider, String fhirServiceUrl, String clientId, C clientCredentials, Scopes scopes) {
        this.hapiFhirContext = hapiFhirContext;
        this.accessTokenProvider = accessTokenProvider;
        this.fhirEndpointsProvider = fhirEndpointsProvider;
        this.fhirServiceUrl = fhirServiceUrl;
        this.clientId = clientId;
        this.clientCredentials = clientCredentials;
        this.scopes = scopes;
    }

    public Session createSession() {
        String tokenEndpoint = this.fhirEndpointsProvider.getEndpoints(this.fhirServiceUrl).getTokenEndpoint();
        String userInfoEndpoint = this.fhirEndpointsProvider.getEndpoints(this.fhirServiceUrl).getUserInfoEndpoint();
        if (this.clientCredentials instanceof JWTCredentials) {
            ((JWTCredentials)this.clientCredentials).setAudience(tokenEndpoint);
        }
        ClientCredentialsAccessTokenRequest<C> clientCredentialsAccessTokenRequest = new ClientCredentialsAccessTokenRequest<C>(this.clientId, this.clientCredentials, this.scopes);
        Object accessToken = this.accessTokenProvider.getAccessToken(tokenEndpoint, clientCredentialsAccessTokenRequest);
        UserInfo userInfo = null;
        if (accessToken.getIdTokenStr() != null) {
            userInfo = this.accessTokenProvider.getUserInfo(userInfoEndpoint, accessToken);
        }
        return new Session(this.hapiFhirContext, this.fhirServiceUrl, (AccessToken)accessToken, userInfo);
    }
}

