/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.client.session.impl;

import java.util.HashMap;
import java.util.Map;
import org.hspconsortium.client.session.FhirSessionContext;
import org.hspconsortium.client.session.FhirSessionContextHolder;

public class SimpleFhirSessionContextHolder
implements FhirSessionContextHolder {
    private static final Map<String, FhirSessionContext> globalFhirSessionContextMap = new HashMap<String, FhirSessionContext>();

    @Override
    public FhirSessionContext create(String oauthState) {
        if (globalFhirSessionContextMap.containsKey(oauthState)) {
            throw new IllegalArgumentException("FhirSessionContext already exists for state: " + oauthState);
        }
        return this.put(oauthState, new FhirSessionContext(oauthState));
    }

    @Override
    public FhirSessionContext get(String oauthState) {
        return globalFhirSessionContextMap.get(oauthState);
    }

    @Override
    public FhirSessionContext put(String oauthState, FhirSessionContext fhirSessionContext) {
        globalFhirSessionContextMap.put(oauthState, fhirSessionContext);
        return fhirSessionContext;
    }
}

