/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorDataTable
extends RowSetNavigatorData {
    final Session session;
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    Row currentRow;
    int maxMemoryRowCount;
    boolean isClosed;
    int visibleColumnCount;
    boolean isAggregate;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    Object[] tempRowData;
    boolean reindexTable;
    private Index mainIndex;
    private Index fullIndex;
    private Index orderIndex;
    private Index groupIndex;
    private Index idIndex;

    public RowSetNavigatorDataTable(Session session, QuerySpecification querySpecification) {
        super(session);
        this.session = session;
        this.rangePosition = querySpecification.resultRangePosition;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.visibleColumnCount = querySpecification.indexLimitVisible;
        this.table = querySpecification.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !querySpecification.isAggregated);
        this.isAggregate = querySpecification.isAggregated;
        this.isSimpleAggregate = querySpecification.isAggregated && !querySpecification.isGrouped;
        this.reindexTable = querySpecification.isGrouped;
        this.mainIndex = querySpecification.mainIndex;
        this.fullIndex = querySpecification.fullIndex;
        this.orderIndex = querySpecification.orderIndex;
        this.groupIndex = querySpecification.groupIndex;
        this.idIndex = querySpecification.idIndex;
        this.tempRowData = new Object[1];
    }

    public RowSetNavigatorDataTable(Session session, QuerySpecification querySpecification, RowSetNavigatorData rowSetNavigatorData) {
        this(session, querySpecification);
        rowSetNavigatorData.reset();
        while (rowSetNavigatorData.hasNext()) {
            this.add(rowSetNavigatorData.getNext());
        }
    }

    public RowSetNavigatorDataTable(Session session, QueryExpression queryExpression) {
        super(session);
        this.session = session;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorDataTable(Session session, TableBase tableBase) {
        super(session);
        this.session = session;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = tableBase;
        this.visibleColumnCount = tableBase.getColumnCount();
        this.store = session.sessionData.getRowStore(tableBase);
        this.mainIndex = tableBase.getPrimaryIndex();
        this.fullIndex = tableBase.getFullIndex();
        this.size = this.mainIndex.size(null, this.store);
        this.reset();
    }

    public void sortFull() {
        if (this.reindexTable) {
            this.store.indexRows();
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    public void sortOrder() {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows();
            }
            this.mainIndex = this.orderIndex;
            this.reset();
        }
    }

    public void sortUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    public void add(Object[] objectArray) {
        try {
            Row row = (Row)this.store.getNewCachedObject(this.session, objectArray);
            this.store.indexRow(null, row);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void addAdjusted(Object[] objectArray, int[] nArray) {
        try {
            if (nArray == null) {
                objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.visibleColumnCount);
            } else {
                Object[] objectArray2 = new Object[this.visibleColumnCount];
                ArrayUtil.projectRow(objectArray, nArray, objectArray2);
                objectArray = objectArray2;
            }
            this.add(objectArray);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void update(Object[] objectArray, Object[] objectArray2) {
        if (this.isSimpleAggregate) {
            return;
        }
        RowIterator rowIterator = this.groupIndex.findFirstRow(this.session, this.store, objectArray);
        if (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            rowIterator.remove();
            rowIterator.release();
            --this.size;
            this.add(objectArray2);
        }
    }

    public void clear() {
        this.table.clearAllData(this.store);
        this.size = 0;
        this.reset();
    }

    public boolean absolute(int n) {
        return super.absolute(n);
    }

    public Object[] getCurrent() {
        return this.currentRow.getData();
    }

    public Row getCurrentRow() {
        return this.currentRow;
    }

    public boolean next() {
        boolean bl = super.next();
        this.currentRow = this.iterator.getNextRow();
        return bl;
    }

    public void remove() {
        if (this.currentRow != null) {
            this.iterator.remove();
            this.currentRow = null;
            --this.currentPos;
            --this.size;
        }
    }

    public void reset() {
        super.reset();
        this.iterator = this.mainIndex.firstRow(this.store);
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.isClosed = true;
    }

    public boolean isMemory() {
        return this.store.isMemory();
    }

    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        this.reset();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            rowOutputInterface.writeData(resultMetaData.getExtendedColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.reset();
    }

    public Object[] getData(Long l) {
        this.tempRowData[0] = l;
        RowIterator rowIterator = this.idIndex.findFirstRow(this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        return rowIterator.getNext();
    }

    public void copy(RowSetNavigatorData rowSetNavigatorData, int[] nArray) {
        while (rowSetNavigatorData.hasNext()) {
            Object[] objectArray = rowSetNavigatorData.getNext();
            this.addAdjusted(objectArray, nArray);
        }
        rowSetNavigatorData.close();
    }

    public void union(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        this.reset();
        while (rowSetNavigatorData.hasNext()) {
            Object[] objectArray = rowSetNavigatorData.getNext();
            RowIterator rowIterator = this.findFirstRow(objectArray);
            if (rowIterator.hasNext()) continue;
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.table.getColumnCount());
            this.add(objectArray);
        }
        rowSetNavigatorData.close();
    }

    public void intersect(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        this.reset();
        rowSetNavigatorData.sortFull();
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (bl) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
    }

    public void intersectAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Row row = null;
        Object[] objectArray2 = null;
        this.sortFull();
        this.reset();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean bl;
            Object[] objectArray3 = this.getNext();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique(this.session, objectArray3, objectArray, this.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            Object[] objectArray4 = objectArray2 = (row = rowIterator.getNextRow()) == null ? null : row.getData();
            if (objectArray2 != null && this.fullIndex.compareRowNonUnique(this.session, objectArray3, objectArray2, this.fullIndex.getColumnCount()) == 0) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
    }

    public void except(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        this.reset();
        rowSetNavigatorData.sortFull();
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
    }

    public void exceptAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Row row = null;
        Object[] objectArray2 = null;
        this.sortFull();
        this.reset();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean bl;
            Object[] objectArray3 = this.getNext();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique(this.session, objectArray3, objectArray, this.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if ((objectArray2 = (row = rowIterator.getNextRow()) == null ? null : row.getData()) == null || this.fullIndex.compareRowNonUnique(this.session, objectArray3, objectArray2, this.fullIndex.getColumnCount()) != 0) continue;
            this.remove();
        }
        rowSetNavigatorData.close();
    }

    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        this.reset();
        Object[] objectArray = null;
        while (this.hasNext()) {
            Object[] objectArray2 = this.getNext();
            if (this.hasNull(objectArray2)) continue;
            if (objectArray != null && this.fullIndex.compareRow(this.session, objectArray, objectArray2) == 0) {
                return false;
            }
            objectArray = objectArray2;
        }
        return true;
    }

    public void removeDuplicates() {
        this.sortFull();
        this.reset();
        Object[] objectArray = null;
        while (this.hasNext()) {
            Object[] objectArray2 = this.getNext();
            if (objectArray != null && this.fullIndex.compareRow(this.session, objectArray, objectArray2) == 0) {
                this.remove();
                continue;
            }
            objectArray = objectArray2;
        }
    }

    public void trim(int n, int n2) {
        int n3;
        if (this.size == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        if (n != 0) {
            this.reset();
            for (n3 = 0; n3 < n; ++n3) {
                this.next();
                this.remove();
            }
        }
        if (n2 == 0 || n2 >= this.size) {
            return;
        }
        this.reset();
        for (n3 = 0; n3 < n2; ++n3) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.remove();
        }
    }

    boolean hasNull(Object[] objectArray) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public Object[] getGroupData(Object[] objectArray) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = objectArray;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator rowIterator = this.groupIndex.findFirstRow(this.session, this.store, objectArray);
        if (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            if (this.isAggregate) {
                row.setChanged();
            }
            return row.getData();
        }
        return null;
    }

    boolean containsRow(Object[] objectArray) {
        RowIterator rowIterator = this.mainIndex.findFirstRow(this.session, this.store, objectArray);
        boolean bl = rowIterator.hasNext();
        rowIterator.release();
        return bl;
    }

    RowIterator findFirstRow(Object[] objectArray) {
        return this.mainIndex.findFirstRow(this.session, this.store, objectArray);
    }
}

