/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public int storeCount;

    public DataFileCacheSession(Database database, String string) {
        super(database, string);
    }

    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        int n = 10;
        this.cacheFileScale = 8;
        this.maxCacheRows = 2048;
        int n2 = 1 << n;
        this.maxCacheBytes = this.maxCacheRows * n2;
        this.maxDataFileSize = 0x1FFFFFFFCL;
        this.dataFile = null;
    }

    public void open(boolean bl) {
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, false, 0);
            this.fileFreePosition = 32L;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0L);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to open RA file", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.getMessage(), this.dataFileName});
        }
    }

    public synchronized void add(CachedObject cachedObject) {
        super.add(cachedObject);
    }

    public synchronized void close(boolean bl) {
        try {
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.fa.removeElement(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("Failed to close RA file", throwable);
            throw Error.error(throwable, 452, 53, new Object[]{throwable.getMessage(), this.dataFileName});
        }
    }

    void postClose(boolean bl) {
    }

    public void clear() {
        this.cache.clear();
        this.fileFreePosition = 32L;
    }

    public void deleteAll() {
        this.cache.clear();
        this.fileFreePosition = 32L;
        this.initBuffers();
    }
}

