/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Database database;
    int rowIdSequence = 0;

    public RowStoreAVLMemory(PersistentStoreCollection persistentStoreCollection, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        persistentStoreCollection.setStore(table, this);
    }

    public boolean isMemory() {
        return true;
    }

    public int getAccessCount() {
        return 0;
    }

    public void set(CachedObject cachedObject) {
    }

    public CachedObject get(int n) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    public CachedObject getKeep(int n) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    public CachedObject get(int n, boolean bl) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    public CachedObject get(CachedObject cachedObject, boolean bl) {
        return cachedObject;
    }

    public int getStorageSize(int n) {
        return 0;
    }

    public void add(CachedObject cachedObject) {
    }

    public CachedObject get(RowInputInterface rowInputInterface) {
        return null;
    }

    public CachedObject getNewInstance(int n) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject getNewCachedObject(Session session, Object object) {
        int n;
        Object object2 = this;
        synchronized (object2) {
            n = this.rowIdSequence++;
        }
        object2 = new RowAVL(this.table, (Object[])object, n);
        if (session != null) {
            RowAction rowAction;
            ((Row)object2).rowAction = rowAction = new RowAction(session, this.table, 1, (Row)object2, null);
        }
        return object2;
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int n) {
    }

    public void removePersistence(int n) {
    }

    public void release(int n) {
    }

    public void commitPersistence(CachedObject cachedObject) {
    }

    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes();
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    public DataFileCache getCache() {
        return null;
    }

    public void setCache(DataFileCache dataFileCache) {
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    public void setAccessor(Index index, int n) {
    }

    public int elementCount(Session session) {
        Index index = this.indexList[0];
        if (this.elementCount < 0) {
            this.elementCount = index == null ? 0 : ((IndexAVL)index).getNodeCount(session, this);
        }
        if (session != null && index != null && (this.table.getTableType() == 1 || this.database.txManager.getTransactionControl() != 0)) {
            return ((IndexAVL)index).getNodeCount(session, this);
        }
        return this.elementCount;
    }
}

