/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.BlobData;

public class BlobInputStream
extends InputStream {
    final BlobData blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    SessionInterface session;

    public BlobInputStream(SessionInterface sessionInterface, BlobData blobData, long l, long l2) {
        if (!BlobInputStream.isInLimits(blobData.length(sessionInterface), l, l2)) {
            throw new IndexOutOfBoundsException();
        }
        this.session = sessionInterface;
        this.blob = blobData;
        this.availableLength = l + l2;
        this.currentPosition = l;
    }

    public int read() throws IOException {
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (HsqlException hsqlException) {
                throw JavaSystem.toIOException(hsqlException);
            }
        }
        int n = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return n;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l > this.availableLength) {
            l = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l;
        return l;
    }

    public int available() {
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() {
        if (this.isClosed || this.blob.isClosed()) {
            throw Error.error(3475);
        }
    }

    private void readIntoBuffer() {
        long l = this.availableLength - this.currentPosition;
        if (l <= 0L) {
            // empty if block
        }
        if (l > (long)this.session.getStreamBlockSize()) {
            l = this.session.getStreamBlockSize();
        }
        this.buffer = this.blob.getBytes(this.session, this.currentPosition, (int)l);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

