/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLike;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.ExpressionTable;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableJoined;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntKeyHashMap;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;
    HsqlException lastError;

    ParserDQL(Session session, Scanner scanner) {
        super(scanner);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session, this);
    }

    void reset(String string) {
        super.reset(string);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
    }

    Type readTypeDefinition(boolean bl, boolean bl2) {
        Object object;
        int n = Integer.MIN_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            n = Type.getTypeNr(this.token.tokenString);
        }
        if (n == Integer.MIN_VALUE) {
            if (bl2) {
                this.checkIsSchemaObjectName();
                String string = this.session.getSchemaName(this.token.namePrefix);
                Type type = this.database.schemaManager.getDomainOrUDT(this.token.tokenString, string, false);
                if (type != null) {
                    this.getRecordedToken().setExpression(type);
                    this.compileContext.addSchemaObject(type);
                    this.read();
                    return type;
                }
            }
            if (this.token.namePrefix != null) {
                throw Error.error(5509, this.token.tokenString);
            }
            if (this.database.sqlSyntaxOra) {
                switch (this.token.tokenType) {
                    case 563: 
                    case 564: {
                        this.read();
                        return Type.SQL_DOUBLE;
                    }
                    case 601: {
                        this.read();
                        if (this.token.tokenType == 616) {
                            this.read();
                            return Type.getType(61, null, this.database.collation, 0x1000000L, 0);
                        }
                        return Type.getType(12, null, null, 0x1000000L, 0);
                    }
                    case 452: {
                        this.read();
                        if (this.token.tokenType == 786) {
                            this.read();
                            int n2 = this.readInteger();
                            int n3 = 0;
                            if (this.token.tokenType == 774) {
                                this.read();
                                n3 = this.readInteger();
                            }
                            this.readThis(772);
                            return Type.getType(3, null, null, n2, n3);
                        }
                        return Type.SQL_DECIMAL_DEFAULT;
                    }
                    case 616: {
                        n = -3;
                        break;
                    }
                    case 610: 
                    case 631: {
                        n = 12;
                        bl6 = true;
                    }
                }
            }
            if (this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs) {
                switch (this.token.tokenType) {
                    case 628: {
                        n = -1;
                        bl6 = true;
                    }
                }
            }
            if (n == Integer.MIN_VALUE) {
                throw Error.error(5509, this.token.tokenString);
            }
        }
        this.read();
        switch (n) {
            case 1: {
                if (this.token.tokenType == 313) {
                    this.read();
                    n = 12;
                    break;
                }
                if (this.token.tokenType != 147) break;
                this.read();
                this.readThis(453);
                n = 40;
                break;
            }
            case 8: {
                if (this.token.tokenType != 212) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 313) {
                    this.read();
                    n = 61;
                    break;
                }
                if (this.token.tokenType != 147) break;
                this.read();
                this.readThis(453);
                n = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 313) break;
                this.read();
                n = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(false);
            }
        }
        long l = n == 93 ? 6L : 0L;
        int n4 = 0;
        if (Types.requiresPrecision(n) && this.token.tokenType != 786 && this.database.sqlEnforceSize && !this.session.isProcessingScript) {
            throw Error.error(5599, Type.getDefaultType(n).getNameString());
        }
        if (Types.acceptsPrecision(n)) {
            if (this.token.tokenType == 786) {
                int n5 = 1;
                this.read();
                block18 : switch (this.token.tokenType) {
                    case 845: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 852: {
                        if (n == 30 || n == 40) {
                            switch (this.token.lobMultiplierType) {
                                case 426: {
                                    n5 = 1024;
                                    break block18;
                                }
                                case 435: {
                                    n5 = 0x100000;
                                    break block18;
                                }
                                case 405: {
                                    n5 = 0x40000000;
                                    break block18;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                bl3 = true;
                l = ((Number)this.token.tokenValue).longValue();
                if (l < 0L || l == 0L && !Types.acceptsZeroPrecision(n)) {
                    throw Error.error(5592);
                }
                l *= (long)n5;
                this.read();
                if (n == 1 || n == 12 || n == 40) {
                    if (this.token.tokenType == 355) {
                        this.read();
                    } else if (this.token.tokenType == 454) {
                        this.read();
                        l /= 2L;
                    }
                }
                if (Types.acceptsScaleCreateParam(n) && this.token.tokenType == 774) {
                    this.read();
                    n4 = this.readInteger();
                    if (n4 < 0) {
                        throw Error.error(5592);
                    }
                    bl4 = true;
                }
                this.readThis(772);
            } else if (n == 14) {
                l = 1L;
            } else if (n == 30 || n == 40) {
                l = 0x1000000L;
            } else if (this.database.sqlEnforceSize && (n == 1 || n == 60)) {
                l = 1L;
            }
            if (n == 93 || n == 92) {
                if (l > 9L) {
                    throw Error.error(5592);
                }
                n4 = (int)l;
                l = 0L;
                if (this.token.tokenType == 319) {
                    this.read();
                    this.readThis(281);
                    this.readThis(549);
                    n = n == 93 ? 95 : 94;
                } else if (this.token.tokenType == 321) {
                    this.read();
                    this.readThis(281);
                    this.readThis(549);
                }
            }
        }
        switch (n) {
            case -1: {
                n = this.database.sqlLongvarIsLob ? 40 : 12;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case -4: {
                n = this.database.sqlLongvarIsLob ? 30 : 61;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case 1: 
            case 40: 
            case 100: {
                bl5 = true;
                break;
            }
            case 12: {
                bl5 = true;
                if (bl3) break;
                l = 32768L;
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                if (bl3) break;
                l = 32768L;
                break;
            }
            case 2: 
            case 3: {
                if (bl3 || bl4 || this.database.sqlEnforceSize) break;
                l = 128L;
                n4 = 32;
            }
        }
        if (this.session.ignoreCase && n == 12) {
            n = 100;
        }
        if (bl6 && !this.readIfThis(33)) {
            this.readIfThis(568);
        }
        Collation collation = this.database.collation;
        Charset charset = null;
        if (bl5) {
            if (this.token.tokenType == 35) {
                this.read();
                this.readThis(254);
                this.checkIsSchemaObjectName();
                object = this.session.getSchemaName(this.token.namePrefix);
                charset = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, (String)object, 14);
                this.read();
            }
            if (this.token.tokenType == 41) {
                this.read();
                this.checkIsSimpleName();
                try {
                    collation = Collation.getCollation(this.token.tokenString);
                }
                catch (HsqlException hsqlException) {
                    collation = (Collation)this.database.schemaManager.getSchemaObject(this.token.tokenString, null, 15);
                }
                this.read();
            }
        }
        object = Type.getType(n, charset, collation, l, n4);
        if (this.token.tokenType == 8) {
            if (((Type)object).isLobType()) {
                throw this.unexpectedToken();
            }
            this.read();
            int n6 = 1024;
            if (this.token.tokenType == 781) {
                this.read();
                n6 = this.readInteger();
                if (n4 < 0) {
                    throw Error.error(5592);
                }
                this.readThis(790);
            }
            object = new ArrayType((Type)object, n6);
        }
        return object;
    }

    void readSimpleColumnNames(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(rangeVariable, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772) {
            throw this.unexpectedToken();
        }
    }

    void readTargetSpecificationList(OrderedHashSet orderedHashSet, RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        do {
            Expression expression;
            if (orderedHashSet.add(expression = this.XreadTargetSpecification(rangeVariableArray, longDeque))) continue;
            ColumnSchema columnSchema = expression.getColumn();
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772 && this.token.tokenType != 115) {
            throw this.unexpectedToken();
        }
    }

    int[] readColumnList(Table table, boolean bl) {
        OrderedHashSet orderedHashSet = this.readColumnNames(bl);
        return table.getColumnIndexes(orderedHashSet);
    }

    void readSimpleColumnNames(OrderedHashSet orderedHashSet, Table table, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(table, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5577, columnSchema.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName hsqlName) {
        BitMap bitMap = new BitMap(32);
        OrderedHashSet orderedHashSet = this.readColumnNames(bitMap, false);
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            String string = (String)orderedHashSet.get(i);
            boolean bl = bitMap.isSet(i);
            hsqlNameArray[i] = this.database.nameManager.newHsqlName(hsqlName.schema, string, bl, 9, hsqlName);
        }
        return hsqlNameArray;
    }

    OrderedHashSet readColumnNames(boolean bl) {
        return this.readColumnNames(null, bl);
    }

    OrderedHashSet readColumnNames(BitMap bitMap, boolean bl) {
        this.readThis(786);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.readColumnNameList(orderedHashSet, bitMap, bl);
        this.readThis(772);
        return orderedHashSet;
    }

    void readColumnNameList(OrderedHashSet orderedHashSet, BitMap bitMap, boolean bl) {
        int n = 0;
        do {
            if (this.session.isProcessingScript) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!orderedHashSet.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (bitMap != null && this.isDelimitedIdentifier()) {
                bitMap.set(n);
            }
            this.read();
            ++n;
            if (!bl || this.token.tokenType != 338 && this.token.tokenType != 389) continue;
            this.read();
        } while (this.readIfThis(774));
    }

    HsqlNameManager.SimpleName[] readColumnNameList(OrderedHashSet orderedHashSet) {
        BitMap bitMap = new BitMap(32);
        this.readThis(786);
        this.readColumnNameList(orderedHashSet, bitMap, false);
        this.readThis(772);
        HsqlNameManager.SimpleName[] simpleNameArray = new HsqlNameManager.SimpleName[orderedHashSet.size()];
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.SimpleName simpleName;
            simpleNameArray[i] = simpleName = HsqlNameManager.getSimpleName((String)orderedHashSet.get(i), bitMap.isSet(i));
        }
        return simpleNameArray;
    }

    int XreadUnionType() {
        int n = 0;
        switch (this.token.tokenType) {
            case 298: {
                this.read();
                n = 1;
                if (this.token.tokenType == 2) {
                    n = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
            case 138: {
                this.read();
                n = 3;
                if (this.token.tokenType == 2) {
                    n = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
            case 98: 
            case 607: {
                this.read();
                n = 6;
                if (this.token.tokenType == 2) {
                    n = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
        }
        return n;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 51) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 24) {
                this.read();
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(orderedHashSet);
            }
        }
    }

    QueryExpression XreadQueryExpression() {
        Object object;
        HsqlNameManager.HsqlName[] hsqlNameArray;
        if (this.token.tokenType == 319) {
            this.read();
            boolean bl = this.readIfThis(220);
            this.compileContext.initSubqueryNames();
            while (true) {
                this.checkIsSimpleName();
                hsqlNameArray = null;
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 27);
                hsqlName.schema = SqlInvariants.SYSTEM_SUBQUERY_HSQLNAME;
                this.read();
                if (this.token.tokenType == 786) {
                    hsqlNameArray = this.readColumnNames(hsqlName);
                } else if (bl) {
                    super.unexpectedTokenRequire("(");
                }
                this.readThis(10);
                this.readThis(786);
                object = this.XreadTableNamedSubqueryBody(hsqlName, hsqlNameArray, bl ? 24 : 23);
                this.readThis(772);
                if (this.token.tokenType == 71) {
                    throw super.unsupportedFeature();
                }
                if (bl && this.token.tokenType == 71) {
                    TableDerived tableDerived = ((SubQuery)object).getTable();
                    int[] nArray = this.readColumnList(tableDerived, false);
                    this.readThis(254);
                    this.checkIsSimpleName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newColumnHsqlName(tableDerived.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    ColumnSchema columnSchema = new ColumnSchema(hsqlName2, null, true, false, null);
                    if (tableDerived.getColumnIndex(hsqlName2.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(285);
                    String string = this.readQuotedString();
                    if (string.length() != 1) {
                        throw this.unexpectedToken(string);
                    }
                    this.readThis(78);
                    String string2 = this.readQuotedString();
                    if (string2.length() != 1) {
                        throw this.unexpectedToken(string2);
                    }
                    if (string.equals(string2)) {
                        throw this.unexpectedToken(string);
                    }
                    this.readThis(306);
                    this.checkIsSimpleName();
                    this.checkIsSimpleName();
                    hsqlName2 = this.database.nameManager.newColumnHsqlName(tableDerived.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    if (tableDerived.getColumnIndex(hsqlName2.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    ColumnSchema columnSchema2 = new ColumnSchema(hsqlName2, null, true, false, null);
                }
                this.compileContext.registerSubquery(hsqlName.name, (SubQuery)object);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        QueryExpression queryExpression = this.XreadQueryExpressionBody();
        hsqlNameArray = this.XreadOrderByExpression();
        if (queryExpression.sortAndSlice == null) {
            queryExpression.addSortAndSlice((SortAndSlice)hsqlNameArray);
        } else if (queryExpression.sortAndSlice.hasLimit()) {
            if (hsqlNameArray.hasLimit()) {
                throw Error.error(5549);
            }
            for (int i = 0; i < hsqlNameArray.exprList.size(); ++i) {
                object = (Expression)hsqlNameArray.exprList.get(i);
                queryExpression.sortAndSlice.addOrderExpression((Expression)object);
            }
        } else {
            queryExpression.addSortAndSlice((SortAndSlice)hsqlNameArray);
        }
        return queryExpression;
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 98: 
                case 298: 
                case 607: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 138) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int n = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression queryExpression2 = this.XreadQueryTerm();
        queryExpression.addUnion(queryExpression2, n);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: {
                QuerySpecification querySpecification = this.XreadSimpleTable();
                return querySpecification;
            }
            case 786: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(772);
                if (queryExpression.sortAndSlice == null) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression expression = (Expression)sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(expression);
                    }
                } else {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification querySpecification;
        switch (this.token.tokenType) {
            case 278: {
                this.read();
                Table table = this.readTableName();
                if (table.isView()) {
                    table = ((View)table).getSubqueryTable();
                }
                querySpecification = new QuerySpecification(this.session, table, this.compileContext, false);
                break;
            }
            case 308: {
                this.read();
                SubQuery subQuery = this.XreadRowValueExpressionList();
                querySpecification = new QuerySpecification(this.session, subQuery.getTable(), this.compileContext, true);
                break;
            }
            case 251: {
                querySpecification = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return querySpecification;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification querySpecification = this.XreadSelect();
        if (!querySpecification.isValueList) {
            this.XreadTableExpression(querySpecification);
        }
        return querySpecification;
    }

    void XreadTableExpression(QuerySpecification querySpecification) {
        this.XreadFromClause(querySpecification);
        this.readWhereGroupHaving(querySpecification);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification querySpecification;
        block9: {
            Object object;
            querySpecification = new QuerySpecification(this.compileContext);
            this.readThis(251);
            if ((this.token.tokenType == 740 || this.token.tokenType == 598) && (object = this.XreadTopOrLimit()) != null) {
                querySpecification.addSortAndSlice((SortAndSlice)object);
            }
            if (this.token.tokenType == 85) {
                querySpecification.isDistinctSelect = true;
                this.read();
            } else if (this.token.tokenType == 2) {
                this.read();
            }
            do {
                object = this.XreadValueExpression();
                if (this.token.tokenType == 10) {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    ((Expression)object).setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                querySpecification.addSelectColumnExpression((Expression)object);
                if (this.token.tokenType == 115 || this.token.tokenType == 141) break block9;
            } while (this.readIfThis(774));
            if ((this.token.tokenType == 772 || this.token.tokenType == 848) && (this.database.sqlSyntaxMss || this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs)) {
                Expression[] expressionArray = new Expression[querySpecification.exprColumnList.size()];
                querySpecification.exprColumnList.toArray(expressionArray);
                Expression expression = new Expression(26, expressionArray);
                for (int i = 0; i < expression.nodes.length; ++i) {
                    if (expression.nodes[i].opType == 25) continue;
                    expression.nodes[i] = new Expression(25, new Expression[]{expression.nodes[i]});
                }
                this.compileContext.subqueryDepth++;
                SubQuery subQuery = this.prepareSubquery(expression);
                querySpecification = new QuerySpecification(this.session, subQuery.getTable(), this.compileContext, true);
                this.compileContext.subqueryDepth--;
                return querySpecification;
            }
            throw this.unexpectedToken();
        }
        return querySpecification;
    }

    void XreadFromClause(QuerySpecification querySpecification) {
        this.readThis(115);
        do {
            this.XreadTableReference(querySpecification);
        } while (this.readIfThis(774));
    }

    void XreadTableReference(QuerySpecification querySpecification) {
        boolean bl = false;
        RangeVariable rangeVariable = this.readTableOrSubquery(null);
        querySpecification.addRangeVariable(rangeVariable);
        block17: while (true) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 132: {
                    this.read();
                    this.readThis(144);
                    break;
                }
                case 56: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(144);
                    break;
                }
                case 298: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    int n2 = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 144) {
                        this.read();
                        break;
                    }
                    this.rewind(n2);
                    bl4 = true;
                    break;
                }
                case 176: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl = true;
                    continue block17;
                }
                case 153: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    bl2 = true;
                    break;
                }
                case 240: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    bl3 = true;
                    break;
                }
                case 116: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 144: {
                    this.read();
                    n = 132;
                    break;
                }
                case 774: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    n = 774;
                    break;
                }
                default: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    bl4 = true;
                }
            }
            if (bl4) break;
            rangeVariable = this.readTableOrSubquery(null);
            Expression expression = null;
            switch (n) {
                case 774: {
                    rangeVariable.isBoundary = true;
                    querySpecification.addRangeVariable(rangeVariable);
                    break;
                }
                case 56: {
                    querySpecification.addRangeVariable(rangeVariable);
                    break;
                }
                case 298: {
                    querySpecification.addRangeVariable(rangeVariable);
                    expression = Expression.EXPR_FALSE;
                    rangeVariable.setJoinType(true, true);
                    break;
                }
                case 116: 
                case 132: 
                case 153: 
                case 240: {
                    OrderedHashSet orderedHashSet;
                    if (bl) {
                        orderedHashSet = rangeVariable.getUniqueColumnNameSet();
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable, false);
                        querySpecification.addRangeVariable(rangeVariable);
                    } else if (this.token.tokenType == 306) {
                        this.read();
                        orderedHashSet = new OrderedHashSet();
                        this.readThis(786);
                        this.readSimpleColumnNames(orderedHashSet, rangeVariable, false);
                        this.readThis(772);
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable, true);
                        querySpecification.addRangeVariable(rangeVariable);
                    } else if (this.token.tokenType == 194) {
                        this.read();
                        expression = this.XreadBooleanValueExpression();
                        querySpecification.addRangeVariable(rangeVariable);
                    } else {
                        throw this.unexpectedToken();
                    }
                    rangeVariable.setJoinType(bl2, bl3);
                }
            }
            rangeVariable.addJoinCondition(expression);
            bl = false;
        }
    }

    Expression getRowExpression(OrderedHashSet orderedHashSet) {
        Expression[] expressionArray = new Expression[orderedHashSet.size()];
        for (int i = 0; i < expressionArray.length; ++i) {
            String string = (String)orderedHashSet.get(i);
            expressionArray[i] = new ExpressionColumn(null, null, string);
        }
        return new Expression(25, expressionArray);
    }

    void readWhereGroupHaving(QuerySpecification querySpecification) {
        Expression expression;
        if (this.token.tokenType == 316) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            querySpecification.addQueryCondition(expression);
        }
        if (this.token.tokenType == 122) {
            this.read();
            this.readThis(24);
            while (true) {
                expression = this.XreadValueExpression();
                querySpecification.addGroupByColumnExpression(expression);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        if (this.token.tokenType == 125) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            querySpecification.addHavingExpression(expression);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 198) {
            this.read();
            this.readThis(24);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 598 || this.token.tokenType == 107 || this.token.tokenType == 192) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int n;
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 598) {
            n = this.getPosition();
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                this.rewind(n);
                return null;
            }
            this.readIfThis(774);
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
        } else if (this.token.tokenType == 740) {
            n = this.getPosition();
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                this.rewind(n);
                return null;
            }
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        n = 1;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression.opType == 1) {
            n = expression.getDataType().typeCode == 4 && (Integer)expression.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression2.opType == 1) {
            n &= expression2.getDataType().typeCode == 4 && (Integer)expression2.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (n != 0) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(95, expression, expression2));
            return sortAndSlice;
        }
        throw Error.error(5563, 81);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 192) {
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(5563, 81);
            }
            if (this.token.tokenType == 243 || this.token.tokenType == 245) {
                this.read();
            }
        }
        if (this.token.tokenType == 598) {
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
            if (expression == null) {
                if (this.token.tokenType == 774) {
                    this.read();
                    expression = expression2;
                    expression2 = this.XreadSimpleValueSpecificationOrNull();
                } else if (this.token.tokenType == 192) {
                    this.read();
                    expression = this.XreadSimpleValueSpecificationOrNull();
                }
            }
            if (this.database.sqlSyntaxPgs || this.database.sqlSyntaxMys) {
                sortAndSlice.setZeroLimit();
            }
        } else if (this.token.tokenType == 107) {
            this.read();
            if (this.token.tokenType == 401 || this.token.tokenType == 448) {
                this.read();
            }
            if ((expression2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                expression2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 243 || this.token.tokenType == 245) {
                this.read();
            }
            this.readThis(195);
            sortAndSlice.setStrictLimit();
        }
        if (expression == null) {
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean bl = true;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (expression2 != null && expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (bl) {
            sortAndSlice.addLimitCondition(new ExpressionOp(95, expression, expression2));
            return;
        }
        throw Error.error(5563, 81);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            Expression expression = this.XreadValueExpression();
            ExpressionOrderBy expressionOrderBy = new ExpressionOrderBy(expression);
            if (this.token.tokenType == 389) {
                expressionOrderBy.setDescending();
                this.read();
            } else if (this.token.tokenType == 338) {
                this.read();
            }
            if (this.token.tokenType == 451) {
                this.read();
                if (this.token.tokenType == 401) {
                    this.read();
                } else if (this.token.tokenType == 430) {
                    this.read();
                    expressionOrderBy.setNullsLast();
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(expressionOrderBy);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readSimpleRangeVariable(int n) {
        Table table = this.readTableName();
        HsqlNameManager.SimpleName simpleName = null;
        if (n != 1205) {
            if (this.token.tokenType == 10) {
                this.read();
                this.checkIsNonCoreReservedIdentifier();
            }
            if (this.isNonCoreReservedIdentifier()) {
                simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                this.read();
            }
        }
        if (table.isView) {
            switch (n) {
                case 128: {
                    if (table.isTriggerUpdatable() && table.isTriggerInsertable() || !table.isTriggerUpdatable() && !table.isTriggerInsertable() && table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 82: {
                    if (table.isTriggerUpdatable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 19: {
                    if (table.isTriggerDeletable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 50: {
                    if (table.isTriggerInsertable() || table.isInsertable() || this.session.isProcessingScript) break;
                    throw Error.error(5545);
                }
                case 1205: {
                    throw Error.error(5545);
                }
            }
        }
        RangeVariable rangeVariable = new RangeVariable(table, simpleName, null, null, this.compileContext);
        return rangeVariable;
    }

    protected Table readNamedSubqueryOrNull() {
        if (!this.isSimpleName()) {
            return null;
        }
        SubQuery subQuery = this.compileContext.getNamedSubQuery(this.token.tokenString);
        if (subQuery == null) {
            return null;
        }
        this.read();
        return subQuery.getTable();
    }

    protected RangeVariable readTableOrSubquery(RangeVariable[] rangeVariableArray) {
        Table table = null;
        HsqlNameManager.SimpleName simpleName = null;
        HsqlNameManager.SimpleName[] simpleNameArray = null;
        OrderedHashSet orderedHashSet = null;
        boolean bl = false;
        switch (this.token.tokenType) {
            case 786: {
                table = this.XreadTableSubqueryOrNull(rangeVariableArray);
                if (table != null) break;
                Object object = this.XreadJoinedTableAsSubquery();
                table = ((SubQuery)object).getTable();
                bl = true;
                break;
            }
            case 301: {
                Object object = this.XreadCollectionDerivedTable();
                table = ((Expression)object).getTable();
                break;
            }
            case 149: {
                Object object = this.XreadLateralDerivedTable();
                table = ((Expression)object).getTable();
                break;
            }
            case 278: {
                Object object = this.XreadTableFunctionDerivedTable();
                table = ((Expression)object).getTable();
                break;
            }
            default: {
                table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName();
                }
                if (!table.isView()) break;
                table = ((View)table).getSubqueryTable();
            }
        }
        boolean bl2 = false;
        if (this.token.tokenType == 10) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            bl2 = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean bl3 = this.token.tokenType == 598 || this.token.tokenType == 192 || this.token.tokenType == 107;
            boolean bl4 = this.token.tokenType == 607;
            int n = this.getPosition();
            simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 786) {
                orderedHashSet = new OrderedHashSet();
                simpleNameArray = this.readColumnNameList(orderedHashSet);
            } else if (!bl2 && bl3) {
                if (this.token.tokenType == 773 || this.token.tokenType == 788 || this.token.tokenType == 845) {
                    simpleName = null;
                    this.rewind(n);
                }
            } else if (!bl2 && bl4) {
                this.rewind(n);
            }
        }
        RangeVariable rangeVariable = bl ? new RangeVariableJoined(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext) : new RangeVariable(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext);
        return rangeVariable;
    }

    private Expression readAggregate() {
        int n = this.token.tokenType;
        this.read();
        this.readThis(786);
        Expression expression = this.readAggregateExpression(n);
        this.readThis(772);
        this.readFilterClause(expression);
        return expression;
    }

    private void readFilterClause(Expression expression) {
        int n = this.getPosition();
        if (this.token.tokenType == 108) {
            this.read();
            if (this.token.tokenType != 786) {
                this.rewind(n);
                return;
            }
            this.readThis(786);
            this.readThis(316);
            Expression expression2 = this.XreadBooleanValueExpression();
            expression.setCondition(expression2);
            this.readThis(772);
        }
    }

    private Expression readAggregateExpression(int n) {
        int n2 = ParserDQL.getExpressionType(n);
        boolean bl = false;
        boolean bl2 = false;
        SortAndSlice sortAndSlice = null;
        String string = null;
        if (this.token.tokenType == 85) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 2) {
            bl2 = true;
            this.read();
        }
        Expression expression = this.XreadValueExpression();
        switch (n2) {
            case 71: {
                if (expression.getType() != 97) break;
                if (((ExpressionColumn)expression).tableName != null) {
                    throw this.unexpectedToken();
                }
                if (bl2 || bl) {
                    throw this.unexpectedToken();
                }
                expression.opType = 11;
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!bl2 && !bl) break;
                throw Error.error(5582, bl2 ? "ALL" : "DISTINCT");
            }
            case 82: 
            case 83: {
                if (this.token.tokenType == 198) {
                    this.read();
                    this.readThis(24);
                    sortAndSlice = this.XreadOrderBy();
                }
                if (n2 == 83 && this.token.tokenType == 623) {
                    this.read();
                    super.checkIsValue(1);
                    string = (String)this.token.tokenValue;
                    this.read();
                }
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            case 85: {
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            default: {
                if (expression.getType() != 11) break;
                throw this.unexpectedToken();
            }
        }
        ExpressionAggregate expressionAggregate = new ExpressionAggregate(n2, bl, expression);
        return expressionAggregate;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression expression = null;
        boolean bl = false;
        switch (this.token.tokenType) {
            case 787: {
                this.read();
                break;
            }
            case 784: {
                this.read();
                bl = true;
            }
        }
        expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 294: {
                this.read();
                return Expression.EXPR_TRUE;
            }
            case 106: {
                this.read();
                return Expression.EXPR_FALSE;
            }
            case 78: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn expressionColumn = new ExpressionColumn(4);
                return expressionColumn;
            }
            case 186: {
                ExpressionValue expressionValue = new ExpressionValue(null, null);
                this.read();
                return expressionValue;
            }
            case 845: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 846: 
            case 847: {
                if (!this.token.isHostParameter) {
                    return null;
                }
                return null;
            }
            case 773: {
                this.read();
                if (this.token.tokenType != 847 && this.token.tokenType != 846) {
                    throw this.unexpectedToken(":");
                }
            }
            case 788: {
                ExpressionColumn expressionColumn = new ExpressionColumn(8);
                this.compileContext.addParameter(expressionColumn, this.getPosition());
                this.read();
                return expressionColumn;
            }
            case 358: {
                return this.XreadCurrentCollationSpec();
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 253: 
            case 277: 
            case 305: 
            case 307: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    return null;
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 845: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 773: {
                this.read();
                if (this.token.tokenType != 847 && this.token.tokenType != 846) {
                    throw this.unexpectedToken(":");
                }
            }
            case 788: {
                ExpressionColumn expressionColumn = new ExpressionColumn(8);
                this.compileContext.addParameter(expressionColumn, this.getPosition());
                this.read();
                return expressionColumn;
            }
            case 846: 
            case 847: {
                this.checkValidCatalogName(this.token.namePrePrePrefix);
                ExpressionColumn expressionColumn = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
                this.read();
                return expressionColumn;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean bl) {
        Expression expression = null;
        switch (this.token.tokenType) {
            case 101: 
            case 299: {
                if (!bl) break;
                return this.XreadPredicate();
            }
            case 243: {
                if (bl) break;
                this.read();
                this.readThis(786);
                expression = this.XreadRowElementList(true);
                this.readThis(772);
                break;
            }
            default: {
                expression = this.XreadSimpleValueExpressionPrimary();
                if (expression == null) break;
                expression = this.XreadArrayElementReference(expression);
            }
        }
        if (expression == null && this.token.tokenType == 786) {
            this.read();
            expression = this.XreadRowElementList(true);
            this.readThis(772);
        }
        if (bl && expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadValueExpressionPrimary() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
            return expression;
        }
        if (this.token.tokenType != 786) {
            return null;
        }
        this.read();
        expression = this.XreadValueExpression();
        this.readThis(772);
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Expression XreadSimpleValueExpressionPrimary() {
        Expression expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression != null) {
            return expression;
        }
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 786: {
                this.read();
                int n2 = this.getPosition();
                int n3 = this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 251: 
                    case 278: 
                    case 308: {
                        SubQuery subQuery = null;
                        this.rewind(n2);
                        try {
                            subQuery = this.XreadSubqueryBody(21);
                            this.readThis(772);
                        }
                        catch (HsqlException hsqlException) {
                            hsqlException.setLevel(this.compileContext.subqueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                                this.lastError = hsqlException;
                            }
                            this.rewind(n);
                            return null;
                        }
                        expression = subQuery.queryExpression.isSingleColumn() ? new Expression(21, subQuery) : new Expression(22, subQuery);
                        if (this.readCloseBrackets(n3) == n3) return expression;
                        throw this.unexpectedToken();
                    }
                }
                this.rewind(n);
                return null;
            }
            case 771: {
                expression = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.getRecordedToken().setExpression(expression);
                this.read();
                return expression;
            }
            case 688: {
                expression = this.readLeastExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 678: {
                expression = this.readGreatestExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 673: {
                expression = this.readDecodeExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 653: {
                expression = this.readConcatExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 571: {
                expression = this.readCaseWhenExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 29: {
                return this.readCaseExpression();
            }
            case 187: {
                return this.readNullIfExpression();
            }
            case 40: {
                return this.readCoalesceExpression();
            }
            case 680: 
            case 686: {
                expression = this.readIfNullExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 611: {
                expression = this.readIfNull2ExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 30: 
            case 49: {
                expression = this.readCastExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 72: 
            case 140: 
            case 281: 
            case 282: {
                expression = this.readDateTimeIntervalLiteral();
                if (expression == null) break;
                return expression;
            }
            case 8: {
                return this.readCollection(19);
            }
            case 6: 
            case 9: 
            case 16: 
            case 52: 
            case 97: 
            case 163: 
            case 168: 
            case 258: 
            case 269: 
            case 270: 
            case 274: 
            case 309: 
            case 310: 
            case 604: 
            case 679: {
                return this.readAggregate();
            }
            case 448: {
                expression = this.readSequenceExpressionOrNull(12);
                if (expression == null) break;
                return expression;
            }
            case 59: {
                expression = this.readSequenceExpressionOrNull(13);
                if (expression == null) break;
                return expression;
            }
            case 579: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(786);
                String string = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(string);
                scanner.scanNext();
                String string2 = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
                expression = new ExpressionColumn(numberSequence, 13);
                this.readThis(772);
                return expression;
            }
            case 597: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(786);
                this.readThis(772);
                return FunctionCustom.newCustomFunction("IDENTITY", 128);
            }
            case 609: {
                if (!this.database.sqlSyntaxPgs) break;
                return this.readNextvalFunction();
            }
            case 621: {
                this.read();
                if (this.token.tokenType == 786) {
                    this.read();
                    if (this.token.tokenType == 772) {
                        this.read();
                        return new ExpressionColumn(14);
                    }
                    this.rewind(n);
                    break;
                }
                if (this.database.sqlSyntaxOra) return new ExpressionColumn(14);
                this.rewind(n);
                break;
            }
            case 153: 
            case 240: {
                break;
            }
            case 278: {
                this.read();
                this.readThis(786);
                SubQuery subQuery = this.XreadSubqueryBody(23);
                this.readThis(772);
                return new Expression(23, subQuery);
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        if (!(expression = this.readColumnOrFunctionExpression()).isAggregate()) return expression;
        this.readFilterClause(expression);
        return expression;
    }

    Expression readNextvalFunction() {
        this.read();
        this.readThis(786);
        String string = this.readQuotedString();
        Scanner scanner = this.session.getScanner();
        scanner.reset(string);
        scanner.scanNext();
        String string2 = this.session.getSchemaName(scanner.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, 12);
        this.readThis(772);
        return expressionColumn;
    }

    Expression XreadAllTypesPrimary(boolean bl) {
        Expression expression = null;
        switch (this.token.tokenType) {
            case 1: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 103: 
            case 105: 
            case 111: 
            case 156: 
            case 161: 
            case 170: 
            case 182: 
            case 189: 
            case 190: 
            case 203: 
            case 209: 
            case 210: 
            case 211: 
            case 265: 
            case 272: 
            case 273: 
            case 288: 
            case 292: 
            case 304: 
            case 317: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unsupportedFeature();
                }
                expression = this.readSQLFunction(functionSQL);
                if (expression != null) break;
            }
            default: {
                expression = this.XreadAllTypesValueExpressionPrimary(bl);
            }
        }
        expression = this.XreadModifier(expression);
        return expression;
    }

    Expression XreadModifier(Expression expression) {
        switch (this.token.tokenType) {
            case 13: {
                this.read();
                Expression expression2 = null;
                if (this.token.tokenType == 157) {
                    this.read();
                } else {
                    this.readThis(281);
                    this.readThis(549);
                    expression2 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 73: 
                        case 127: 
                        case 169: 
                        case 173: 
                        case 250: 
                        case 323: {
                            IntervalType intervalType = this.readIntervalType(false);
                            if (expression2.getType() == 33) {
                                expression2.dataType = intervalType;
                                break;
                            }
                            expression2 = new ExpressionOp(expression2, intervalType);
                        }
                    }
                }
                expression = new ExpressionOp(92, expression, expression2);
                break;
            }
            case 73: 
            case 127: 
            case 169: 
            case 173: 
            case 250: 
            case 323: {
                IntervalType intervalType = this.readIntervalType(true);
                if (expression.getType() == 33) {
                    expression.dataType = intervalType;
                    break;
                }
                expression = new ExpressionOp(expression, intervalType);
                break;
            }
            case 41: {
                Collation collation;
                this.read();
                if (this.token.namePrefix != null) break;
                try {
                    collation = Collation.getCollation(this.token.tokenString);
                }
                catch (HsqlException hsqlException) {
                    collation = (Collation)this.database.schemaManager.getSchemaObject(this.session.getSchemaName(this.token.namePrefix), this.token.tokenString, 15);
                }
                expression.setCollation(collation);
                this.read();
            }
        }
        return expression;
    }

    Expression XreadValueExpressionWithContext() {
        this.compileContext.contextuallyTypedExpression = true;
        Expression expression = this.XreadValueExpressionOrNull();
        this.compileContext.contextuallyTypedExpression = false;
        return expression;
    }

    Expression XreadValueExpressionOrNull() {
        Expression expression = this.XreadAllTypesCommonValueExpression(true);
        if (expression == null) {
            return null;
        }
        return expression;
    }

    Expression XreadValueExpression() {
        Expression expression = this.XreadAllTypesCommonValueExpression(true);
        if (this.token.tokenType == 781) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(790);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean bl) {
        Expression expression = this.XreadAllTypesTerm(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 787: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 784: {
                    n = 33;
                    bl = false;
                    break;
                }
                case 775: {
                    n = 36;
                    bl = false;
                    break;
                }
                case 197: {
                    if (bl) {
                        n = 50;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesTerm(bl);
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesTerm(boolean bl) {
        Expression expression = this.XreadAllTypesFactor(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 771: {
                    n = 34;
                    bl = false;
                    break;
                }
                case 776: {
                    n = 35;
                    bl = false;
                    break;
                }
                case 5: {
                    if (bl) {
                        n = 49;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesFactor(bl);
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesFactor(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (this.token.tokenType) {
            case 787: {
                this.read();
                bl = false;
                break;
            }
            case 784: {
                this.read();
                bl = false;
                bl2 = true;
                break;
            }
            case 183: {
                if (!bl) break;
                this.read();
                bl3 = true;
            }
        }
        Expression expression = this.XreadAllTypesPrimary(bl);
        if (bl && this.token.tokenType == 142) {
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                boolean bl5 = bl3 = !bl3;
            }
            if (this.token.tokenType == 294) {
                this.read();
            } else if (this.token.tokenType == 106) {
                this.read();
                bl3 = !bl3;
            } else if (this.token.tokenType == 300) {
                this.read();
                bl4 = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl4) {
            expression = new ExpressionLogical(47, expression);
        } else if (bl2) {
            expression = new ExpressionArithmetic(31, expression);
        } else if (bl3) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression expression = this.XreadCharacterPrimary();
        SchemaObject schemaObject = this.readCollateClauseOrNull();
        while (this.token.tokenType == 775) {
            this.read();
            Expression expression2 = expression;
            expression = this.XreadCharacterPrimary();
            schemaObject = this.readCollateClauseOrNull();
            expression = new ExpressionArithmetic(36, expression2, expression);
        }
        return expression;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 161: 
            case 203: 
            case 272: 
            case 292: 
            case 304: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 103: 
            case 105: 
            case 111: 
            case 156: 
            case 170: 
            case 190: 
            case 209: 
            case 211: 
            case 265: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw super.unexpectedToken();
                }
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression expression = this.XreadTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 787) {
                n = 32;
            } else {
                if (this.token.tokenType != 784) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadTerm() {
        Expression expression = this.XreadFactor();
        while (true) {
            int n;
            if (this.token.tokenType == 771) {
                n = 34;
            } else {
                if (this.token.tokenType != 776) break;
                n = 35;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadFactor();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadFactor() {
        boolean bl = false;
        if (this.token.tokenType == 787) {
            this.read();
        } else if (this.token.tokenType == 784) {
            this.read();
            bl = true;
        }
        Expression expression = this.XreadNumericPrimary();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadDatetimeValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 787) {
                n = 32;
            } else {
                if (this.token.tokenType != 784) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadIntervalValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 787) {
                n = 32;
            } else {
                if (this.token.tokenType != 784) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 61: 
            case 66: 
            case 67: 
            case 158: 
            case 159: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw super.unexpectedToken();
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL functionSQL = null;
        switch (this.token.tokenType) {
            case 61: 
            case 66: 
            case 67: 
            case 158: 
            case 159: {
                functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 702: 
            case 730: 
            case 739: {
                functionSQL = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
                break;
            }
            default: {
                return null;
            }
        }
        if (functionSQL == null) {
            throw super.unexpectedToken();
        }
        return this.readSQLFunction(functionSQL);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression expression = this.XreadBooleanTermOrNull();
            if (expression == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 197) {
                int n = 50;
                this.read();
                Expression expression2 = expression;
                expression = this.XreadBooleanTermOrNull();
                if (expression == null) {
                    throw Error.error(5568);
                }
                expression = new ExpressionLogical(n, expression2, expression);
            }
            if (expression == null) {
                throw Error.error(5568);
            }
            return expression;
        }
        catch (HsqlException hsqlException) {
            HsqlException hsqlException2;
            hsqlException.setLevel(this.compileContext.subqueryDepth);
            if (this.lastError != null && this.lastError.getLevel() >= hsqlException.getLevel()) {
                hsqlException2 = this.lastError;
                this.lastError = null;
            }
            throw hsqlException2;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression expression = this.XreadBooleanFactorOrNull();
        if (expression == null) {
            return null;
        }
        while (this.token.tokenType == 5) {
            int n = 49;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadBooleanFactorOrNull();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionLogical(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression expression;
        boolean bl = false;
        boolean bl2 = false;
        if (this.token.tokenType == 183) {
            this.read();
            bl = true;
        }
        if ((expression = this.XreadBooleanPrimaryOrNull()) == null) {
            return null;
        }
        if (this.token.tokenType == 142) {
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                boolean bl3 = bl = !bl;
            }
            if (this.token.tokenType == 294) {
                this.read();
            } else if (this.token.tokenType == 106) {
                bl = !bl;
                this.read();
            } else if (this.token.tokenType == 300) {
                bl2 = true;
                this.read();
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl2) {
            expression = new ExpressionLogical(47, expression);
        }
        if (bl) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int n;
        Expression expression = null;
        switch (this.token.tokenType) {
            case 101: 
            case 299: {
                return this.XreadPredicate();
            }
            case 243: {
                this.read();
                this.readThis(786);
                expression = this.XreadRowElementList(true);
                this.readThis(772);
                break;
            }
            default: {
                n = this.getPosition();
                try {
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException hsqlException) {
                    hsqlException.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                        this.lastError = hsqlException;
                    }
                    this.rewind(n);
                }
            }
        }
        if (expression == null && this.token.tokenType == 786) {
            this.read();
            n = this.getPosition();
            try {
                expression = this.XreadRowElementList(true);
                this.readThis(772);
            }
            catch (HsqlException hsqlException) {
                hsqlException.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                    this.lastError = hsqlException;
                }
                this.rewind(n);
                expression = this.XreadBooleanValueExpression();
                this.readThis(772);
            }
        }
        if (expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadBooleanPredicand() {
        if (this.token.tokenType == 786) {
            this.read();
            Expression expression = this.XreadBooleanValueExpression();
            this.readThis(772);
            return expression;
        }
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
        }
        return expression;
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 101: {
                this.read();
                Expression expression = this.XreadTableSubquery(55);
                return new ExpressionLogical(55, expression);
            }
            case 299: {
                this.read();
                Expression expression = this.XreadTableSubquery(57);
                return new ExpressionLogical(57, expression);
            }
        }
        Expression expression = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(expression);
    }

    Expression XreadPredicateRightPart(Expression expression) {
        boolean bl = false;
        ExpressionLogical expressionLogical = null;
        if (this.token.tokenType == 183) {
            this.read();
            bl = true;
        }
        block0 : switch (this.token.tokenType) {
            case 142: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 183) {
                    bl = true;
                    this.read();
                }
                if (this.token.tokenType == 85) {
                    this.read();
                    this.readThis(115);
                    Expression expression2 = this.XreadRowValuePredicand();
                    expressionLogical = new ExpressionLogical(58, expression, expression2);
                    bl = !bl;
                    break;
                }
                if (this.token.tokenType == 186 || this.token.tokenType == 300) {
                    this.read();
                    expressionLogical = new ExpressionLogical(47, expression);
                    break;
                }
                throw this.unexpectedToken();
            }
            case 154: {
                expressionLogical = this.XreadLikePredicateRightPart(expression);
                expressionLogical.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 18: {
                expressionLogical = this.XreadBetweenPredicateRightPart(expression);
                break;
            }
            case 130: {
                expressionLogical = this.XreadInPredicateRightPart(expression);
                expressionLogical.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 202: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadOverlapsPredicateRightPart(expression);
                break;
            }
            case 396: 
            case 779: 
            case 780: 
            case 782: 
            case 783: 
            case 785: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                int n = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 2: 
                    case 6: 
                    case 258: {
                        expressionLogical = this.XreadQuantifiedComparisonRightPart(n, expression);
                        break block0;
                    }
                }
                Expression expression3 = this.XreadRowValuePredicand();
                expressionLogical = new ExpressionLogical(n, expression, expression3);
                break;
            }
            case 162: {
                expressionLogical = this.XreadMatchPredicateRightPart(expression);
                break;
            }
            default: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                return expression;
            }
        }
        if (bl) {
            expressionLogical = new ExpressionLogical(48, (Expression)expressionLogical);
        }
        return expressionLogical;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression expression) {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 12) {
            this.read();
        } else if (this.token.tokenType == 275) {
            bl = true;
            this.read();
        }
        Expression expression2 = this.XreadRowValuePredicand();
        this.readThis(5);
        Expression expression3 = this.XreadRowValuePredicand();
        ExpressionLogical expressionLogical = new ExpressionLogical(42, expression, expression2);
        ExpressionLogical expressionLogical2 = new ExpressionLogical(45, expression, expression3);
        ExpressionLogical expressionLogical3 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
        if (bl) {
            expressionLogical = new ExpressionLogical(45, expression, expression2);
            expressionLogical2 = new ExpressionLogical(42, expression, expression3);
            ExpressionLogical expressionLogical4 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
            return new ExpressionLogical(50, expressionLogical3, expressionLogical4);
        }
        return expressionLogical3;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int n, Expression expression) {
        Expression expression2;
        Object object;
        int n2 = this.token.tokenType;
        int n3 = 0;
        switch (this.token.tokenType) {
            case 6: 
            case 258: {
                n3 = 52;
                break;
            }
            case 2: {
                n3 = 51;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ParserDQL");
            }
        }
        this.read();
        this.readThis(786);
        int n4 = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: {
                this.rewind(n4);
                object = this.XreadSubqueryBody(54);
                expression2 = new Expression(23, (SubQuery)object);
                this.readThis(772);
                break;
            }
            default: {
                this.rewind(n4);
                expression2 = this.readAggregateExpression(n2);
                this.readThis(772);
                this.readFilterClause(expression2);
            }
        }
        object = new ExpressionLogical(n, expression, expression2);
        ((ExpressionLogical)object).setSubType(n3);
        return object;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression expression) {
        Object object;
        int n = expression.getDegree();
        Expression expression2 = null;
        this.read();
        this.readThis(786);
        int n2 = this.getPosition();
        int n3 = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 301: {
                expression2 = this.XreadCollectionDerivedTable();
                expression2.getTable().getSubQuery().setUniqueRows();
                this.readThis(772);
                this.readCloseBrackets(n3);
                break;
            }
            case 251: 
            case 278: 
            case 308: {
                this.rewind(n2);
                object = this.XreadSubqueryBody(54);
                expression2 = new Expression(23, (SubQuery)object);
                this.readThis(772);
                break;
            }
            default: {
                this.rewind(n2);
                expression2 = this.XreadInValueListConstructor(n);
                this.readThis(772);
            }
        }
        if (this.isCheckOrTriggerCondition) {
            object = new ExpressionLogical(54, expression, expression2);
        } else {
            object = new ExpressionLogical(41, expression, expression2);
            ((ExpressionLogical)object).setSubType(52);
        }
        return object;
    }

    Expression XreadInValueList(int n) {
        Expression[] expressionArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            if ((expressionArray = this.XreadValueExpression()).getType() != 25) {
                expressionArray = new Expression(25, new Expression[]{expressionArray});
            }
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        Expression expression = new Expression(26, expressionArray);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression[] expressionArray2;
            if (expressionArray[i].getType() != 25) {
                expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
            }
            if ((expressionArray2 = expressionArray[i].nodes).length != n) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < n; ++j) {
                if (expressionArray2[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return expression;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression expression) {
        this.read();
        Expression expression2 = this.XreadStringValueExpression();
        Expression expression3 = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            expression3 = this.XreadStringValueExpression();
        }
        return new ExpressionLike(expression, expression2, expression3, this.isCheckOrTriggerCondition);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression expression) {
        boolean bl = false;
        int n = 59;
        this.read();
        if (this.token.tokenType == 299) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 511) {
            this.read();
            n = bl ? 62 : 59;
        } else if (this.token.tokenType == 470) {
            this.read();
            n = bl ? 63 : 60;
        } else if (this.token.tokenType == 116) {
            this.read();
            n = bl ? 64 : 61;
        }
        int n2 = bl ? 23 : 54;
        Expression expression2 = this.XreadTableSubquery(n2);
        return new ExpressionLogical(n, expression, expression2);
    }

    private ExpressionLogical XreadOverlapsPredicateRightPart(Expression expression) {
        if (expression.getType() != 25) {
            throw Error.error(5564);
        }
        if (expression.nodes.length != 2) {
            throw Error.error(5564);
        }
        this.read();
        if (this.token.tokenType != 786) {
            throw this.unexpectedToken();
        }
        Expression expression2 = this.XreadRowValuePredicand();
        if (expression2.nodes.length != 2) {
            throw Error.error(5564);
        }
        return new ExpressionLogical(56, expression, expression2);
    }

    Expression XreadRowValueExpression() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
        }
        return expression;
    }

    Expression XreadRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        expression = this.XreadRowOrCommonValueExpression();
        if (expression != null) {
            return expression;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 786: {
                this.read();
                int n = this.getPosition();
                int n2 = this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 251: 
                    case 278: 
                    case 308: {
                        this.rewind(n);
                        SubQuery subQuery = this.XreadSubqueryBody(22);
                        this.readThis(772);
                        return new Expression(22, subQuery);
                    }
                }
                this.rewind(n);
                Expression expression = this.XreadRowElementList(true);
                this.readThis(772);
                return expression;
            }
            case 243: {
                this.read();
                this.readThis(786);
                Expression expression = this.XreadRowElementList(false);
                this.readThis(772);
                return expression;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean bl) {
        Expression expression;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl && hsqlArrayList.size() == 1) {
            return expression;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(25, expressionArray);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadTableSubquery(int n) {
        this.readThis(786);
        SubQuery subQuery = this.XreadSubqueryBody(n);
        this.readThis(772);
        return new Expression(23, subQuery);
    }

    Table XreadTableSubqueryOrNull(RangeVariable[] rangeVariableArray) {
        boolean bl = false;
        int n = this.getPosition();
        this.readThis(786);
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: 
            case 319: {
                break;
            }
            default: {
                bl = true;
            }
        }
        this.rewind(n);
        if (bl) {
            return null;
        }
        boolean bl2 = rangeVariableArray != null;
        this.readThis(786);
        SubQuery subQuery = this.XreadSubqueryBody(23);
        HsqlList hsqlList = subQuery.queryExpression.getUnresolvedExpressions();
        if (bl2 && hsqlList != null) {
            hsqlList = Expression.resolveColumnSet(this.session, rangeVariableArray, rangeVariableArray.length, subQuery.queryExpression.getUnresolvedExpressions(), null);
        }
        ExpressionColumn.checkColumnsResolved(hsqlList);
        subQuery.queryExpression.resolveTypes(this.session);
        subQuery.prepareTable(this.session);
        this.readThis(772);
        return subQuery.getTable();
    }

    SubQuery XreadJoinedTableAsSubquery() {
        this.readThis(786);
        int n = this.getPosition();
        this.compileContext.subqueryDepth++;
        QuerySpecification querySpecification = this.XreadJoinedTableAsView();
        querySpecification.resolve(this.session);
        if (querySpecification.rangeVariables.length < 2) {
            throw this.unexpectedTokenRequire("JOIN");
        }
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, (QueryExpression)querySpecification, 23);
        subQuery.sql = this.getLastPart(n);
        this.readThis(772);
        subQuery.prepareTable(this.session);
        this.compileContext.subqueryDepth--;
        return subQuery;
    }

    QuerySpecification XreadJoinedTableAsView() {
        QuerySpecification querySpecification = new QuerySpecification(this.compileContext);
        ExpressionColumn expressionColumn = new ExpressionColumn(97);
        querySpecification.addSelectColumnExpression(expressionColumn);
        this.XreadTableReference(querySpecification);
        return querySpecification;
    }

    SubQuery XreadTableNamedSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray, int n) {
        switch (n) {
            case 24: {
                SubQuery subQuery = this.XreadRecursiveSubqueryBody(hsqlName, hsqlNameArray);
                return subQuery;
            }
            case 23: {
                SubQuery subQuery = this.XreadSubqueryBody(n);
                ExpressionColumn.checkColumnsResolved(subQuery.queryExpression.unresolvedExpressions);
                subQuery.queryExpression.resolveTypes(this.session);
                subQuery.prepareTable(this.session, hsqlName, hsqlNameArray);
                return subQuery;
            }
        }
        throw super.unexpectedToken();
    }

    SubQuery XreadRecursiveSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray) {
        int n = this.getPosition();
        this.compileContext.subqueryDepth++;
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadSimpleTable();
        queryExpression.resolve(this.session);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        this.compileContext.subqueryDepth--;
        subQuery.prepareTable(this.session, hsqlName, hsqlNameArray);
        this.compileContext.initSubqueryNames();
        this.compileContext.registerSubquery(hsqlName.name, subQuery);
        RangeVariable rangeVariable = new RangeVariable(subQuery.getTable(), this.compileContext.getNextRangeVarIndex());
        RangeVariable[] rangeVariableArray = new RangeVariable[]{rangeVariable};
        if (this.token.tokenType != 298) {
            throw this.unexpectedTokenRequire("UNION");
        }
        int n2 = this.XreadUnionType();
        QuerySpecification querySpecification = this.XreadSimpleTable();
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        ((QueryExpression)querySpecification).resolveReferences(this.session, rangeVariableArray);
        queryExpression.addUnion(querySpecification, n2);
        queryExpression.resolve(this.session);
        queryExpression.createTable(this.session);
        subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, subQuery);
        subQuery.prepareTable(this.session, hsqlName, hsqlNameArray);
        subQuery.sql = this.getLastPart(n);
        this.compileContext.subqueryDepth--;
        return subQuery;
    }

    SubQuery XreadSubqueryBody(int n) {
        int n2 = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.resolveReferences(this.session, RangeVariable.emptyArray);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, n);
        subQuery.sql = this.getLastPart(n2);
        this.compileContext.subqueryDepth--;
        return subQuery;
    }

    SubQuery XreadViewSubquery(View view) {
        QueryExpression queryExpression;
        this.compileContext.subqueryDepth++;
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, view);
        this.compileContext.subqueryDepth--;
        return subQuery;
    }

    Expression XreadContextuallyTypedTable(int n) {
        int n2;
        Expression expression = this.readRow();
        Expression[] expressionArray = expression.nodes;
        boolean bl = false;
        if (n == 1) {
            if (expression.getType() == 25) {
                expression.opType = 26;
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray[i].getType() != 25) {
                        expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
                        continue;
                    }
                    if (expressionArray[i].nodes.length == n) continue;
                    throw Error.error(5564);
                }
                return expression;
            }
            expression = new Expression(25, new Expression[]{expression});
            expression = new Expression(26, new Expression[]{expression});
            return expression;
        }
        if (expression.getType() != 25) {
            throw Error.error(5564);
        }
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            if (expressionArray[n2].getType() != 25) continue;
            bl = true;
            break;
        }
        if (bl) {
            expression.opType = 26;
            for (n2 = 0; n2 < expressionArray.length; ++n2) {
                if (expressionArray[n2].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] expressionArray2 = expressionArray[n2].nodes;
                if (expressionArray2.length != n) {
                    throw Error.error(5564);
                }
                for (int i = 0; i < n; ++i) {
                    if (expressionArray2[i].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (expressionArray.length != n) {
                throw Error.error(5564);
            }
            expression = new Expression(26, new Expression[]{expression});
        }
        return expression;
    }

    private Expression XreadInValueListConstructor(int n) {
        int n2 = this.getPosition();
        this.compileContext.subqueryDepth++;
        Expression expression = this.XreadInValueList(n);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, expression, 54);
        subQuery.sql = this.getLastPart(n2);
        this.compileContext.subqueryDepth--;
        return expression;
    }

    private SubQuery XreadRowValueExpressionList() {
        this.compileContext.subqueryDepth++;
        Expression expression = this.XreadRowValueExpressionListBody();
        SubQuery subQuery = this.prepareSubquery(expression);
        this.compileContext.subqueryDepth--;
        return subQuery;
    }

    private SubQuery prepareSubquery(Expression expression) {
        HsqlList hsqlList = expression.resolveColumnReferences(this.session, RangeVariable.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        expression.resolveTypes(this.session, null);
        expression.prepareTable(this.session, null, expression.nodes[0].nodes.length);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, expression, 26);
        subQuery.prepareTable(this.session);
        return subQuery;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression expression = null;
        while (true) {
            int n = this.readOpenBrackets();
            Expression expression2 = this.readRow();
            this.readCloseBrackets(n);
            if (expression == null) {
                expression = new Expression(25, new Expression[]{expression2});
            } else {
                expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                expression.nodes[expression.nodes.length - 1] = expression2;
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
        Expression[] expressionArray = expression.nodes;
        int n = 1;
        if (expressionArray[0].getType() == 25) {
            n = expressionArray[0].nodes.length;
        }
        expression.opType = 26;
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i].getType() == 25) {
                if (expressionArray[i].nodes.length == n) continue;
                throw Error.error(5564);
            }
            if (n != 1) {
                throw Error.error(5564);
            }
            expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
        }
        return expression;
    }

    Expression XreadTargetSpecification(RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        ColumnBase columnBase = null;
        int n = -1;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            if (rangeVariableArray[i] == null || (n = rangeVariableArray[i].findColumn(this.token.tokenString)) <= -1 || !rangeVariableArray[i].resolvesTableName(this.token.namePrefix) || !rangeVariableArray[i].resolvesSchemaName(this.token.namePrePrefix)) continue;
            columnBase = rangeVariableArray[i].getColumn(n);
            this.read();
            break;
        }
        if (columnBase == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        longDeque.add(n);
        if (this.token.tokenType == 781) {
            if (!columnBase.getDataType().isArrayType()) {
                throw this.unexpectedToken();
            }
            this.read();
            Expression expression = this.XreadNumericValueExpression();
            if (expression == null) {
                throw Error.error(5501, this.token.tokenString);
            }
            expression = new ExpressionAccessor(((ColumnSchema)columnBase).getAccessor(), expression);
            this.readThis(790);
            return expression;
        }
        return ((ColumnSchema)columnBase).getAccessor();
    }

    Expression XreadCollectionDerivedTable() {
        Expression[] expressionArray;
        boolean bl = false;
        int n = this.getPosition();
        this.readThis(301);
        this.readThis(786);
        this.compileContext.subqueryDepth++;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            expressionArray = this.XreadValueExpression();
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        if (this.token.tokenType == 319) {
            this.read();
            this.readThis(458);
            bl = true;
        }
        ExpressionTable expressionTable = new ExpressionTable(expressionArray, null, bl);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, expressionTable, 23);
        subQuery.createTable();
        subQuery.sql = this.getLastPart(n);
        return expressionTable;
    }

    Expression XreadTableFunctionDerivedTable() {
        int n = this.getPosition();
        this.readThis(278);
        this.readThis(786);
        this.compileContext.subqueryDepth++;
        Expression expression = this.XreadValueExpression();
        if (expression.getType() != 27 && expression.getType() != 28) {
            this.compileContext.subqueryDepth--;
            throw this.unexpectedToken("TABLE");
        }
        this.readThis(772);
        expression = new ExpressionTable(new Expression[]{expression}, null, false);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, expression, 23);
        subQuery.createTable();
        subQuery.sql = this.getLastPart(n);
        this.compileContext.subqueryDepth--;
        return expression;
    }

    Expression XreadLateralDerivedTable() {
        this.readThis(149);
        this.readThis(786);
        int n = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        subQuery.createTable();
        subQuery.sql = this.getLastPart(n);
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        return new Expression(23, subQuery);
    }

    Expression XreadArrayConstructor() {
        this.readThis(786);
        int n = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.resolveReferences(this.session, RangeVariable.emptyArray);
        SubQuery subQuery = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        subQuery.sql = this.getLastPart(n);
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        return new Expression(100, subQuery);
    }

    SchemaObject readCollateClauseOrNull() {
        if (this.token.tokenType == 41) {
            this.read();
            SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.namePrefix, this.token.tokenString, 15);
            return schemaObject;
        }
        return null;
    }

    Expression XreadArrayElementReference(Expression expression) {
        if (this.token.tokenType == 781) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(790);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression readRow() {
        Expression expression = null;
        while (true) {
            Expression expression2 = this.XreadValueExpressionWithContext();
            if (expression == null) {
                expression = expression2;
            } else if (expression.getType() == 25) {
                if (expression2.getType() == 25 && expression.nodes[0].getType() != 25) {
                    expression = new Expression(25, new Expression[]{expression, expression2});
                } else {
                    expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                    expression.nodes[expression.nodes.length - 1] = expression2;
                }
            } else {
                expression = new Expression(25, new Expression[]{expression, expression2});
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
        return expression;
    }

    Expression readCaseExpression() {
        Expression expression = null;
        this.read();
        if (this.token.tokenType != 314) {
            expression = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(expression);
    }

    private Expression readCaseWhen(Expression expression) {
        Expression expression2;
        this.readThis(314);
        Expression expression3 = null;
        if (expression == null) {
            expression3 = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                if (expression == (expression2 = this.XreadPredicateRightPart(expression))) {
                    expression2 = new ExpressionLogical(expression, this.XreadRowValuePredicand());
                }
                expression3 = expression3 == null ? expression2 : new ExpressionLogical(50, expression3, expression2);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        this.readThis(280);
        expression2 = this.XreadValueExpression();
        Expression expression4 = null;
        if (this.token.tokenType == 314) {
            expression4 = this.readCaseWhen(expression);
        } else if (this.token.tokenType == 92) {
            this.read();
            expression4 = this.XreadValueExpression();
            this.readThis(94);
            this.readIfThis(29);
        } else {
            expression4 = new ExpressionValue(null, Type.SQL_ALL_TYPES);
            this.readThis(94);
            this.readIfThis(29);
        }
        ExpressionOp expressionOp = new ExpressionOp(96, expression2, expression4);
        ExpressionOp expressionOp2 = new ExpressionOp(93, expression3, expressionOp);
        return expressionOp2;
    }

    private Expression readCaseWhenExpressionOrNull() {
        Expression expression = null;
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        expression = this.XreadBooleanValueExpression();
        this.readThis(774);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(774);
        ExpressionOp expressionOp = new ExpressionOp(96, expression2, this.XreadValueExpression());
        expression = new ExpressionOp(93, expression, expressionOp);
        this.readThis(772);
        return expression;
    }

    private Expression readCastExpressionOrNull() {
        Expression expression;
        Type type;
        boolean bl = this.token.tokenType == 49;
        int n = this.getPosition();
        this.read();
        if (bl) {
            if (!this.readIfThis(786)) {
                this.rewind(n);
                return null;
            }
            if (this.database.sqlSyntaxMss) {
                type = this.readTypeDefinition(false, true);
                this.readThis(774);
                expression = this.XreadValueExpressionOrNull();
            } else {
                expression = this.XreadValueExpressionOrNull();
                this.readThis(774);
                type = Type.getTypeForJDBCConvertToken(this.token.tokenType);
                if (type == null) {
                    type = this.readTypeDefinition(false, true);
                } else {
                    this.read();
                }
            }
        } else {
            this.readThis(786);
            expression = this.XreadValueExpressionOrNull();
            this.readThis(10);
            type = this.readTypeDefinition(false, true);
        }
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, type);
        } else {
            expression = new ExpressionOp(expression, type);
        }
        this.readThis(772);
        return expression;
    }

    private Expression readColumnOrFunctionExpression() {
        Expression expression;
        Object object;
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedSimpleName();
        String string2 = this.token.namePrefix;
        String string3 = this.token.namePrePrefix;
        String string4 = this.token.namePrePrePrefix;
        Token token = this.getRecordedToken();
        this.checkIsIdentifier();
        if (this.isUndelimitedSimpleName()) {
            Expression expression2;
            object = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
            if (object != null) {
                int n = this.getPosition();
                try {
                    expression = this.readSQLFunction((FunctionSQL)object);
                    if (expression != null) {
                        return expression;
                    }
                }
                catch (HsqlException hsqlException) {
                    hsqlException.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                        this.lastError = hsqlException;
                    }
                    this.rewind(n);
                }
            } else if (this.isReservedKey() && (object = FunctionSQL.newSQLFunction(string, this.compileContext)) != null && (expression2 = this.readSQLFunction((FunctionSQL)object)) != null) {
                return expression2;
            }
        }
        this.read();
        if (this.token.tokenType != 786) {
            this.checkValidCatalogName(string4);
            object = new ExpressionColumn(string3, string2, string);
            return object;
        }
        if (string4 != null) {
            throw Error.error(5551, string4);
        }
        this.checkValidCatalogName(string3);
        string2 = this.session.getSchemaName(string2);
        object = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, string2, 16);
        if (object == null && bl) {
            HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getDefaultSchemaHsqlName();
            object = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, hsqlName.name, 16);
            if (object == null) {
                Routine.createRoutines(this.session, hsqlName, string);
                object = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, hsqlName.name, 16);
            }
        }
        if (object == null) {
            throw Error.error(5501, string);
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.readThis(786);
        if (this.token.tokenType == 772) {
            this.read();
        } else {
            while (true) {
                expression = this.XreadValueExpression();
                hsqlArrayList.add(expression);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            this.readThis(772);
        }
        expression = new FunctionSQLInvoked((RoutineSchema)object);
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        ((FunctionSQLInvoked)expression).setArguments(expressionArray);
        this.compileContext.addFunctionCall((FunctionSQLInvoked)expression);
        token.setExpression(object);
        return expression;
    }

    Expression readCollection(int n) {
        this.read();
        if (this.token.tokenType == 786) {
            return this.XreadArrayConstructor();
        }
        this.readThis(781);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n2 = 0;
        while (true) {
            if (this.token.tokenType == 790) break;
            if (n2 > 0) {
                this.readThis(774);
            }
            Expression expression = this.XreadValueExpressionOrNull();
            hsqlArrayList.add(expression);
            ++n2;
        }
        this.read();
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(19, expressionArray);
    }

    private Expression readDecodeExpressionOrNull() {
        ExpressionOp expressionOp;
        block6: {
            int n = this.getPosition();
            this.read();
            if (!this.readIfThis(786)) {
                this.rewind(n);
                return null;
            }
            expressionOp = null;
            Expression expression = null;
            Expression expression2 = this.XreadValueExpression();
            this.readThis(774);
            while (true) {
                Expression expression3 = this.XreadValueExpression();
                if (this.token.tokenType != 774) {
                    if (expression == null) {
                        throw this.unexpectedToken();
                    }
                    expression.setRightNode(expression3);
                    break block6;
                }
                this.readThis(774);
                ExpressionLogical expressionLogical = new ExpressionLogical(expression2, expression3);
                Expression expression4 = this.XreadValueExpression();
                ExpressionOp expressionOp2 = new ExpressionOp(96, expression4, null);
                ExpressionOp expressionOp3 = new ExpressionOp(93, expressionLogical, expressionOp2);
                if (expressionOp == null) {
                    expressionOp = expressionOp3;
                } else {
                    expression.setRightNode(expressionOp3);
                }
                expression = expressionOp2;
                if (this.token.tokenType != 774) break;
                this.readThis(774);
            }
            expression.setRightNode(new ExpressionValue(null, null));
        }
        this.readThis(772);
        return expressionOp;
    }

    private Expression readConcatExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(774);
        while (true) {
            Expression expression2 = this.XreadValueExpression();
            expression = new ExpressionArithmetic(36, expression, expression2);
            if (this.token.tokenType == 774) {
                this.readThis(774);
                continue;
            }
            if (this.token.tokenType == 772) break;
        }
        this.readThis(772);
        return expression;
    }

    private Expression readLeastExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 44);
            if (this.token.tokenType != 774) break;
            this.readThis(774);
        }
        this.readThis(772);
        return expression;
    }

    private Expression readGreatestExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 43);
            if (this.token.tokenType != 774) break;
            this.readThis(774);
        }
        this.readThis(772);
        return expression;
    }

    private Expression readValue(Expression expression, int n) {
        Expression expression2 = this.XreadValueExpression();
        if (expression == null) {
            return expression2;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(n, expression, expression2);
        ExpressionOp expressionOp = new ExpressionOp(96, expression, expression2);
        return new ExpressionOp(93, expressionLogical, expressionOp);
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(786);
        Expression expression = this.XreadValueExpression();
        this.readThis(774);
        ExpressionOp expressionOp = new ExpressionOp(96, new ExpressionValue(null, (Type)null), expression);
        expression = new ExpressionLogical(expression, this.XreadValueExpression());
        expression = new ExpressionOp(93, expression, expressionOp);
        this.readThis(772);
        return expression;
    }

    private Expression readIfNullExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(774);
        Expression expression2 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(96, expression2, expression);
        expression = new ExpressionOp(93, expressionLogical, expressionOp);
        expression.setSubType(91);
        this.readThis(772);
        return expression;
    }

    private Expression readIfNull2ExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(786)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(774);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(774);
        Expression expression3 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(96, expression3, expression2);
        expression = new ExpressionOp(93, expressionLogical, expressionOp);
        expression.setSubType(91);
        this.readThis(772);
        return expression;
    }

    private Expression readCoalesceExpression() {
        Expression expression;
        ExpressionOp expressionOp = null;
        this.read();
        this.readThis(786);
        Expression expression2 = null;
        while (true) {
            expression = this.XreadValueExpression();
            if (expression2 != null && this.token.tokenType == 772) break;
            ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
            ExpressionOp expressionOp2 = new ExpressionOp(96, new ExpressionValue(null, (Type)null), expression);
            ExpressionOp expressionOp3 = new ExpressionOp(93, expressionLogical, expressionOp2);
            if (expressionOp == null) {
                expressionOp = expressionOp3;
            } else {
                expression2.setLeftNode(expressionOp3);
            }
            expression2 = expressionOp2;
            this.readThis(774);
        }
        this.readThis(772);
        expression2.setLeftNode(expression);
        return expressionOp;
    }

    Expression readSQLFunction(FunctionSQL functionSQL) {
        int n = this.getPosition();
        this.read();
        short[] sArray = functionSQL.parseList;
        if (sArray.length == 0) {
            return functionSQL;
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl = this.token.tokenType == 786;
        try {
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        catch (HsqlException hsqlException) {
            if (!bl) {
                this.rewind(n);
                return null;
            }
            if (functionSQL.parseListAlt == null) {
                throw hsqlException;
            }
            this.rewind(n);
            this.read();
            sArray = functionSQL.parseListAlt;
            hsqlArrayList = new HsqlArrayList();
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        functionSQL.setArguments(expressionArray);
        return functionSQL.getFunctionExpression();
    }

    void readExpression(HsqlArrayList hsqlArrayList, short[] sArray, int n, int n2, boolean bl) {
        block9: for (int i = n; i < n + n2; ++i) {
            short s = sArray[i];
            switch (s) {
                case 788: {
                    Expression expression = null;
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    hsqlArrayList.add(expression);
                    continue block9;
                }
                case 844: {
                    ExpressionValue expressionValue = null;
                    Object object = this.readIntegerObject();
                    if ((Integer)object < 0) {
                        throw Error.error(5592);
                    }
                    expressionValue = new ExpressionValue(object, Type.SQL_INTEGER);
                    hsqlArrayList.add(expressionValue);
                    continue block9;
                }
                case 842: {
                    int n3 = hsqlArrayList.size();
                    int n4 = this.getPosition();
                    int n5 = ++i;
                    ++i;
                    int n6 = sArray[n5];
                    int n7 = hsqlArrayList.size();
                    try {
                        this.readExpression(hsqlArrayList, sArray, i, n6, true);
                    }
                    catch (HsqlException hsqlException) {
                        hsqlException.setLevel(this.compileContext.subqueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                            this.lastError = hsqlException;
                        }
                        this.rewind(n4);
                        hsqlArrayList.setSize(n3);
                        for (int j = i; j < i + n6; ++j) {
                            if (sArray[j] != 788 && sArray[j] != 841 && sArray[j] != 844) continue;
                            hsqlArrayList.add(null);
                        }
                        i += n6 - 1;
                        continue block9;
                    }
                    if (n7 == hsqlArrayList.size()) {
                        hsqlArrayList.add(null);
                    }
                    i += n6 - 1;
                    continue block9;
                }
                case 843: {
                    int n6;
                    int n8 = ++i;
                    short s2 = sArray[n8];
                    int n9 = ++i;
                    do {
                        n6 = hsqlArrayList.size();
                        this.readExpression(hsqlArrayList, sArray, n9, s2, true);
                    } while (hsqlArrayList.size() != n6);
                    i += s2 - 1;
                    continue block9;
                }
                case 841: {
                    short s3 = sArray[++i];
                    Object object = null;
                    if (ArrayUtil.find(sArray, this.token.tokenType, i + 1, s3) == -1) {
                        if (!bl) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        object = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    hsqlArrayList.add(object);
                    i += s3;
                    continue block9;
                }
                default: {
                    if (this.token.tokenType != s) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block9;
                }
            }
        }
    }

    private Expression readSequenceExpressionOrNull(int n) {
        int n2 = this.getPosition();
        this.read();
        if (this.token.tokenType != 307) {
            this.rewind(n2);
            return null;
        }
        this.readThis(307);
        this.readThis(112);
        this.checkIsSchemaObjectName();
        String string = this.session.getSchemaName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, string, true);
        Token token = this.getRecordedToken();
        this.read();
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, n);
        token.setExpression(numberSequence);
        this.compileContext.addSequence(numberSequence);
        return expressionColumn;
    }

    HsqlNameManager.SimpleName readSimpleName() {
        this.checkIsSimpleName();
        HsqlNameManager.SimpleName simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        return simpleName;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 2);
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int n, boolean bl) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), n);
        if (this.token.namePrefix != null) {
            switch (n) {
                case 1: 
                case 11: 
                case 21: 
                case 22: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && "MODULE".equals(this.token.namePrefix) && !this.token.isDelimitedPrefix) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 25: 
                case 26: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    if (this.token.namePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName hsqlName2;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (bl) {
                        hsqlName2 = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        hsqlName2 = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (hsqlName2 == null) {
                            hsqlName2 = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(hsqlName2);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        hsqlName2.parent = hsqlName;
        hsqlName2.setSchemaIfNull(hsqlName.schema);
        if (hsqlName2.schema != null && hsqlName.schema != null && hsqlName2.schema != hsqlName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return hsqlName2;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return hsqlName;
    }

    SchemaObject readSchemaObjectName(int n) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        String string = this.session.getSchemaName(this.token.namePrefix);
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, string, n);
        this.read();
        return schemaObject;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        this.checkIsSchemaObjectName();
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, hsqlName.name, n);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(hsqlName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return schemaObject;
    }

    Table readTableName() {
        this.checkIsIdentifier();
        if (this.token.namePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrefix);
        }
        Table table = this.database.schemaManager.getTable(this.session, this.token.tokenString, this.token.namePrefix);
        this.getRecordedToken().setExpression(table);
        this.read();
        return table;
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVariable, boolean bl) {
        int n;
        ColumnSchema columnSchema = null;
        this.checkIsIdentifier();
        if (bl) {
            if (!rangeVariable.resolvesTableName(this.token.namePrefix) || !rangeVariable.resolvesSchemaName(this.token.namePrePrefix)) {
                throw Error.error(5501, this.token.namePrefix);
            }
        } else if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        if ((n = rangeVariable.findColumn(this.token.tokenString)) > -1) {
            columnSchema = rangeVariable.getTable().getColumn(n);
            this.read();
            return columnSchema;
        }
        throw Error.error(5501, this.token.tokenString);
    }

    ColumnSchema readSimpleColumnName(Table table, boolean bl) {
        int n;
        this.checkIsIdentifier();
        if (bl) {
            if (this.token.namePrefix != null && !table.getName().name.equals(this.token.namePrefix)) {
                throw Error.error(5501, this.token.namePrefix);
            }
        } else if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        if ((n = table.findColumn(this.token.tokenString)) == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema columnSchema = table.getColumn(n);
        this.read();
        return columnSchema;
    }

    StatementQuery compileDeclareCursor(boolean bl, RangeVariable[] rangeVariableArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = super.getPosition();
        this.readThis(77);
        HsqlNameManager.SimpleName simpleName = this.readSimpleName();
        switch (this.token.tokenType) {
            case 252: {
                this.read();
                n2 = 2;
                break;
            }
            case 134: {
                this.read();
                n2 = 1;
                break;
            }
            case 11: {
                this.read();
            }
        }
        if (this.token.tokenType == 180) {
            this.readThis(248);
        } else if (this.token.tokenType == 248) {
            this.read();
            n3 = 1;
        }
        if (this.token.tokenType != 70) {
            this.rewind(n6);
            return null;
        }
        this.readThis(70);
        for (n = 0; n < 2; ++n) {
            if (this.token.tokenType == 319) {
                this.read();
                if (n == 0 && this.token.tokenType == 126) {
                    this.read();
                    n4 = 1;
                    continue;
                }
                this.readThis(237);
                ++n;
                n5 = 1;
                continue;
            }
            if (this.token.tokenType != 321) continue;
            this.read();
            if (n == 0 && this.token.tokenType == 126) {
                this.read();
                continue;
            }
            this.readThis(237);
            ++n;
        }
        this.readThis(112);
        n = ResultProperties.getProperties(n2, 1, n3, n4, n5);
        StatementQuery statementQuery = this.compileCursorSpecification(n, bl, rangeVariableArray);
        statementQuery.setCursorName(simpleName);
        return statementQuery;
    }

    StatementQuery compileCursorSpecification(int n, boolean bl, RangeVariable[] rangeVariableArray) {
        OrderedHashSet orderedHashSet = null;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (this.token.tokenType == 112) {
            this.read();
            if (this.token.tokenType == 480) {
                this.read();
                this.readThis(195);
            } else {
                this.readThis(303);
                n = ResultProperties.addUpdatable(n, true);
                if (this.token.tokenType == 191) {
                    this.readThis(191);
                    orderedHashSet = new OrderedHashSet();
                    this.readColumnNameList(orderedHashSet, null, false);
                }
            }
        }
        if (ResultProperties.isUpdatable(n)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, rangeVariableArray, null);
        StatementQuery statementQuery = bl ? new StatementCursor(this.session, queryExpression, this.compileContext) : new StatementQuery(this.session, queryExpression, this.compileContext);
        return statementQuery;
    }

    StatementDMQL compileShortCursorSpecification(int n) {
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (ResultProperties.isUpdatable(n)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        return statementQuery;
    }

    int readCloseBrackets(int n) {
        int n2;
        for (n2 = 0; n2 < n && this.token.tokenType == 772; ++n2) {
            this.read();
        }
        return n2;
    }

    int readOpenBrackets() {
        int n = 0;
        while (this.token.tokenType == 786) {
            ++n;
            this.read();
        }
        return n;
    }

    void checkValidCatalogName(String string) {
        if (string != null && !string.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, string);
        }
    }

    void rewind(int n) {
        super.rewind(n);
        this.compileContext.rewind(n);
    }

    public static final class CompileContext {
        final Session session;
        final ParserBase parser;
        private int subqueryDepth;
        private HsqlArrayList namedSubqueries;
        private OrderedIntKeyHashMap parameters = new OrderedIntKeyHashMap();
        private HsqlArrayList usedSequences = new HsqlArrayList(true);
        private HsqlArrayList usedRoutines = new HsqlArrayList(true);
        private HsqlArrayList rangeVariables = new HsqlArrayList(true);
        private HsqlArrayList usedObjects = new HsqlArrayList(true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        Routine callProcedure;
        private int rangeVarIndex = 0;

        public CompileContext(Session session, ParserBase parserBase) {
            this.session = session;
            this.parser = parserBase;
            this.reset();
        }

        public void reset() {
            this.reset(1);
        }

        public void reset(int n) {
            this.rangeVarIndex = n;
            this.rangeVariables.clear();
            this.subqueryDepth = 0;
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.callProcedure = null;
            this.usedObjects.clear();
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public void rewind(int n) {
            for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
                RangeVariable rangeVariable = (RangeVariable)this.rangeVariables.get(i);
                if (rangeVariable.parsePosition <= n) continue;
                this.rangeVariables.remove(i);
            }
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.nextInt();
                if (n2 < n) continue;
                iterator.remove();
            }
        }

        public void registerRangeVariable(RangeVariable rangeVariable) {
            rangeVariable.parsePosition = this.parser == null ? 0 : this.parser.getPosition();
            rangeVariable.rangePosition = this.getNextRangeVarIndex();
            rangeVariable.level = this.subqueryDepth;
            this.rangeVariables.add(rangeVariable);
        }

        public int getNextRangeVarIndex() {
            return this.rangeVarIndex++;
        }

        public int getRangeVarCount() {
            return this.rangeVarIndex;
        }

        public RangeVariable[] getRangeVariables() {
            RangeVariable[] rangeVariableArray = new RangeVariable[this.rangeVariables.size()];
            this.rangeVariables.toArray(rangeVariableArray);
            return rangeVariableArray;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.size() == 0) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] numberSequenceArray = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(numberSequenceArray);
            return numberSequenceArray;
        }

        public Routine[] getRoutines() {
            if (this.callProcedure == null && this.usedRoutines.size() == 0) {
                return Routine.emptyArray;
            }
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked functionSQLInvoked = (FunctionSQLInvoked)this.usedRoutines.get(i);
                orderedHashSet.add(functionSQLInvoked.routine);
            }
            if (this.callProcedure != null) {
                orderedHashSet.add(this.callProcedure);
            }
            Object[] objectArray = new Routine[orderedHashSet.size()];
            orderedHashSet.toArray(objectArray);
            return objectArray;
        }

        private void initSubqueryNames() {
            HashMappedList hashMappedList;
            if (this.namedSubqueries == null) {
                this.namedSubqueries = new HsqlArrayList();
            }
            if (this.namedSubqueries.size() <= this.subqueryDepth) {
                this.namedSubqueries.setSize(this.subqueryDepth + 1);
            }
            if ((hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth)) == null) {
                hashMappedList = new HashMappedList();
                this.namedSubqueries.set(this.subqueryDepth, hashMappedList);
            } else {
                hashMappedList.clear();
            }
        }

        private void registerSubquery(String string, SubQuery subQuery) {
            HashMappedList hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth);
            boolean bl = hashMappedList.add(string, subQuery);
            if (!bl) {
                throw Error.error(5504);
            }
        }

        private SubQuery getNamedSubQuery(String string) {
            if (this.namedSubqueries == null) {
                return null;
            }
            for (int i = this.subqueryDepth; i >= 0; --i) {
                SubQuery subQuery;
                HashMappedList hashMappedList;
                if (this.namedSubqueries.size() <= i || (hashMappedList = (HashMappedList)this.namedSubqueries.get(i)) == null || (subQuery = (SubQuery)hashMappedList.get(string)) == null) continue;
                return subQuery;
            }
            return null;
        }

        private void addParameter(Expression expression, int n) {
            this.parameters.put(n, expression);
        }

        private void addSchemaObject(SchemaObject schemaObject) {
            this.usedObjects.add(schemaObject);
        }

        private void addSequence(SchemaObject schemaObject) {
            this.usedSequences.add(schemaObject);
        }

        void addFunctionCall(FunctionSQLInvoked functionSQLInvoked) {
            this.usedRoutines.add(functionSQLInvoked);
        }

        void addProcedureCall(Routine routine) {
            this.callProcedure = routine;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.size() == 0) {
                return ExpressionColumn.emptyArray;
            }
            Object[] objectArray = new ExpressionColumn[this.parameters.size()];
            this.parameters.valuesToArray(objectArray);
            this.parameters.clear();
            return objectArray;
        }

        void clearParameters() {
            this.parameters.clear();
        }

        public OrderedHashSet getSchemaObjectNames() {
            Object object;
            int n;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            for (n = 0; n < this.usedSequences.size(); ++n) {
                object = (SchemaObject)this.usedSequences.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.usedObjects.size(); ++n) {
                object = (SchemaObject)this.usedObjects.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.rangeVariables.size(); ++n) {
                object = (RangeVariable)this.rangeVariables.get(n);
                HsqlNameManager.HsqlName hsqlName = ((RangeVariable)object).rangeTable.getName();
                if (hsqlName.schema != SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) {
                    orderedHashSet.add(((RangeVariable)object).rangeTable.getName());
                    orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
                    continue;
                }
                if (hsqlName.type != 10) continue;
                orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
            }
            Routine[] routineArray = this.getRoutines();
            for (int i = 0; i < routineArray.length; ++i) {
                orderedHashSet.add(routineArray[i].getSpecificName());
            }
            return orderedHashSet;
        }
    }
}

