/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.store.ValuePool;

public class RangeVariableJoined
extends RangeVariable {
    RangeVariable[] rangeArray;

    RangeVariableJoined(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        super(table, simpleName, orderedHashSet, simpleNameArray, compileContext);
        QuerySpecification querySpecification = (QuerySpecification)this.rangeTable.getQueryExpression();
        this.rangeArray = querySpecification.rangeVariables;
    }

    public void setRangeTableVariables() {
        super.setRangeTableVariables();
    }

    public RangeVariable duplicate() {
        RangeVariable rangeVariable = null;
        try {
            rangeVariable = (RangeVariable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "RangeVariable");
        }
        rangeVariable.resetConditions();
        return rangeVariable;
    }

    void setJoinType(boolean bl, boolean bl2) {
        super.setJoinType(bl, bl2);
    }

    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        super.addNamedJoinColumns(orderedHashSet);
    }

    public void addColumn(int n) {
        super.addColumn(n);
    }

    public void addAllColumns() {
        super.addAllColumns();
    }

    void addNamedJoinColumnExpression(String string, Expression expression) {
        super.addNamedJoinColumnExpression(string, expression);
    }

    ExpressionColumn getColumnExpression(String string) {
        return super.getColumnExpression(string);
    }

    Table getTable() {
        return super.getTable();
    }

    boolean hasIndexCondition() {
        return super.hasIndexCondition();
    }

    boolean setDistinctColumnsOnIndex(int[] nArray) {
        return super.setDistinctColumnsOnIndex(nArray);
    }

    Index getSortIndex() {
        return super.getSortIndex();
    }

    boolean setSortIndex(Index index, boolean bl) {
        return super.setSortIndex(index, bl);
    }

    boolean reverseOrder() {
        return super.reverseOrder();
    }

    public OrderedHashSet getColumnNames() {
        return super.getColumnNames();
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        return super.getUniqueColumnNameSet();
    }

    public int findColumn(ExpressionColumn expressionColumn) {
        if (this.tableAlias != null) {
            return super.findColumn(expressionColumn);
        }
        int n = 0;
        for (int i = 0; i < this.rangeArray.length; ++i) {
            int n2 = this.rangeArray[i].findColumn(expressionColumn);
            if (n2 > -1) {
                return n + n2;
            }
            n += this.rangeArray[i].rangeTable.getColumnCount();
        }
        return -1;
    }

    public int findColumn(String string) {
        return super.findColumn(string);
    }

    ColumnSchema getColumn(String string) {
        return super.getColumn(string);
    }

    ColumnSchema getColumn(int n) {
        return super.getColumn(n);
    }

    String getColumnAlias(int n) {
        return super.getColumnAlias(n);
    }

    public HsqlNameManager.SimpleName getColumnAliasName(int n) {
        return super.getColumnAliasName(n);
    }

    boolean hasColumnAlias() {
        return super.hasColumnAlias();
    }

    String getTableAlias() {
        return super.getTableAlias();
    }

    HsqlNameManager.SimpleName getTableAliasName() {
        return super.getTableAliasName();
    }

    boolean resolvesTableName(ExpressionColumn expressionColumn) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(expressionColumn);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(expressionColumn)) continue;
            return true;
        }
        return false;
    }

    public boolean resolvesTableName(String string) {
        if (this.tableAlias != null) {
            return super.resolvesTableName(string);
        }
        for (int i = 0; i < this.rangeArray.length; ++i) {
            if (!this.rangeArray[i].resolvesTableName(string)) continue;
            return true;
        }
        return false;
    }

    boolean resolvesSchemaName(String string) {
        return super.resolvesSchemaName(string);
    }

    void addTableColumns(HsqlArrayList hsqlArrayList) {
        super.addTableColumns(hsqlArrayList);
    }

    int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        return super.addTableColumns(hsqlArrayList, n, hashSet);
    }

    void addTableColumns(Expression expression, HashSet hashSet) {
        super.addTableColumns(expression, hashSet);
    }

    void setForCheckConstraint() {
        super.setForCheckConstraint();
    }

    Expression getJoinCondition() {
        return super.getJoinCondition();
    }

    void addJoinCondition(Expression expression) {
        super.addJoinCondition(expression);
    }

    void resetConditions() {
        super.resetConditions();
    }

    OrderedHashSet getSubqueries() {
        return super.getSubqueries();
    }

    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        super.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
    }

    public void resolveRangeTable(Session session, RangeVariable[] rangeVariableArray, int n, RangeVariable[] rangeVariableArray2) {
        super.resolveRangeTable(session, rangeVariableArray, n, RangeVariable.emptyArray);
    }

    public String describe(Session session, int n) {
        RangeVariable.RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        String string = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "INNER";
        if (this.isLeftJoin) {
            string2 = "LEFT OUTER";
            if (this.isRightJoin) {
                string2 = "FULL";
            }
        } else if (this.isRightJoin) {
            string2 = "RIGHT OUTER";
        }
        stringBuffer.append(string).append("join type=").append(string2).append("\n");
        stringBuffer.append(string).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuffer.append(string).append("alias=").append(this.tableAlias.name).append("\n");
        }
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuffer.append(string).append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions rangeVariableConditions = this.joinConditions[i];
            if (i > 0) {
                stringBuffer.append(string).append("OR condition = [");
            } else {
                stringBuffer.append(string).append("condition = [");
            }
            stringBuffer.append(rangeVariableConditions.describe(session, n + 2));
            stringBuffer.append(string).append("]\n");
        }
        return stringBuffer.toString();
    }

    public RangeVariable.RangeIteratorMain getIterator(Session session) {
        return super.getIterator(session);
    }
}

