/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDiskData
extends RowAVL {
    PersistentStore store;
    int accessCount;
    boolean hasDataChanged;
    int storageSize;

    public RowAVLDiskData(PersistentStore persistentStore, TableBase tableBase, Object[] objectArray) {
        super(tableBase, objectArray);
        this.setNewNodes(persistentStore);
        this.hasDataChanged = true;
        this.store = persistentStore;
    }

    public RowAVLDiskData(PersistentStore persistentStore, TableBase tableBase, RowInputInterface rowInputInterface) throws IOException {
        super(tableBase, null);
        this.setNewNodes(persistentStore);
        this.position = rowInputInterface.getPos();
        this.storageSize = rowInputInterface.getSize();
        this.rowData = rowInputInterface.readData(this.table.getColumnTypes());
        this.hasDataChanged = false;
        this.store = persistentStore;
    }

    public static Object[] getRowData(TableBase tableBase, RowInputInterface rowInputInterface) throws IOException {
        return rowInputInterface.readData(tableBase.getColumnTypes());
    }

    public void setData(Object[] objectArray) {
        this.rowData = objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getData() {
        Object[] objectArray = this.rowData;
        if (objectArray == null) {
            this.store.writeLock();
            try {
                this.store.get(this, false);
                objectArray = this.rowData;
                if (objectArray == null) {
                    this.store.get(this, false);
                    objectArray = this.rowData;
                }
                Object var3_2 = null;
                this.store.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.store.writeUnlock();
                throw throwable;
            }
        } else {
            ++this.accessCount;
        }
        return objectArray;
    }

    public void setNewNodes(PersistentStore persistentStore) {
        int n = persistentStore.getAccessorKeys().length;
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVL(this);
        }
    }

    public NodeAVL insertNode(int n) {
        NodeAVL nodeAVL = this.getNode(n - 1);
        NodeAVL nodeAVL2 = new NodeAVL(this);
        nodeAVL2.nNext = nodeAVL.nNext;
        nodeAVL.nNext = nodeAVL2;
        return nodeAVL2;
    }

    void setPrimaryNode(NodeAVL nodeAVL) {
        this.nPrimaryNode = nodeAVL;
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return rowOutputInterface.getSize(this);
    }

    public void write(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeSize(this.storageSize);
        rowOutputInterface.writeData(this, this.table.colTypes);
        rowOutputInterface.writeEnd();
        this.hasDataChanged = false;
    }

    public synchronized void setChanged(boolean bl) {
        this.hasDataChanged = bl;
    }

    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    public void updateAccessCount(int n) {
        this.accessCount = n;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(int n) {
        this.storageSize = n;
    }

    public void setPos(int n) {
        this.position = n;
    }

    public boolean isMemory() {
        return true;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean isKeepInMemory() {
        return false;
    }

    public boolean keepInMemory(boolean bl) {
        return true;
    }

    public void setInMemory(boolean bl) {
        if (!bl) {
            this.rowData = null;
        }
    }
}

