/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;

public class JDBCBlobFile
implements Blob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private List m_streams = new ArrayList();

    public long length() throws SQLException {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n2 = Math.min(8192, n);
        try {
            inputStream = this.getBinaryStream(l, n);
            byteArrayOutputStream = new ByteArrayOutputStream(n2);
            InOutUtil.copy(inputStream, byteArrayOutputStream, (long)n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (byArray == null || byArray.length == 0 || l > this.length()) {
            return -1L;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getBinaryStream(l, Long.MAX_VALUE);
            long l2 = KMPSearchAlgorithm.search(inputStream, byArray, KMPSearchAlgorithm.computeTable(byArray));
            long l3 = l2 == -1L ? -1L : l + l2;
            return l3;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public long position(Blob blob, long l) throws SQLException {
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        long l2 = blob == null ? 0L : blob.length();
        if (l2 == 0L || l > this.length()) {
            return -1L;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("pattern.length(): " + l2);
        }
        byte[] byArray = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, (int)l2);
        return this.position(byArray, l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null) {
            throw Util.nullArgument("bytes");
        }
        OutputStream outputStream = this.setBinaryStream(l);
        try {
            outputStream.write(byArray, n, n2);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        OutputStreamAdapter outputStreamAdapter;
        if (l < 1L) {
            throw Util.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        try {
            outputStreamAdapter = new OutputStreamAdapter(this.m_file, l - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.m_streams.add(outputStreamAdapter);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStreamAdapter);
        return bufferedOutputStream;
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw Util.invalidArgument("len: " + l);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_streams);
        this.m_streams = null;
        for (Object e : arrayList) {
            if (e instanceof InputStream) {
                try {
                    ((InputStream)e).close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(e instanceof OutputStream)) continue;
            try {
                ((OutputStream)e).close();
            }
            catch (Exception exception) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        InputStreamAdapter inputStreamAdapter;
        if (l < 1L) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        this.checkClosed();
        try {
            inputStreamAdapter = new InputStreamAdapter(this.m_file, l - 1L, l2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl) {
        this.m_deleteOnFree = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    public JDBCBlobFile() throws SQLException {
        this(true);
    }

    public JDBCBlobFile(boolean bl) throws SQLException {
        this.m_deleteOnFree = bl;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
    }

    public JDBCBlobFile(File file) throws SQLException {
        this(file, false);
    }

    public JDBCBlobFile(File file, boolean bl) throws SQLException {
        this.m_deleteOnFree = bl;
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.checkIsFile(false);
    }

    protected final void checkIsFile(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        if (bl2) {
            try {
                bl3 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw Util.sqlException(exception);
            }
        }
        if (bl2) {
            if (!bl3) {
                throw Util.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl) {
            throw Util.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    private void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.checkIsFile(true);
    }

    static class InputStreamAdapter
    extends InputStream {
        private final CountdownInputStream m_countdownInputStream;

        InputStreamAdapter(File file, long l, long l2) throws FileNotFoundException, IOException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("length: " + l2);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (l > 0L) {
                long l3 = fileInputStream.skip(l);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            CountdownInputStream countdownInputStream = new CountdownInputStream(bufferedInputStream);
            countdownInputStream.setCount(l2);
            this.m_countdownInputStream = countdownInputStream;
        }

        public int available() throws IOException {
            return this.m_countdownInputStream.available();
        }

        public int read() throws IOException {
            return this.m_countdownInputStream.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.m_countdownInputStream.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.m_countdownInputStream.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            return this.m_countdownInputStream.skip(l);
        }

        public void close() throws IOException {
            this.m_countdownInputStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        public OutputStreamAdapter(File file, long l) throws FileNotFoundException, IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(l);
        }

        public void write(int n) throws IOException {
            this.m_randomAccessFile.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.m_randomAccessFile.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_randomAccessFile.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.m_randomAccessFile.getFD().sync();
        }

        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }
    }
}

