/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean haveLoadedOurDefault;
    private static ConsoleHandler consoleHandler;

    public static String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = loggerInstances.keySet().iterator();
        String string2 = string + '.';
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals(string) && !string3.startsWith(string2)) continue;
            hashSet.add(string3);
        }
        loggerInstances.keySet().removeAll(hashSet);
    }

    static void reconfigure() {
        Class<?> clazz = null;
        loggerInstances.clear();
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
        }
        catch (Exception exception) {
            clazz = null;
        }
        if (clazz == null) {
            try {
                log4jGetLogger = null;
                log4jLogMethod = null;
                LogManager logManager = LogManager.getLogManager();
                if (haveLoadedOurDefault || FrameworkLogger.isDefaultJdkConfig()) {
                    haveLoadedOurDefault = true;
                    consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                    consoleHandler.setLevel(Level.INFO);
                    logManager.readConfiguration(FrameworkLogger.class.getResourceAsStream("/org/hsqldb/resources/jdklogging-default.properties"));
                    Logger logger = Logger.getLogger("org.hsqldb.cmdline");
                    logger.addHandler(consoleHandler);
                    logger.setUseParentHandlers(false);
                }
                logManager.readConfiguration();
            }
            catch (Exception exception) {
                throw new RuntimeException("<clinit> failure initializing JDK logging system", exception);
            }
        } else {
            try {
                Method method = Class.forName("org.apache.log4j.Level").getMethod("toLevel", String.class);
                jdkToLog4jLevels.put(Level.ALL, method.invoke(null, "ALL"));
                jdkToLog4jLevels.put(Level.FINER, method.invoke(null, "DEBUG"));
                jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "ERROR"));
                jdkToLog4jLevels.put(Level.SEVERE, method.invoke(null, "FATAL"));
                jdkToLog4jLevels.put(Level.INFO, method.invoke(null, "INFO"));
                jdkToLog4jLevels.put(Level.OFF, method.invoke(null, "OFF"));
                jdkToLog4jLevels.put(Level.FINEST, method.invoke(null, "TRACE"));
                jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "WARN"));
                log4jLogMethod = clazz.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = clazz.getMethod("getLogger", String.class);
            }
            catch (Exception exception) {
                throw new RuntimeException("<clinit> failure instantiating present Log4j system", exception);
            }
        }
    }

    private FrameworkLogger(String string) {
        if (log4jGetLogger == null) {
            this.jdkLogger = Logger.getLogger(string);
        } else {
            try {
                this.log4jLogger = log4jGetLogger.invoke(null, string);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to instantiate Log4j Logger", exception);
            }
        }
        loggerInstances.put(string, this);
    }

    public static FrameworkLogger getLog(Class clazz) {
        return FrameworkLogger.getLog(clazz.getName());
    }

    public static FrameworkLogger getLog(Class clazz, String string) {
        return string == null ? FrameworkLogger.getLog(clazz) : FrameworkLogger.getLog(string + '.' + clazz.getName());
    }

    public static FrameworkLogger getLog(String string, String string2) {
        return string2 == null ? FrameworkLogger.getLog(string) : FrameworkLogger.getLog(string2 + '.' + string);
    }

    public static FrameworkLogger getLog(String string) {
        if (loggerInstances.containsKey(string)) {
            return (FrameworkLogger)loggerInstances.get(string);
        }
        return new FrameworkLogger(string);
    }

    public void log(Level level, String string, Throwable throwable) {
        this.privlog(level, string, throwable, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String string, Throwable throwable, int n, Class clazz) {
        if (this.log4jLogger == null) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string2 = stackTraceElementArray[n].getClassName();
            String string3 = stackTraceElementArray[n].getMethodName();
            if (throwable == null) {
                this.jdkLogger.logp(level, string2, string3, string);
            } else {
                this.jdkLogger.logp(level, string2, string3, string, throwable);
            }
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, clazz.getName(), jdkToLog4jLevels.get(level), string, throwable);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void enduserlog(Level level, String string) {
        if (this.log4jLogger == null) {
            String string2 = FrameworkLogger.class.getName();
            String string3 = "\\l";
            this.jdkLogger.logp(level, string2, string3, string);
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, FrameworkLogger.class.getName(), jdkToLog4jLevels.get(level), string, null);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void log(Level level, String string) {
        this.privlog(level, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string) {
        this.privlog(Level.FINER, string, null, 2, FrameworkLogger.class);
    }

    public void warning(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void severe(String string) {
        this.privlog(Level.SEVERE, string, null, 2, FrameworkLogger.class);
    }

    public void info(String string) {
        this.privlog(Level.INFO, string, null, 2, FrameworkLogger.class);
    }

    public void finest(String string) {
        this.privlog(Level.FINEST, string, null, 2, FrameworkLogger.class);
    }

    public void error(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string, Throwable throwable) {
        this.privlog(Level.FINER, string, throwable, 2, FrameworkLogger.class);
    }

    public void warning(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    public void severe(String string, Throwable throwable) {
        this.privlog(Level.SEVERE, string, throwable, 2, FrameworkLogger.class);
    }

    public void info(String string, Throwable throwable) {
        this.privlog(Level.INFO, string, throwable, 2, FrameworkLogger.class);
    }

    public void finest(String string, Throwable throwable) {
        this.privlog(Level.FINEST, string, throwable, 2, FrameworkLogger.class);
    }

    public void error(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDefaultJdkConfig() {
        block16: {
            block15: {
                block14: {
                    var0 = new File(System.getProperty("java.home"), "lib/logging.properties");
                    if (!var0.isFile()) {
                        return false;
                    }
                    var1_1 = null;
                    var2_2 = LogManager.getLogManager();
                    try {
                        try {
                            var1_1 = new FileInputStream(var0);
                            var3_3 = new Properties();
                            var3_3.load(var1_1);
                            var4_5 = var3_3.propertyNames();
                            var5_7 = 0;
                            while (var4_5.hasMoreElements()) {
                                ++var5_7;
                                var6_8 = (String)var4_5.nextElement();
                                var7_9 = var2_2.getProperty(var6_8);
                                if (var7_9 == null) {
                                    var8_10 = false;
                                    var10_13 = null;
                                    if (var1_1 == null) return var8_10;
                                    break block14;
                                }
                                if (var2_2.getProperty(var6_8).equals(var7_9)) continue;
                                var8_11 = false;
                                break block15;
                            }
                            var8_12 = true;
                            break block16;
                        }
                        catch (IOException var3_4) {
                            var4_6 = false;
                            var10_16 = null;
                            if (var1_1 == null) return var4_6;
                            try {
                                var1_1.close();
                                return var4_6;
                            }
                            catch (IOException var11_21) {
                                // empty catch block
                            }
                            return var4_6;
                        }
                    }
                    catch (Throwable var9_23) {
                        var10_17 = null;
                        if (var1_1 == null) throw var9_23;
                        try {}
                        catch (IOException var11_22) {
                            throw var9_23;
                        }
                        var1_1.close();
                        throw var9_23;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 164->171)] { 
lbl52:
                // 1 sources

                var1_1.close();
                return var8_10;
lbl54:
                // 1 sources

                catch (IOException var11_18) {
                    // empty catch block
                }
                return var8_10;
            }
            var10_14 = null;
            if (var1_1 == null) return var8_11;
            ** try [egrp 2[TRYBLOCK] [8 : 164->171)] { 
lbl61:
            // 1 sources

            var1_1.close();
            return var8_11;
lbl63:
            // 1 sources

            catch (IOException var11_19) {
                // empty catch block
            }
            return var8_11;
        }
        var10_15 = null;
        if (var1_1 == null) return var8_12;
        try {}
        catch (IOException var11_20) {
            // empty catch block
            return var8_12;
        }
        var1_1.close();
        return var8_12;
    }

    static {
        consoleHandler = new ConsoleHandler();
        String string = System.getProperty("hsqldb.reconfig_logging");
        if (string == null || !string.equalsIgnoreCase("false")) {
            FrameworkLogger.reconfigure();
        }
    }
}

