/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int MIN_INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding = 8;
    protected int initialFreePos = 32;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected RandomAccessInterface dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database database, String string) {
        this.initParams(database, string);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String string) {
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.cacheFileScale = database.logger.getCacheFileScale();
        this.cachedRowPadding = 8;
        if (this.cacheFileScale > 8) {
            this.cachedRowPadding = this.cacheFileScale;
        }
        if (this.initialFreePos < this.cacheFileScale) {
            this.initialFreePos = this.cacheFileScale;
        }
        this.cacheReadonly = database.logger.propFilesReadOnly;
        this.maxCacheRows = database.logger.propCacheMaxRows;
        this.maxCacheBytes = database.logger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.maxFreeBlocks = database.logger.propMaxFreeBlocks;
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        this.database.logger.logInfoEvent("open start");
        try {
            boolean bl2 = this.database.logger.propNioDataFile;
            int n = this.database.logger.isStoredFileAccess() ? 3 : (this.database.isFilesInJar() ? 2 : (bl2 ? 1 : 0));
            if (bl || this.database.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                this.dataFile.seek(28L);
                int n2 = this.dataFile.readInt();
                boolean bl3 = this.is180 = !BitMap.isSet(n2, 4);
                if (BitMap.isSet(n2, 5)) {
                    throw Error.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long l = 0L;
            boolean bl4 = this.fa.isStreamElement(this.dataFileName);
            if (bl4) {
                int n3 = this.database.logger.isStoredFileAccess() ? 3 : 0;
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n3);
                this.dataFile.seek(28L);
                int n4 = this.dataFile.readInt();
                boolean bl5 = BitMap.isSet(n4, 2);
                boolean bl6 = BitMap.isSet(n4, 1);
                this.is180 = !BitMap.isSet(n4, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.close();
                if (BitMap.isSet(n4, 5)) {
                    throw Error.error(453);
                }
                if (bl5) {
                    if (bl6) {
                        this.deleteBackup();
                    } else {
                        boolean bl7 = this.fa.isStreamElement(this.backupFileName);
                        if (!bl7) {
                            this.backupFile();
                        }
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                } else {
                    boolean bl8 = bl6 ? this.restoreBackupIncremental() : this.restoreBackup();
                    if (!bl8 && this.fileFreePosition > (long)this.initialFreePos) {
                        throw Error.error(454);
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                }
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition <= (long)this.initialFreePos) {
                    this.initNewFile();
                }
                this.openShadowFile();
            } else {
                boolean bl9 = false;
                boolean bl10 = this.database.logger.propIncrementBackup;
                if (bl10) {
                    this.deleteBackup();
                } else {
                    bl9 = this.restoreBackup();
                }
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
                if (!bl9) {
                    this.initNewFile();
                }
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, l);
            this.database.logger.logInfoEvent("open end");
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("open failed", throwable);
            this.close(false);
            throw Error.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void initNewFile() throws IOException {
        this.fileFreePosition = this.initialFreePos;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(this.initialFreePos);
        int n = 0;
        if (this.database.logger.propIncrementBackup) {
            n = BitMap.set(n, 1);
        }
        n = BitMap.set(n, 2);
        n = BitMap.set(n, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n);
        this.dataFile.synch();
        this.is180 = false;
    }

    void openShadowFile() {
        if (this.database.logger.propIncrementBackup && this.fileFreePosition != (long)this.initialFreePos) {
            this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean bl) {
        this.writeLock.lock();
        try {
            try {
                this.dataFile.seek(28L);
                int n = this.dataFile.readInt();
                n = bl ? BitMap.set(n, 1) : BitMap.unset(n, 1);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(n);
                this.dataFile.synch();
                this.fileModified = true;
            }
            catch (Throwable throwable) {
                this.database.logger.logSevereEvent("backupFile failed", throwable);
                Object var4_5 = null;
                this.writeLock.unlock();
            }
            Object var4_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    private boolean restoreBackup() {
        this.deleteOrResetFreePos();
        try {
            FileAccess fileAccess = this.database.logger.getFileAccess();
            if (fileAccess.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fileAccess, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 26, new Object[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.database, this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean bl) {
        block14: {
            block13: {
                this.writeLock.lock();
                try {
                    block12: {
                        try {
                            boolean bl2;
                            if (this.dataFile == null) {
                                Object var4_2 = null;
                                break block12;
                            }
                            if (bl) {
                                this.commitChanges();
                            } else if (this.shadowFile != null) {
                                this.shadowFile.close();
                                this.shadowFile = null;
                            }
                            this.dataFile.close();
                            this.database.logger.logDetailEvent("dataFileCache file close");
                            this.dataFile = null;
                            if (!bl) {
                                break block13;
                            }
                            boolean bl3 = bl2 = this.fileFreePosition == (long)this.initialFreePos;
                            if (bl2) {
                                this.deleteFile();
                                this.deleteBackup();
                            }
                            break block14;
                        }
                        catch (HsqlException hsqlException) {
                            throw hsqlException;
                        }
                        catch (Throwable throwable) {
                            this.database.logger.logSevereEvent("dataFileCache close failed", throwable);
                            throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
                        }
                    }
                    this.writeLock.unlock();
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var4_3 = null;
            this.writeLock.unlock();
            return;
        }
        Object var4_4 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
            this.fileFreePosition = this.initialFreePos;
            this.freeBlocks.clear();
            this.initBuffers();
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int n) {
        this.writeLock.lock();
        try {
            this.storeCount += n;
            if (this.storeCount == 0) {
                if (this.shadowFile == null) {
                    this.clear();
                } else {
                    this.cache.clear();
                }
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void commitChanges() {
        block6: {
            this.writeLock.lock();
            try {
                try {
                    if (this.cacheReadonly) {
                        Object var3_1 = null;
                        this.writeLock.unlock();
                        return;
                    }
                    this.database.logger.logInfoEvent("dataFileCache commit start");
                    this.cache.saveAll();
                    this.database.logger.logDetailEvent("dataFileCache save data");
                    if (this.fileModified || this.freeBlocks.isModified()) {
                        this.dataFile.seek(4L);
                        this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                        this.dataFile.seek(12L);
                        this.dataFile.writeLong(this.fileFreePosition);
                        this.dataFile.seek(28L);
                        int n = this.dataFile.readInt();
                        n = BitMap.set(n, 2);
                        this.dataFile.seek(28L);
                        this.dataFile.writeInt(n);
                        this.database.logger.logDetailEvent("DataFileCache flags");
                    }
                    this.dataFile.synch();
                    this.fileModified = false;
                    if (this.shadowFile == null) break block6;
                    this.shadowFile.close();
                    this.shadowFile = null;
                }
                catch (Throwable throwable) {
                    this.database.logger.logSevereEvent("dataFileCache commit failed", throwable);
                    throw Error.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    protected void initBuffers() {
        if (this.rowOut == null || this.rowOut.getOutputStream().getBuffer().length > 256) {
            this.rowOut = this.is180 ? new RowOutputBinary180(256, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 256, this.cachedRowPadding);
        }
        if (this.rowIn == null || this.rowIn.getBuffer().length > 256) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[256]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[256]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this, this.dataFileName);
            dataFileDefrag.process();
            this.close(true);
            this.cache.clear();
            if (!this.database.logger.propIncrementBackup) {
                this.backupFile();
            }
            this.database.schemaManager.setTempIndexRoots(dataFileDefrag.getIndexRoots());
            this.database.logger.log.writeScript(false);
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameBackupFile();
            this.renameDataFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            dataFileDefrag.updateTransactionRowIDs();
            this.database.schemaManager.setIndexRoots(dataFileDefrag.getIndexRoots());
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            this.database.getProperties().setDBModified(1);
            DataFileDefrag dataFileDefrag2 = dataFileDefrag;
            Object var4_3 = null;
            this.writeLock.unlock();
            return dataFileDefrag2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.release(n);
            if (cachedObject != null) {
                int n2 = cachedObject.getStorageSize();
                this.freeBlocks.add(n, n2);
            }
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void removePersistence(int n, PersistentStore persistentStore) {
    }

    int setFilePos(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        int n2 = this.freeBlocks.get(n);
        if (n2 == -1) {
            n2 = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long l = this.fileFreePosition + (long)n;
            if (l > this.maxDataFileSize) {
                this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
                throw Error.error(468);
            }
            boolean bl = this.dataFile.ensureLength(l);
            if (!bl) {
                this.database.logger.logSevereEvent("data file cannot be enlarged - disk spacee " + this.dataFileName, null);
                throw Error.error(468);
            }
            this.fileFreePosition = l;
        }
        cachedObject.setPos(n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            int n = this.setFilePos(cachedObject);
            this.cache.put(n, cachedObject);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(int n) {
        block3: {
            this.readLock.lock();
            try {
                CachedObject cachedObject = this.cache.get(n);
                if (cachedObject == null) break block3;
                int n2 = cachedObject.getStorageSize();
                Object var5_4 = null;
                this.readLock.unlock();
                return n2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.readLock.unlock();
        return this.readSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            int n = cachedObject.getPos();
            this.cache.replace(n, cachedObject);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        int n;
        block9: {
            block8: {
                block7: {
                    this.readLock.lock();
                    try {
                        if (!cachedObject.isInMemory()) break block7;
                        if (bl) {
                            cachedObject.keepInMemory(true);
                        }
                        CachedObject cachedObject2 = cachedObject;
                        Object var7_7 = null;
                        this.readLock.unlock();
                        return cachedObject2;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        this.readLock.unlock();
                        throw throwable;
                    }
                }
                n = cachedObject.getPos();
                if (n >= 0) break block8;
                CachedObject cachedObject3 = null;
                Object var7_8 = null;
                this.readLock.unlock();
                return cachedObject3;
            }
            cachedObject = this.cache.get(n);
            if (cachedObject == null) break block9;
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            CachedObject cachedObject4 = cachedObject;
            Object var7_9 = null;
            this.readLock.unlock();
            return cachedObject4;
        }
        Object var7_10 = null;
        this.readLock.unlock();
        return this.getFromFile(n, persistentStore, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int n, PersistentStore persistentStore, boolean bl) {
        block5: {
            if (n < 0) {
                return null;
            }
            this.readLock.lock();
            try {
                CachedObject cachedObject = this.cache.get(n);
                if (cachedObject == null) break block5;
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                CachedObject cachedObject2 = cachedObject;
                Object var7_6 = null;
                this.readLock.unlock();
                return cachedObject2;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Object var7_7 = null;
        this.readLock.unlock();
        return this.getFromFile(n, persistentStore, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedObject getFromFile(int n, PersistentStore persistentStore, boolean bl) {
        CachedObject cachedObject = null;
        this.writeLock.lock();
        try {
            CachedObject cachedObject2;
            try {
                cachedObject = this.cache.get(n);
                if (cachedObject != null) {
                    if (bl) {
                        cachedObject.keepInMemory(true);
                    }
                    CachedObject cachedObject3 = cachedObject;
                    Object var9_9 = null;
                    this.writeLock.unlock();
                    return cachedObject3;
                }
                for (int i = 0; i < 2; ++i) {
                    RowInputInterface rowInputInterface;
                    block11: {
                        CachedObject cachedObject4;
                        try {
                            rowInputInterface = this.readObject(n);
                            if (rowInputInterface != null) break block11;
                            cachedObject4 = null;
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.cache.forceCleanUp();
                            System.gc();
                            if (i <= 0) continue;
                            throw outOfMemoryError;
                        }
                        Object var9_10 = null;
                        this.writeLock.unlock();
                        return cachedObject4;
                    }
                    cachedObject = persistentStore.get(rowInputInterface);
                    break;
                }
                n = cachedObject.getPos();
                this.cache.put(n, cachedObject);
                if (bl) {
                    cachedObject.keepInMemory(true);
                }
                persistentStore.set(cachedObject);
                cachedObject2 = cachedObject;
                Object var9_11 = null;
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logSevereEvent(this.dataFileName + " getFromFile " + n, hsqlException);
                throw hsqlException;
            }
            this.writeLock.unlock();
            return cachedObject2;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(int n) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(n);
            Object var4_3 = null;
            this.writeLock.unlock();
            return rowInputInterface;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected int readSize(int n) {
        this.writeLock.lock();
        try {
            this.dataFile.seek((long)n * (long)this.cacheFileScale);
            int n2 = this.dataFile.readInt();
            Object var4_4 = null;
            this.writeLock.unlock();
            return n2;
        }
        catch (IOException iOException) {
            try {
                throw Error.error(466, iOException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
    }

    protected RowInputInterface readObject(int n) {
        try {
            this.dataFile.seek((long)n * (long)this.cacheFileScale);
            int n2 = this.dataFile.readInt();
            this.rowIn.resetRow(n, n2);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
            return this.rowIn;
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(int n) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(n);
            Object var4_3 = null;
            this.writeLock.unlock();
            return cachedObject;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        try {
            try {
                this.copyShadow(cachedObjectArray, n, n2);
                this.setFileModified();
                for (int i = n; i < n + n2; ++i) {
                    CachedObject cachedObject = cachedObjectArray[i];
                    this.saveRowNoLock(cachedObject);
                    cachedObjectArray[i] = null;
                }
                Object var7_8 = null;
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logSevereEvent("saveRows failed", hsqlException);
                throw hsqlException;
            }
            catch (Throwable throwable) {
                this.database.logger.logSevereEvent("saveRows failed", throwable);
                throw Error.error(466, throwable);
            }
            this.initBuffers();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.initBuffers();
            throw throwable;
        }
    }

    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            try {
                this.copyShadow(cachedObject);
                this.setFileModified();
                this.saveRowNoLock(cachedObject);
            }
            catch (Throwable throwable) {
                this.database.logger.logSevereEvent("saveRow failed", throwable);
                throw Error.error(466, throwable);
            }
            Object var4_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    protected void saveRowNoLock(CachedObject cachedObject) {
        try {
            this.rowOut.reset();
            cachedObject.write(this.rowOut);
            this.dataFile.seek((long)cachedObject.getPos() * (long)this.cacheFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    protected void copyShadow(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        if (this.shadowFile != null) {
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                long l = (long)cachedObject.getPos() * (long)this.cacheFileScale;
                this.shadowFile.copy(l, cachedObject.getStorageSize());
            }
            this.shadowFile.synch();
        }
    }

    protected void copyShadow(CachedObject cachedObject) throws IOException {
        if (this.shadowFile != null) {
            long l = (long)cachedObject.getPos() * (long)this.cacheFileScale;
            this.shadowFile.copy(l, cachedObject.getStorageSize());
            this.shadowFile.synch();
        }
    }

    void backupFile() {
        block6: {
            this.writeLock.lock();
            try {
                try {
                    if (this.database.logger.propIncrementBackup) {
                        if (this.fa.isStreamElement(this.backupFileName)) {
                            this.deleteBackup();
                        }
                        Object var3_1 = null;
                        this.writeLock.unlock();
                        return;
                    }
                    if (!this.fa.isStreamElement(this.dataFileName)) break block6;
                    FileArchiver.archive(this.dataFileName, this.backupFileName + ".new", this.database.logger.getFileAccess(), 1);
                }
                catch (IOException iOException) {
                    this.database.logger.logSevereEvent("backupFile failed", iOException);
                    throw Error.error(466, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                this.deleteBackup();
                Object var2_1 = null;
                this.writeLock.unlock();
                return;
            }
            if (this.fa.isStreamElement(this.backupFileName + ".new")) {
                this.deleteBackup();
                this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fa.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFile() {
        this.writeLock.lock();
        try {
            this.fa.removeElement(this.dataFileName);
            if (this.database.logger.isStoredFileAccess()) {
                Object var3_1 = null;
                this.writeLock.unlock();
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                this.database.logger.log.deleteOldDataFiles();
                this.fa.removeElement(this.dataFileName);
                if (this.fa.isStreamElement(this.dataFileName)) {
                    String string = this.newDiscardFileName();
                    this.fa.renameElement(this.dataFileName, string);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.writeLock.unlock();
    }

    String newDiscardFileName() {
        String string = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), 8, '0', true);
        String string2 = this.dataFileName + "." + string + ".old";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackup() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                this.fa.removeElement(this.backupFileName);
            }
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deleteOrResetFreePos() {
        this.deleteFile();
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        if (!this.database.logger.getFileAccess().isStreamElement(this.dataFileName)) {
            return;
        }
        this.dataFile = new ScaledRAFileSimple(this.dataFileName, "rws");
        this.initNewFile();
        Object var3_1 = null;
        if (this.dataFile == null) return;
        try {
            this.dataFile.close();
            this.dataFile = null;
            return;
        }
        catch (IOException iOException) {
            this.database.logger.logWarningEvent("error closing RA file", iOException);
        }
        return;
        {
            catch (IOException iOException) {
                this.database.logger.logSevereEvent("deleteOrResetFreePos failed", iOException);
                Object var3_2 = null;
                if (this.dataFile == null) return;
                try {
                    this.dataFile.close();
                    this.dataFile = null;
                    return;
                }
                catch (IOException iOException2) {
                    this.database.logger.logWarningEvent("error closing RA file", iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.dataFile == null) throw throwable;
            try {
                this.dataFile.close();
                this.dataFile = null;
                throw throwable;
            }
            catch (IOException iOException) {
                this.database.logger.logWarningEvent("error closing RA file", iOException);
            }
            throw throwable;
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        this.writeLock.lock();
        try {
            block4: {
                try {
                    if (this.fileModified) break block4;
                    long l = this.cache.saveAllTimer.elapsedTime();
                    this.cache.saveAllTimer.start();
                    this.dataFile.seek(28L);
                    int n = this.dataFile.readInt();
                    n = BitMap.unset(n, 2);
                    this.dataFile.seek(28L);
                    this.dataFile.writeInt(n);
                    this.dataFile.synch();
                    this.cache.saveAllTimer.stop();
                    this.database.logger.logDetailEvent("flags set " + this.cache.saveAllTimer.elapsedTime());
                    this.fileModified = true;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.writeLock.unlock();
                }
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public int getFlags() {
        try {
            this.dataFile.seek(28L);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }
}

