/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected boolean allQuoted;
    private String encoding;

    public RowOutputText(String string, String string2, String string3, boolean bl, String string4) {
        this.initTextDatabaseRowOutput(string, string2, string3, bl, string4);
    }

    private void initTextDatabaseRowOutput(String string, String string2, String string3, boolean bl, String string4) {
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
        this.allQuoted = bl;
        this.encoding = string4;
    }

    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextCache.NL);
    }

    public void writeSize(int n) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    public void writeType(int n) {
    }

    public void writeString(String string) {
        if ((string = this.checkConvertString(string, this.fieldSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String string) {
        if ((string = this.checkConvertString(string, this.varSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String string) {
        if ((string = this.checkConvertString(string, this.longvarSep)) == null) {
            return;
        }
        byte[] byArray = this.getBytes(string);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String string, String string2) {
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1) {
            throw new IllegalArgumentException(Error.getMessage(485));
        }
        if (string.indexOf(string2) != -1) {
            return null;
        }
        return string;
    }

    private byte[] getBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    protected void writeByteArray(byte[] byArray) {
        this.ensureRoom(byArray.length * 2);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, byArray);
        this.count += byArray.length * 2;
    }

    public void writeShort(int n) {
        this.writeInt(n);
    }

    public void writeInt(int n) {
        this.writeBytes(Integer.toString(n));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeIntData(int n, int n2) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    public void writeLong(long l) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    protected void writeFieldType(Type type) {
        this.writeBytes(this.nextSep);
        switch (type.typeCode) {
            case 12: 
            case 100: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    protected void writeNull(Type type) {
        this.writeFieldType(type);
    }

    protected void writeChar(String string, Type type) {
        switch (type.typeCode) {
            case 1: {
                this.writeString(string);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(string);
                return;
            }
        }
        this.writeLongVarString(string);
    }

    protected void writeSmallint(Number number) {
        this.writeString(number.toString());
    }

    protected void writeInteger(Number number) {
        this.writeString(number.toString());
    }

    protected void writeBigint(Number number) {
        this.writeString(number.toString());
    }

    protected void writeReal(Double d) {
        this.writeString(d.toString());
    }

    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        this.writeString(type.convertToString(bigDecimal));
    }

    protected void writeBoolean(Boolean bl) {
        this.writeString(bl.toString());
    }

    protected void writeDate(TimestampData timestampData, Type type) {
        this.writeString(type.convertToString(timestampData));
    }

    protected void writeTime(TimeData timeData, Type type) {
        this.writeString(type.convertToString(timeData));
    }

    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.writeString(type.convertToString(timestampData));
    }

    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.writeBytes(type.convertToString(intervalMonthData));
    }

    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.writeBytes(type.convertToString(intervalSecondData));
    }

    protected void writeOther(JavaObjectData javaObjectData) {
        byte[] byArray = javaObjectData.getBytes();
        this.writeByteArray(byArray);
    }

    protected void writeBit(BinaryData binaryData) {
        String string = StringConverter.byteArrayToBitString(binaryData.getBytes(), (int)binaryData.bitLength(null));
        this.writeString(string);
    }

    protected void writeBinary(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    protected void writeClob(ClobData clobData, Type type) {
        this.writeString(Long.toString(clobData.getId()));
    }

    protected void writeBlob(BlobData blobData, Type type) {
        this.writeString(Long.toString(blobData.getId()));
    }

    protected void writeArray(Object[] objectArray, Type type) {
        throw Error.runtimeError(201, "RowOutputText");
    }

    public int getSize(Row row) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(row, row.getTable().getColumnTypes());
            this.writeEnd();
        }
        catch (Exception exception) {
            this.reset();
        }
        int n = this.size();
        this.reset();
        return n;
    }

    public int getStorageSize(int n) {
        return n;
    }

    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }
}

