/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobInputStream;

public class ClobDataID
implements ClobData {
    long id;
    long length = -1L;

    public ClobDataID(long l) {
        this.id = l;
    }

    public char[] getChars(SessionInterface sessionInterface, long l, int n) {
        ResultLob resultLob = ResultLob.newLobGetCharsRequest(this.id, l, n);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getCharArray();
    }

    public long length(SessionInterface sessionInterface) {
        if (this.length > -1L) {
            return this.length;
        }
        ResultLob resultLob = ResultLob.newLobGetLengthRequest(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        this.length = ((ResultLob)result).getBlockLength();
        return this.length;
    }

    public String getSubString(SessionInterface sessionInterface, long l, int n) {
        char[] cArray = this.getChars(sessionInterface, l, n);
        return new String(cArray);
    }

    public ClobData getClob(SessionInterface sessionInterface, long l, long l2) {
        ResultLob resultLob = ResultLob.newLobGetRequest(this.id, l, l2);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return new ClobDataID(((ResultLob)result).getLobID());
    }

    public void truncate(SessionInterface sessionInterface, long l) {
        ResultLob resultLob = ResultLob.newLobTruncateRequest(this.id, l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
    }

    public Reader getCharacterStream(SessionInterface sessionInterface) {
        long l = this.length(sessionInterface);
        return new ClobInputStream(sessionInterface, this, 0L, l);
    }

    public long setCharacterStream(SessionInterface sessionInterface, long l, Reader reader) {
        return 0L;
    }

    public int setString(SessionInterface sessionInterface, long l, String string) {
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, string.toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return string.length();
    }

    public int setString(SessionInterface sessionInterface, long l, String string, int n, int n2) {
        if (!ClobDataID.isInLimits(string.length(), n, n2)) {
            throw Error.error(3401);
        }
        ResultLob resultLob = ResultLob.newLobSetCharsRequest(this.id, l, string.substring(n, n2).toCharArray());
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return string.length();
    }

    public int setChars(SessionInterface sessionInterface, long l, char[] object, int n, int n2) {
        Result result;
        Object object2;
        if (n != 0 || n2 != ((char[])object).length) {
            if (!ClobDataID.isInLimits(((char[])object).length, n, n2)) {
                throw Error.error(3401);
            }
            object2 = new char[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
        }
        if ((result = sessionInterface.execute((Result)(object2 = ResultLob.newLobSetCharsRequest(this.id, l, object)))).isError()) {
            throw result.getException();
        }
        return n2;
    }

    public long position(SessionInterface sessionInterface, String string, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, string.toCharArray(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    public long position(SessionInterface sessionInterface, ClobData clobData, long l) {
        ResultLob resultLob = ResultLob.newLobGetCharPatternPositionRequest(this.id, clobData.getId(), l);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getOffset();
    }

    public long nonSpaceLength(SessionInterface sessionInterface) {
        ResultLob resultLob = ResultLob.newLobGetTruncateLength(this.id);
        Result result = sessionInterface.execute(resultLob);
        if (result.isError()) {
            throw result.getException();
        }
        return ((ResultLob)result).getBlockLength();
    }

    public Reader getCharacterStream(SessionInterface sessionInterface, long l, long l2) {
        return new ClobInputStream(sessionInterface, this, l, l2);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }

    public void setSession(SessionInterface sessionInterface) {
    }

    public boolean isBinary() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof BlobDataID) {
            return this.id == ((BlobDataID)object).id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

