/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.libclone;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RefCapablePropertyResourceBundle {
    private PropertyResourceBundle wrappedBundle;
    private String baseName;
    private String language;
    private String country;
    private String variant;
    private static Map<ResourceBundle, RefCapablePropertyResourceBundle> allBundles = new HashMap<ResourceBundle, RefCapablePropertyResourceBundle>();
    public static final String LS = System.getProperty("line.separator");
    private Pattern sysPropVarPattern = Pattern.compile("(?s)\\Q${\\E([^}]+?)(?:\\Q:+\\E([^}]+))?\\Q}");
    private Pattern posPattern = Pattern.compile("(?s)\\Q%{\\E(\\d)(?:\\Q:+\\E([^}]+))?\\Q}");
    private Class<? extends Enum<?>> loaderClass;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;

    public Enumeration<String> getKeys() {
        return this.wrappedBundle.getKeys();
    }

    private RefCapablePropertyResourceBundle(String string, PropertyResourceBundle propertyResourceBundle, Class<? extends Enum<?>> clazz) {
        this.baseName = string;
        this.wrappedBundle = propertyResourceBundle;
        Locale locale = propertyResourceBundle.getLocale();
        this.loaderClass = clazz;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
        if (this.language.length() < 1) {
            this.language = null;
        }
        if (this.country.length() < 1) {
            this.country = null;
        }
        if (this.variant.length() < 1) {
            this.variant = null;
        }
    }

    public String getExpandedString(String string, int n) {
        String string2 = this.getString(string);
        Matcher matcher = this.sysPropVarPattern.matcher(string2);
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string5 = System.getProperty(string3);
            if (string4 != null) {
                String string6 = string5 = string5 == null ? "" : string4.replaceAll("\\Q$" + string3 + "\\E\\b", Matcher.quoteReplacement(string5));
            }
            if (string5 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("No Sys Property set for variable '" + string3 + "' in property value (" + string2 + ").");
                    }
                    case 1: {
                        string5 = "";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuilder.append(string2.substring(n2, matcher.start()) + (string5 == null ? matcher.group() : string5));
            n2 = matcher.end();
        }
        return n2 < 1 ? string2 : stringBuilder.toString() + string2.substring(n2);
    }

    public String posSubst(String string, String[] stringArray, int n) {
        Matcher matcher = this.posPattern.matcher(string);
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string2;
            int n3 = Integer.parseInt(matcher.group(1)) - 1;
            String string3 = matcher.groupCount() > 1 ? matcher.group(2) : null;
            String string4 = string2 = n3 < stringArray.length ? stringArray[n3] : null;
            if (string3 != null) {
                String string5 = string2 = string2 == null ? "" : string3.replaceAll("\\Q%" + (n3 + 1) + "\\E\\b", Matcher.quoteReplacement(string2));
            }
            if (string2 == null) {
                switch (n) {
                    case 0: {
                        throw new RuntimeException(Integer.toString(stringArray.length) + " positional values given, but property string contains (" + matcher.group() + ").");
                    }
                    case 1: {
                        string2 = "";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined value for behavior: " + n);
                    }
                }
            }
            stringBuilder.append(string.substring(n2, matcher.start()) + (string2 == null ? matcher.group() : string2));
            n2 = matcher.end();
        }
        return n2 < 1 ? string : stringBuilder.toString() + string.substring(n2);
    }

    public String getExpandedString(String string, String[] stringArray, int n, int n2) {
        return this.posSubst(this.getExpandedString(string, n), stringArray, n2);
    }

    public String getString(String string, String[] stringArray, int n) {
        return this.posSubst(this.getString(string), stringArray, n);
    }

    public String toString() {
        return this.baseName + " for " + this.language + " / " + this.country + " / " + this.variant;
    }

    public String getString(String string) {
        String string2 = this.wrappedBundle.getString(string);
        if (string2.length() < 1) {
            string2 = this.getStringFromFile(string);
            if (string2.indexOf(13) > -1) {
                string2 = string2.replaceAll("\\Q\r\n", "\n").replaceAll("\\Q\r", "\n");
            }
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\n') {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return RefCapablePropertyResourceBundle.toNativeLs(string2);
    }

    public static String toNativeLs(String string) {
        return LS.equals("\n") ? string : string.replaceAll("\\Q\n", LS);
    }

    public static RefCapablePropertyResourceBundle getBundle(String string, ClassLoader classLoader, Class<? extends Enum<?>> clazz) {
        return RefCapablePropertyResourceBundle.getRef(string, ResourceBundle.getBundle(string, Locale.getDefault(), classLoader), clazz);
    }

    public static RefCapablePropertyResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, Class<? extends Enum<?>> clazz) {
        return RefCapablePropertyResourceBundle.getRef(string, ResourceBundle.getBundle(string, locale, classLoader), clazz);
    }

    private static RefCapablePropertyResourceBundle getRef(String string, ResourceBundle resourceBundle, Class<? extends Enum<?>> clazz) {
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            throw new MissingResourceException("Found a Resource Bundle, but it is a " + resourceBundle.getClass().getName(), PropertyResourceBundle.class.getName(), null);
        }
        if (allBundles.containsKey(resourceBundle)) {
            return allBundles.get(resourceBundle);
        }
        RefCapablePropertyResourceBundle refCapablePropertyResourceBundle = new RefCapablePropertyResourceBundle(string, (PropertyResourceBundle)resourceBundle, clazz);
        allBundles.put(resourceBundle, refCapablePropertyResourceBundle);
        return refCapablePropertyResourceBundle;
    }

    private InputStream getMostSpecificStream(String string, String string2, String string3, String string4) {
        final String string5 = (this.baseName.matches("^[^./].*[./].+") ? "/" : "") + this.baseName.replace('.', '/') + "/" + string + (String)(string2 == null ? "" : "_" + string2) + (String)(string3 == null ? "" : "_" + string3) + (String)(string4 == null ? "" : "_" + string4) + ".text";
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return RefCapablePropertyResourceBundle.this.loaderClass.getResourceAsStream(string5);
            }
        });
        return inputStream == null && string2 != null ? this.getMostSpecificStream(string, string3 == null ? null : string2, string4 == null ? null : string3, null) : inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromFile(String string) {
        int n;
        byte[] byArray = null;
        InputStream inputStream = this.getMostSpecificStream(string, this.language, this.country, this.variant);
        if (inputStream == null) {
            throw new MissingResourceException("Key '" + string + "' is present in .properties file with no value, yet text file resource is missing", RefCapablePropertyResourceBundle.class.getName(), string);
        }
        try {
            try {
                byArray = new byte[inputStream.available()];
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for key '" + string + "': " + iOException, RefCapablePropertyResourceBundle.class.getName(), string);
            }
            catch (Throwable throwable) {
                throw new MissingResourceException("Resource is too big to read in '" + string + "' value in one gulp.\nPlease run the program with more RAM (try Java -Xm* switches).: " + throwable, RefCapablePropertyResourceBundle.class.getName(), string);
            }
            try {
                int n2;
                for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
                }
            }
            catch (IOException iOException) {
                throw new MissingResourceException("Failed to read in value for '" + string + "': " + iOException, RefCapablePropertyResourceBundle.class.getName(), string);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed to close input stream: " + iOException);
            }
        }
        if (n != byArray.length) {
            throw new MissingResourceException("Didn't read all bytes.  Read in " + n + " bytes out of " + byArray.length + " bytes for key '" + string + "'", RefCapablePropertyResourceBundle.class.getName(), string);
        }
        try {
            return new String(byArray, Charset.forName("ISO-8859-1"));
        }
        catch (Throwable throwable) {
            throw new MissingResourceException("Value for key '" + string + "' too big to convert to String.  Please run the program with more RAM (try Java -Xm* switches).: " + throwable, RefCapablePropertyResourceBundle.class.getName(), string);
        }
    }
}

