/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class MysqlBatchUpsertOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    private MysqlUpsertBatchInsertSqlBuilder builder;
    private RDBColumnMetadata idColumn;
    private SaveOrUpdateOperator fallback;

    public MysqlBatchUpsertOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new MysqlUpsertBatchInsertSqlBuilder(table);
        this.idColumn = table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        this.fallback = new DefaultSaveOrUpdateOperator(table);
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.idColumn == null) {
            this.idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
            if (this.idColumn == null) {
                return this.fallback.execute(parameter);
            }
        }
        return new MysqlSaveResultOperator(() -> this.builder.build(new MysqlUpsertOperatorParameter(parameter)), parameter.getValues().size());
    }

    private class MysqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public MysqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected PrepareSqlFragments beforeBuild(InsertOperatorParameter parameter, PrepareSqlFragments fragments) {
            if (((MysqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                return fragments.addSql("insert ignore into").addSql(this.table.getFullName());
            }
            return super.beforeBuild(parameter, fragments);
        }

        @Override
        protected PrepareSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, PrepareSqlFragments sql) {
            if (((MysqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                return sql;
            }
            sql.addSql("on duplicate key update");
            List<Object> values = parameter.getValues().get(0);
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                Object value = index >= values.size() ? null : values.get(index);
                ++index;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore()) continue;
                RDBColumnMetadata columnMetadata = this.table.getColumn(column.getColumn()).orElse(null);
                if (value == null || columnMetadata == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable()) continue;
                if (more) {
                    sql.addSql(",");
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).addSql("=");
                if (value instanceof NativeSql) {
                    sql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                sql.addSql("VALUES(", columnMetadata.getQuoteName(), ")");
            }
            return sql;
        }
    }

    private class MysqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<SqlRequest> sqlRequest;
        int total;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)MysqlBatchUpsertOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                sqlExecutor.update(this.sqlRequest.get());
                return SaveResult.of(0, this.total);
            }, MysqlBatchUpsertOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return Mono.defer(() -> (Mono)((Mono)Mono.just((Object)this.sqlRequest.get()).as(((ReactiveSqlExecutor)MysqlBatchUpsertOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID))::update)).map(i -> SaveResult.of(0, this.total)).as(ExceptionUtils.translation(MysqlBatchUpsertOperator.this.table)));
        }

        @ConstructorProperties(value={"sqlRequest", "total"})
        public MysqlSaveResultOperator(Supplier<SqlRequest> sqlRequest, int total) {
            this.sqlRequest = sqlRequest;
            this.total = total;
        }
    }

    class MysqlUpsertOperatorParameter
    extends InsertOperatorParameter {
        private boolean doNoThingOnConflict;

        public MysqlUpsertOperatorParameter(UpsertOperatorParameter parameter) {
            this.doNoThingOnConflict = parameter.isDoNothingOnConflict();
            this.setColumns(parameter.toInsertColumns());
            this.setValues(parameter.getValues());
        }
    }
}

