/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.postgres;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SimpleTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveOrUpdateOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.SaveResultOperator;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.UpsertOperatorParameter;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class PostgresqlBatchUpsertOperator
implements SaveOrUpdateOperator {
    private RDBTableMetadata table;
    private PostgresqlUpsertBatchInsertSqlBuilder builder;
    private RDBColumnMetadata idColumn;
    private SaveOrUpdateOperator fallback;

    public PostgresqlBatchUpsertOperator(RDBTableMetadata table) {
        this.table = table;
        this.builder = new PostgresqlUpsertBatchInsertSqlBuilder(table);
        this.idColumn = table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        this.fallback = new DefaultSaveOrUpdateOperator(table);
    }

    @Override
    public SaveResultOperator execute(UpsertOperatorParameter parameter) {
        if (this.idColumn == null) {
            this.idColumn = this.table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
            if (this.idColumn == null) {
                return this.fallback.execute(parameter);
            }
        }
        return new PostgresqlSaveResultOperator(() -> this.builder.build(new PostgresqlUpsertOperatorParameter(parameter)));
    }

    private class PostgresqlUpsertBatchInsertSqlBuilder
    extends BatchInsertSqlBuilder {
        public PostgresqlUpsertBatchInsertSqlBuilder(RDBTableMetadata table) {
            super(table);
        }

        @Override
        protected PrepareSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, PrepareSqlFragments sql) {
            sql.addSql("on conflict (", PostgresqlBatchUpsertOperator.this.idColumn.getName(), ") do ");
            if (((PostgresqlUpsertOperatorParameter)parameter).doNoThingOnConflict) {
                sql.addSql("nothing");
                return sql;
            }
            List<Object> values = parameter.getValues().get(0);
            int index = 0;
            boolean more = false;
            for (InsertColumn column : columns) {
                Object value = index >= values.size() ? null : values.get(index);
                ++index;
                if (column instanceof UpsertColumn && ((UpsertColumn)column).isUpdateIgnore()) continue;
                RDBColumnMetadata columnMetadata = this.table.getColumn(column.getColumn()).orElse(null);
                if (value == null || columnMetadata == null || columnMetadata.isPrimaryKey() || !columnMetadata.isUpdatable()) continue;
                if (more) {
                    sql.addSql(",");
                } else {
                    sql.addSql("update set");
                }
                more = true;
                sql.addSql(columnMetadata.getQuoteName()).addSql("=");
                if (value instanceof NativeSql) {
                    sql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                sql.addSql(columnMetadata.getFullName("excluded"));
            }
            if (!more) {
                sql.addSql("nothing");
            } else {
                SqlFragments fragments;
                List where = ((PostgresqlUpsertOperatorParameter)parameter).where;
                if (CollectionUtils.isNotEmpty((Collection)where) && (fragments = SimpleTermsFragmentBuilder.instance().createTermFragments((TableOrViewMetadata)this.table, (List<Term>)where)).isNotEmpty()) {
                    sql.addSql("where").addFragments(fragments);
                }
            }
            return sql;
        }
    }

    private class PostgresqlSaveResultOperator
    implements SaveResultOperator {
        Supplier<SqlRequest> sqlRequest;

        @Override
        public SaveResult sync() {
            return ExceptionUtils.translation(() -> {
                SyncSqlExecutor sqlExecutor = (SyncSqlExecutor)PostgresqlBatchUpsertOperator.this.table.findFeatureNow(SyncSqlExecutor.ID);
                int updated = sqlExecutor.update(this.sqlRequest.get());
                return SaveResult.of(0, updated);
            }, PostgresqlBatchUpsertOperator.this.table);
        }

        @Override
        public Mono<SaveResult> reactive() {
            return (Mono)((Mono)Mono.fromSupplier(this.sqlRequest).as(((ReactiveSqlExecutor)PostgresqlBatchUpsertOperator.this.table.findFeatureNow(ReactiveSqlExecutor.ID))::update)).map(i -> SaveResult.of(0, i)).as(ExceptionUtils.translation(PostgresqlBatchUpsertOperator.this.table));
        }

        @ConstructorProperties(value={"sqlRequest"})
        public PostgresqlSaveResultOperator(Supplier<SqlRequest> sqlRequest) {
            this.sqlRequest = sqlRequest;
        }
    }

    class PostgresqlUpsertOperatorParameter
    extends InsertOperatorParameter {
        private boolean doNoThingOnConflict;
        private List<Term> where;

        public PostgresqlUpsertOperatorParameter(UpsertOperatorParameter parameter) {
            this.doNoThingOnConflict = parameter.isDoNothingOnConflict();
            this.setColumns(parameter.toInsertColumns());
            this.setValues(parameter.getValues());
            this.where = parameter.getWhere();
        }
    }
}

