/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor.wrapper;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapperContext;

public class ConsumerResultWrapper<T>
implements ResultWrapper<T, Integer> {
    private ResultWrapper<T, ?> wrapper;
    private Consumer<T> consumer;
    private Runnable whenComplete;
    private AtomicInteger counter = new AtomicInteger();

    public ConsumerResultWrapper(ResultWrapper<T, ?> wrapper, Consumer<T> consumer, Runnable whenComplete) {
        Objects.requireNonNull(wrapper);
        Objects.requireNonNull(consumer);
        this.wrapper = wrapper;
        this.consumer = consumer;
        this.whenComplete = whenComplete;
    }

    public ConsumerResultWrapper(ResultWrapper<T, ?> wrapper, Consumer<T> consumer) {
        this(wrapper, consumer, null);
    }

    @Override
    public T newRowInstance() {
        return this.wrapper.newRowInstance();
    }

    @Override
    public void beforeWrap(ResultWrapperContext context) {
        this.wrapper.beforeWrap(context);
    }

    @Override
    public void wrapColumn(ColumnWrapperContext<T> context) {
        this.wrapper.wrapColumn(context);
    }

    @Override
    public boolean completedWrapRow(T result) {
        this.counter.incrementAndGet();
        this.consumer.accept(result);
        return this.wrapper.completedWrapRow(result);
    }

    @Override
    public void completedWrap() {
        if (this.whenComplete != null) {
            this.whenComplete.run();
        }
    }

    @Override
    public Integer getResult() {
        return this.counter.get();
    }
}

