/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.CastUtil;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.core.meta.ObjectType;
import org.hswebframework.ezorm.rdb.metadata.AbstractTableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.ConstraintMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBObjectType;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.delete.DefaultDeleteSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.BatchInsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.update.DefaultUpdateSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.upsert.DefaultSaveOrUpdateOperator;

public class RDBTableMetadata
extends AbstractTableOrViewMetadata
implements Cloneable {
    private String comment;
    private List<RDBIndexMetadata> indexes = new ArrayList<RDBIndexMetadata>();
    private List<ConstraintMetadata> constraints = new ArrayList<ConstraintMetadata>();

    public RDBTableMetadata(String name) {
        this();
        this.setName(name);
    }

    public RDBTableMetadata() {
        this.addFeature(BatchInsertSqlBuilder.of(this));
        this.addFeature(DefaultUpdateSqlBuilder.of(this));
        this.addFeature(DefaultDeleteSqlBuilder.of(this));
        this.addFeature(DefaultSaveOrUpdateOperator.of(this));
    }

    public Optional<ConstraintMetadata> getConstraint(String name) {
        return this.constraints.stream().filter(metadata -> metadata.getName().equalsIgnoreCase(name)).findFirst();
    }

    public Optional<RDBIndexMetadata> getIndex(String indexName) {
        return this.indexes.stream().filter(index -> index.getName().equalsIgnoreCase(indexName)).findFirst();
    }

    public void addConstraint(ConstraintMetadata metadata) {
        Objects.requireNonNull(metadata.getName(), "Constraint name can not be null");
        metadata.setTableName(this.getName());
        this.constraints.add(metadata);
    }

    public void addIndex(RDBIndexMetadata index) {
        Objects.requireNonNull(index.getName(), "index name can not be null");
        index.setTableName(this.getName());
        this.indexes.add(index);
        for (RDBIndexMetadata.IndexColumn column : index.getColumns()) {
            this.getColumn(column.getColumn()).ifPresent(columnMeta -> {
                if (index.isPrimaryKey()) {
                    columnMeta.setPrimaryKey(true);
                }
            });
        }
    }

    @Override
    public ObjectType getObjectType() {
        return RDBObjectType.table;
    }

    @Override
    public RDBTableMetadata clone() {
        RDBTableMetadata clone = (RDBTableMetadata)super.clone();
        clone.setAllColumns(new ConcurrentHashMap<String, RDBColumnMetadata>());
        this.getColumns().stream().map(RDBColumnMetadata::clone).forEach(clone::addColumn);
        clone.setFeatures(new HashMap<String, Feature>(this.getFeatures()));
        clone.setIndexes(this.getIndexes().stream().map(RDBIndexMetadata::clone).collect(Collectors.toList()));
        this.getForeignKey().stream().map(ObjectMetadata::clone).map(CastUtil::cast).forEach(clone::addForeignKey);
        return clone;
    }

    @Override
    public void merge(TableOrViewMetadata metadata) {
        super.merge(metadata);
    }

    public String getComment() {
        return this.comment;
    }

    public List<RDBIndexMetadata> getIndexes() {
        return this.indexes;
    }

    public List<ConstraintMetadata> getConstraints() {
        return this.constraints;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIndexes(List<RDBIndexMetadata> indexes) {
        this.indexes = indexes;
    }

    public void setConstraints(List<ConstraintMetadata> constraints) {
        this.constraints = constraints;
    }
}

