/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.sql.Date;
import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DefaultDialect;
import org.hswebframework.utils.StringUtils;

public class OracleDialect
extends DefaultDialect {
    public OracleDialect() {
        this.addDataTypeBuilder(JDBCType.CHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.NCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"nchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.VARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"varchar2(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.NVARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"nvarchar2(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.TIMESTAMP, (RDBColumnMetadata meta) -> "timestamp");
        this.addDataTypeBuilder(JDBCType.TIME, (RDBColumnMetadata meta) -> "timestamp");
        this.addDataTypeBuilder(JDBCType.DATE, (RDBColumnMetadata meta) -> "date");
        this.addDataTypeBuilder(JDBCType.TINYINT, (RDBColumnMetadata meta) -> "number(2)");
        this.addDataTypeBuilder(JDBCType.SMALLINT, (RDBColumnMetadata meta) -> "number(5)");
        this.addDataTypeBuilder(JDBCType.INTEGER, (RDBColumnMetadata meta) -> "number(20)");
        this.addDataTypeBuilder(JDBCType.DOUBLE, (RDBColumnMetadata meta) -> "binary_double");
        this.addDataTypeBuilder(JDBCType.CLOB, (RDBColumnMetadata meta) -> "clob");
        this.addDataTypeBuilder(JDBCType.LONGNVARCHAR, (RDBColumnMetadata meta) -> "clob");
        this.addDataTypeBuilder(JDBCType.BLOB, (RDBColumnMetadata meta) -> "blob");
        this.addDataTypeBuilder(JDBCType.BINARY, (RDBColumnMetadata meta) -> "blob");
        this.addDataTypeBuilder(JDBCType.NUMERIC, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"number(", meta.getPrecision(38), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.DECIMAL, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"number(", meta.getPrecision(38), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "number(38,0)");
        this.addDataTypeBuilder(JDBCType.OTHER, (RDBColumnMetadata meta) -> "other");
        this.addDataTypeBuilder(JDBCType.BOOLEAN, (RDBColumnMetadata meta) -> "number(1)");
        this.addDataTypeBuilder(JDBCType.LONGVARCHAR, (RDBColumnMetadata meta) -> "clob");
        this.addDataTypeBuilder(JDBCType.LONGVARBINARY, (RDBColumnMetadata meta) -> "blob");
        this.registerDataType("longnvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGNVARCHAR, String.class), c -> "clob"));
        this.registerDataType("longvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "clob"));
        this.registerDataType("varchar2", DataType.builder(DataType.jdbc(JDBCType.VARCHAR, String.class), column -> "varchar2(" + column.getLength() + ")"));
        this.registerDataType("nvarchar2", DataType.builder(DataType.jdbc(JDBCType.VARCHAR, String.class), column -> "nvarchar2(" + column.getLength() + ")"));
        this.registerDataType("date", JdbcDataType.of(JDBCType.TIMESTAMP, Date.class));
        this.registerDataType("clob", JdbcDataType.of(JDBCType.LONGVARCHAR, String.class));
        this.registerDataType("blob", JdbcDataType.of(JDBCType.LONGVARBINARY, byte[].class));
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public boolean isColumnToUpperCase() {
        return true;
    }

    public String getId() {
        return "oracle";
    }

    public String getName() {
        return "Oracle";
    }
}

