/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.oracle;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;

public class OracleInsertSqlBuilder
implements InsertSqlBuilder {
    private RDBTableMetadata table;

    @Override
    public SqlRequest build(InsertOperatorParameter parameter) {
        boolean batch;
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        LinkedHashMap<Integer, RDBColumnMetadata> indexMapping = new LinkedHashMap<Integer, RDBColumnMetadata>();
        LinkedHashMap<Integer, SqlFragments> functionValues = new LinkedHashMap<Integer, SqlFragments>();
        int index = 0;
        int primaryIndex = -1;
        Set<InsertColumn> columns = parameter.getColumns();
        for (InsertColumn column : columns) {
            RDBColumnMetadata columnMetadata = Optional.ofNullable(column.getColumn()).flatMap(this.table::getColumn).orElse(null);
            if (columnMetadata != null && columnMetadata.isInsertable()) {
                if (columnMetadata.isPrimaryKey()) {
                    primaryIndex = index;
                }
                indexMapping.put(index, columnMetadata);
                SqlFragments functionFragments = Optional.of(column).flatMap(insertColumn -> Optional.ofNullable(insertColumn.getFunction()).flatMap(function -> columnMetadata.findFeature(FunctionFragmentBuilder.createFeatureId(function))).map(builder -> builder.create(columnMetadata.getName(), columnMetadata, insertColumn.getOpts()))).orElse(EmptySqlFragments.INSTANCE);
                if (functionFragments.isNotEmpty()) {
                    functionValues.put(index, functionFragments);
                }
            }
            ++index;
        }
        if (indexMapping.isEmpty()) {
            throw new IllegalArgumentException("No operable columns");
        }
        boolean bl = batch = parameter.getValues().size() > 1;
        if (batch) {
            fragments.addSql("insert all");
        } else {
            fragments.addSql("insert");
        }
        HashSet<Object> duplicatePrimary = new HashSet<Object>();
        for (List<Object> values : parameter.getValues()) {
            PrepareSqlFragments intoSql = PrepareSqlFragments.of();
            PrepareSqlFragments valuesSql = PrepareSqlFragments.of();
            int valueLen = values.size();
            int vIndex = 0;
            if (primaryIndex >= 0 && values.size() > primaryIndex && !duplicatePrimary.add(values.get(primaryIndex))) continue;
            intoSql.addSql("into").addSql(this.table.getFullName()).addSql("(");
            valuesSql.addSql("values (");
            for (Map.Entry entry : indexMapping.entrySet()) {
                Object value;
                SqlFragments function;
                RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue();
                int valueIndex = (Integer)entry.getKey();
                if (vIndex++ != 0) {
                    intoSql.addSql(",");
                    valuesSql.addSql(",");
                }
                if (null != (function = (SqlFragments)functionValues.get(valueIndex))) {
                    valuesSql.addFragments(function);
                    continue;
                }
                Object object = value = valueLen <= valueIndex ? null : values.get(valueIndex);
                if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                    value = ((RuntimeDefaultValue)column.getDefaultValue()).get();
                }
                intoSql.addSql(column.getQuoteName());
                if (value instanceof NativeSql) {
                    valuesSql.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                if (value == null) {
                    value = NullValue.of(column.getType());
                }
                valuesSql.addSql("?").addParameter(column.encode(value));
            }
            intoSql.addSql(")");
            valuesSql.addSql(")");
            fragments.addFragments(intoSql).addFragments(valuesSql);
        }
        if (batch) {
            fragments.addSql("select 1 from dual");
        }
        return fragments.toRequest();
    }

    @ConstructorProperties(value={"table"})
    private OracleInsertSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }

    public static OracleInsertSqlBuilder of(RDBTableMetadata table) {
        return new OracleInsertSqlBuilder(table);
    }
}

