/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping;

import java.util.Collection;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveRepository<T, K> {
    public Mono<T> newInstance();

    public Mono<T> findById(Mono<K> var1);

    public Flux<T> findById(Flux<K> var1);

    default public Mono<T> findById(K key) {
        return this.findById((K)Mono.just(key));
    }

    default public Flux<T> findById(Collection<K> key) {
        return this.findById(Flux.fromIterable(key));
    }

    public Mono<Integer> deleteById(Publisher<K> var1);

    default public Mono<Integer> deleteById(K key) {
        return this.deleteById(Mono.just(key));
    }

    default public Mono<Integer> deleteById(Collection<K> key) {
        return this.deleteById(Flux.fromIterable(key));
    }

    public Mono<SaveResult> save(Publisher<T> var1);

    default public Mono<SaveResult> save(T data) {
        return this.save(Mono.just(data));
    }

    default public Mono<SaveResult> save(Collection<T> data) {
        return this.save(Flux.fromIterable(data));
    }

    default public Mono<Integer> updateById(K id, T data) {
        return this.updateById(id, Mono.just(data));
    }

    public Mono<Integer> updateById(K var1, Mono<T> var2);

    public Mono<Integer> insert(Publisher<T> var1);

    default public Mono<Integer> insert(T data) {
        return this.insert(Mono.just(data));
    }

    default public Mono<Integer> insert(Collection<T> data) {
        return this.insert(Flux.fromIterable(data));
    }

    default public Mono<Integer> insertBatch(Collection<T> data) {
        return this.insertBatch((Publisher<? extends Collection<T>>)Mono.just(data));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<T>> var1);

    public ReactiveQuery<T> createQuery();

    public ReactiveUpdate<T> createUpdate();

    public ReactiveDelete createDelete();
}

