/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.FeatureId;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.core.meta.ObjectType;
import org.hswebframework.ezorm.rdb.events.ContextKeyValue;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;

public interface TableOrViewMetadata
extends ObjectMetadata,
FeatureSupportedMetadata {
    public ObjectType getObjectType();

    public Dialect getDialect();

    public RDBSchemaMetadata getSchema();

    public List<RDBColumnMetadata> getColumns();

    public List<RDBColumnMetadata> findColumns();

    public Optional<RDBColumnMetadata> getColumn(String var1);

    public Optional<RDBColumnMetadata> findColumn(String var1);

    public List<ForeignKeyMetadata> getForeignKeys();

    public Optional<ForeignKeyMetadata> getForeignKey(String var1);

    public void addForeignKey(ForeignKeyMetadata var1);

    public ForeignKeyMetadata addForeignKey(ForeignKeyBuilder var1);

    default public void fireEvent(EventType eventType, ContextKeyValue<?> ... keyValues) {
        this.fireEvent(eventType, (EventContext ctx) -> ctx.set(keyValues));
    }

    default public void fireEvent(EventType eventType, Consumer<EventContext> contextConsumer) {
        this.findFeature(EventListener.ID).ifPresent(eventListener -> {
            EventContext context = EventContext.create();
            context.set(ContextKeys.table, this);
            contextConsumer.accept(context);
            eventListener.onEvent(eventType, context);
        });
    }

    default public String getFullName() {
        return this.getSchema().getName().concat(".").concat(this.getName());
    }

    default public <T extends Feature> Optional<T> findFeature(FeatureId<T> id) {
        return this.findFeature(id.getId());
    }

    default public <T extends Feature> Optional<T> findFeature(String id) {
        return Optional.of(this.getFeature(id)).filter(Optional::isPresent).orElseGet(() -> this.getSchema().findFeature(id));
    }

    default public List<Feature> findFeatures(Predicate<Feature> predicate) {
        return Stream.concat(this.getSchema().getFeatureList().stream(), this.getFeatureList().stream()).filter(predicate).collect(Collectors.toList());
    }

    default public List<Feature> findFeatures() {
        return this.findFeatures(feature -> true);
    }

    public void merge(TableOrViewMetadata var1);
}

