/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.insert;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hswebframework.ezorm.core.RuntimeDefaultValue;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.function.FunctionFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.insert.InsertSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertColumn;
import org.hswebframework.ezorm.rdb.operator.dml.insert.InsertOperatorParameter;

public class BatchInsertSqlBuilder
implements InsertSqlBuilder {
    private RDBTableMetadata table;

    public static BatchInsertSqlBuilder of(RDBTableMetadata table) {
        return new BatchInsertSqlBuilder(table);
    }

    @Override
    public SqlRequest build(InsertOperatorParameter parameter) {
        PrepareSqlFragments fragments = this.beforeBuild(parameter, PrepareSqlFragments.of()).addSql("(");
        HashMap<Integer, RDBColumnMetadata> indexMapping = new HashMap<Integer, RDBColumnMetadata>();
        HashMap<Integer, SqlFragments> functionValues = new HashMap<Integer, SqlFragments>();
        int index = 0;
        Set<InsertColumn> columns = parameter.getColumns();
        for (InsertColumn insertColumn2 : columns) {
            RDBColumnMetadata columnMetadata = Optional.ofNullable(insertColumn2.getColumn()).flatMap(this.table::getColumn).orElse(null);
            if (columnMetadata != null && columnMetadata.isInsertable()) {
                if (indexMapping.size() != 0) {
                    fragments.addSql(",");
                }
                fragments.addSql(columnMetadata.getQuoteName());
                indexMapping.put(index, columnMetadata);
                SqlFragments functionFragments = Optional.of(insertColumn2).flatMap(insertColumn -> Optional.ofNullable(insertColumn.getFunction()).flatMap(function -> columnMetadata.findFeature(FunctionFragmentBuilder.createFeatureId(function))).map(builder -> builder.create(columnMetadata.getName(), columnMetadata, insertColumn.getOpts()))).orElse(EmptySqlFragments.INSTANCE);
                if (functionFragments.isNotEmpty()) {
                    functionValues.put(index, functionFragments);
                }
            }
            ++index;
        }
        if (indexMapping.isEmpty()) {
            throw new IllegalArgumentException("No operable columns");
        }
        fragments.addSql(") values ");
        index = 0;
        for (List list : parameter.getValues()) {
            if (index++ != 0) {
                fragments.addSql(",");
            }
            fragments.addSql("(");
            int valueLen = list.size();
            int vIndex = 0;
            for (Map.Entry entry : indexMapping.entrySet()) {
                Object value;
                SqlFragments function;
                int valueIndex = (Integer)entry.getKey();
                if (vIndex++ != 0) {
                    fragments.addSql(",");
                }
                if (null != (function = (SqlFragments)functionValues.get(valueIndex))) {
                    fragments.addFragments(function);
                    continue;
                }
                RDBColumnMetadata column = (RDBColumnMetadata)entry.getValue();
                Object object = value = valueLen <= valueIndex ? null : (Object)list.get(valueIndex);
                if ((value == null || value instanceof NullValue) && column.getDefaultValue() instanceof RuntimeDefaultValue) {
                    value = column.getDefaultValue().get();
                }
                if (value instanceof NativeSql) {
                    fragments.addSql(((NativeSql)value).getSql()).addParameter(((NativeSql)value).getParameters());
                    continue;
                }
                if (value == null) {
                    value = NullValue.of(column.getType());
                }
                fragments.addSql("?").addParameter(column.encode(value));
            }
            fragments.addSql(")");
            this.afterValues(columns, list, fragments);
        }
        return this.afterBuild(columns, parameter, fragments).toRequest();
    }

    protected PrepareSqlFragments beforeBuild(InsertOperatorParameter parameter, PrepareSqlFragments fragments) {
        return fragments.addSql("insert into").addSql(this.table.getFullName());
    }

    protected PrepareSqlFragments afterBuild(Set<InsertColumn> columns, InsertOperatorParameter parameter, PrepareSqlFragments fragments) {
        return fragments;
    }

    protected void afterValues(Set<InsertColumn> columns, List<Object> values, PrepareSqlFragments sql) {
    }

    @ConstructorProperties(value={"table"})
    public BatchInsertSqlBuilder(RDBTableMetadata table) {
        this.table = table;
    }
}

