/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.util.function.Consumer;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;

public class ForeignKeyDSLBuilder {
    private RDBTableMetadata table;
    private ForeignKeyBuilder builder = ForeignKeyBuilder.builder().build();

    public ForeignKeyDSLBuilder(RDBTableMetadata table) {
        this.table = table;
        this.builder.setAutoJoin(true);
    }

    public ForeignKeyDSLBuilder name(String name) {
        this.builder.setName(name);
        return this;
    }

    public ForeignKeyDSLBuilder alias(String alias) {
        this.builder.setAlias(alias);
        return this;
    }

    public ForeignKeyDSLBuilder target(String source) {
        this.builder.setTarget(source);
        return this;
    }

    public ForeignKeyDSLBuilder column(String sourceColumn, String targetColumn) {
        this.builder.addColumn(sourceColumn, targetColumn);
        return this;
    }

    public ForeignKeyDSLBuilder autoJoin(boolean autoJoin) {
        this.builder.setAutoJoin(autoJoin);
        return this;
    }

    public ForeignKeyDSLBuilder toMany() {
        this.builder.setAutoJoin(false);
        this.builder.setToMany(true);
        return this;
    }

    public ForeignKeyDSLBuilder condition(Consumer<Conditional<?>> consumer) {
        Query query = Query.of();
        consumer.accept((Conditional<?>)query);
        this.builder.setTerms(query.getParam().getTerms());
        return this;
    }

    public RDBTableMetadata commit() {
        this.table.addForeignKey(this.builder);
        return this.table;
    }
}

