/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.dml.update;

import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.update.UpdateResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DefaultUpdateResultOperator
implements UpdateResultOperator {
    private RDBTableMetadata table;
    private Supplier<SqlRequest> sql;

    @Override
    public Integer sync() {
        return ExceptionUtils.translation(() -> ((SyncSqlExecutor)this.table.findFeatureNow(SyncSqlExecutor.ID)).update(this.sql.get()), this.table);
    }

    @Override
    public Mono<Integer> reactive() {
        return Mono.defer(() -> ((ReactiveSqlExecutor)this.table.findFeatureNow(ReactiveSqlExecutor.ID)).update((Publisher<SqlRequest>)Mono.fromSupplier(this.sql)).onErrorMap(err -> ExceptionUtils.translation(this.table, err)));
    }

    @ConstructorProperties(value={"table", "sql"})
    private DefaultUpdateResultOperator(RDBTableMetadata table, Supplier<SqlRequest> sql) {
        this.table = table;
        this.sql = sql;
    }

    public static DefaultUpdateResultOperator of(RDBTableMetadata table, Supplier<SqlRequest> sql) {
        return new DefaultUpdateResultOperator(table, sql);
    }
}

