/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import io.r2dbc.spi.Blob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BlobValueCodec
implements ValueCodec<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(BlobValueCodec.class);
    public static final BlobValueCodec INSTANCE = new BlobValueCodec();

    public Object encode(Object value) {
        block30: {
            if (value == null) {
                return null;
            }
            if (value instanceof java.sql.Blob) {
                return value;
            }
            if (!(value instanceof byte[])) {
                if (value instanceof Serializable) {
                    try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                         ObjectOutputStream object = new ObjectOutputStream(output);){
                        object.writeObject(value);
                        object.flush();
                        object.close();
                        value = output.toByteArray();
                        break block30;
                    }
                }
                throw new NotSerializableException("unsupported encode type " + value.getClass());
            }
        }
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object decode(Object data) {
        block23: {
            if (data == null) {
                return null;
            }
            if (!(data instanceof java.sql.Blob)) break block23;
            java.sql.Blob blobValue = (java.sql.Blob)data;
            try {
                Throwable throwable = null;
                try (InputStream inputStream = blobValue.getBinaryStream();){
                    ObjectInputStream inputStream1 = new ObjectInputStream(inputStream);
                    Object object = inputStream1.readObject();
                    return object;
                }
                catch (IOException inputStream1) {
                    block24: {
                        break block24;
                        catch (ClassNotFoundException e) {
                            log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    byte[] byArray = blobValue.getBytes(1L, (int)blobValue.length());
                    return byArray;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                log.warn("blob data error", (Throwable)e);
                return data;
            }
        }
        if (!FeatureUtils.r2dbcIsAlive()) return data;
        Mono mono = null;
        if (data instanceof Blob) {
            mono = Mono.from((Publisher)((Blob)data).stream()).map(ByteBufferBackedInputStream::new).map(input -> {
                try {
                    ObjectInputStream inputStream1 = new ObjectInputStream((InputStream)input);
                    return inputStream1.readObject();
                }
                catch (IOException inputStream1) {
                }
                catch (ClassNotFoundException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
                return input;
            });
        }
        if (mono == null) return data;
        return mono.toFuture().get(10L, TimeUnit.SECONDS);
    }
}

