/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.LazyForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.JoinFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QueryTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.SelectColumnFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.SortOrderFragmentBuilder;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;

public abstract class AbstractTableOrViewMetadata
implements TableOrViewMetadata {
    private String name;
    private String alias;
    private RDBSchemaMetadata schema;
    protected Map<String, RDBColumnMetadata> allColumns = new ConcurrentHashMap<String, RDBColumnMetadata>();
    protected List<ForeignKeyMetadata> foreignKey = new ArrayList<ForeignKeyMetadata>();
    protected Map<String, Feature> features = new HashMap<String, Feature>();

    public AbstractTableOrViewMetadata() {
        this.addFeature(QueryTermsFragmentBuilder.of(this));
        this.addFeature(SelectColumnFragmentBuilder.of(this));
        this.addFeature(JoinFragmentBuilder.of(this));
        this.addFeature(SortOrderFragmentBuilder.of(this));
    }

    public boolean isTable() {
        return this instanceof RDBTableMetadata;
    }

    public boolean isView() {
        return this instanceof RDBViewMetadata;
    }

    public void removeColumn(String name) {
        RDBColumnMetadata metadata = this.allColumns.remove(name);
        if (metadata != null) {
            this.allColumns.remove(metadata.getAlias());
        }
    }

    @Override
    public RDBSchemaMetadata getSchema() {
        return this.schema;
    }

    public void addColumn(RDBColumnMetadata column) {
        column.setOwner(this);
        this.allColumns.put(column.getName(), column);
        this.allColumns.put(column.getAlias(), column);
    }

    @Override
    public List<RDBColumnMetadata> getColumns() {
        return new ArrayList<RDBColumnMetadata>(this.allColumns.values().stream().sorted().collect(Collectors.toMap(AbstractColumnMetadata::getName, Function.identity(), (_1, _2) -> _1)).values());
    }

    @Override
    public List<RDBColumnMetadata> findColumns() {
        return this.allColumns.values().stream().flatMap(c -> this.getForeignKey().stream().map(ForeignKeyMetadata::getTarget).map(TableOrViewMetadata::getColumns).flatMap(Collection::stream)).sorted().collect(Collectors.toList());
    }

    @Override
    public Optional<RDBColumnMetadata> getColumn(String name) {
        return Optional.ofNullable(name).map(this.allColumns::get);
    }

    @Override
    public Optional<RDBColumnMetadata> findColumn(String name) {
        return Optional.ofNullable(name).map(this::getColumn).filter(Optional::isPresent).orElseGet(() -> this.findNestColumn(name));
    }

    private Optional<RDBColumnMetadata> findNestColumn(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.contains(".")) {
            String[] arr = name.split("[.]");
            if (arr.length == 2) {
                return this.findColumnFromSchema(this.schema, arr[0], arr[1]);
            }
            if (arr.length == 3) {
                return this.schema.getDatabase().getSchema(arr[0]).flatMap(another -> this.findColumnFromSchema((RDBSchemaMetadata)((Object)another), arr[1], arr[2]));
            }
        }
        return Optional.empty();
    }

    @Override
    public void addForeignKey(ForeignKeyMetadata metadata) {
        this.foreignKey.add(metadata);
    }

    @Override
    public ForeignKeyMetadata addForeignKey(ForeignKeyBuilder builder) {
        LazyForeignKeyMetadata metadata = LazyForeignKeyMetadata.of(builder, this);
        this.addForeignKey(metadata);
        return metadata;
    }

    private Optional<RDBColumnMetadata> findColumnFromSchema(RDBSchemaMetadata schema, String tableName, String column) {
        return Optional.of(schema.getTableOrView(tableName).flatMap(meta -> meta.getColumn(column))).filter(Optional::isPresent).orElseGet(() -> this.getForeignKey(tableName).flatMap(key -> key.getTarget().getColumn(column)));
    }

    @Override
    public List<ForeignKeyMetadata> getForeignKeys() {
        return new ArrayList<ForeignKeyMetadata>(this.foreignKey);
    }

    @Override
    public Optional<ForeignKeyMetadata> getForeignKey(String targetName) {
        return this.foreignKey.stream().filter(key -> key.getTarget().equalsNameOrAlias(targetName) || key.equalsNameOrAlias(targetName)).findFirst();
    }

    public void addFeature(Feature feature) {
        this.features.put(feature.getId(), feature);
    }

    @Override
    public Dialect getDialect() {
        return this.getSchema().getDialect();
    }

    public ObjectMetadata clone() {
        return (ObjectMetadata)super.clone();
    }

    public RDBColumnMetadata newColumn() {
        RDBColumnMetadata column = new RDBColumnMetadata();
        column.setSortIndex(this.getColumns().size() + 1);
        column.setOwner(this);
        return column;
    }

    public String toString() {
        return FeatureUtils.metadataToString(this);
    }

    @Override
    public void merge(TableOrViewMetadata metadata) {
        metadata.getForeignKeys().forEach(this::addForeignKey);
        metadata.getFeatureList().forEach(this::addFeature);
        metadata.getColumns().forEach(this::addColumn);
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, RDBColumnMetadata> getAllColumns() {
        return this.allColumns;
    }

    public List<ForeignKeyMetadata> getForeignKey() {
        return this.foreignKey;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSchema(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public void setAllColumns(Map<String, RDBColumnMetadata> allColumns) {
        this.allColumns = allColumns;
    }

    public void setForeignKey(List<ForeignKeyMetadata> foreignKey) {
        this.foreignKey = foreignKey;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }
}

