/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatures;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BlockSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.query.QuerySqlBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.query.QueryOperatorParameter;

public class DefaultQuerySqlBuilder
implements QuerySqlBuilder {
    protected RDBSchemaMetadata schema;

    protected Optional<SqlFragments> select(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.select).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> where(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.where).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> join(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.selectJoin).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected Optional<SqlFragments> orderBy(QueryOperatorParameter parameter, TableOrViewMetadata metadata) {
        return metadata.getFeature(RDBFeatures.orderBy).map(builder -> builder.createFragments(parameter)).filter(SqlFragments::isNotEmpty);
    }

    protected SqlRequest build(TableOrViewMetadata metadata, QueryOperatorParameter parameter) {
        BlockSqlFragments fragments = BlockSqlFragments.of();
        fragments.addBlock(FragmentBlock.before, "select");
        fragments.addBlock(FragmentBlock.selectColumn, this.select(parameter, metadata).orElseGet(() -> PrepareSqlFragments.of().addSql("*")));
        fragments.addBlock(FragmentBlock.selectFrom, PrepareSqlFragments.of().addSql("from").addSql(metadata.getFullName()).addSql(parameter.getFromAlias()));
        this.join(parameter, metadata).ifPresent(join -> fragments.addBlock(FragmentBlock.join, (SqlFragments)join));
        this.where(parameter, metadata).ifPresent(where -> fragments.addBlock(FragmentBlock.where, "where").addBlock(FragmentBlock.where, (SqlFragments)where));
        this.orderBy(parameter, metadata).ifPresent(order -> fragments.addBlock(FragmentBlock.orderBy, "order by").addBlock(FragmentBlock.orderBy, (SqlFragments)order));
        if (Boolean.TRUE.equals(parameter.getForUpdate())) {
            fragments.addBlock(FragmentBlock.after, PrepareSqlFragments.of().addSql("for update"));
        } else if (parameter.getPageIndex() != null && parameter.getPageSize() != null) {
            return metadata.findFeature(RDBFeatureType.paginator.getId()).map(paginator -> paginator.doPaging(fragments, parameter.getPageIndex(), parameter.getPageSize())).map(SqlFragments::toRequest).orElseGet(fragments::toRequest);
        }
        return fragments.toRequest();
    }

    @Override
    public SqlRequest build(QueryOperatorParameter parameter) {
        String from = parameter.getFrom();
        if (from == null || from.isEmpty()) {
            throw new UnsupportedOperationException("from table or view not set");
        }
        TableOrViewMetadata metadata = this.schema.findTableOrView(from).orElseThrow(() -> new UnsupportedOperationException("table or view [" + from + "] doesn't exist "));
        return this.build(metadata, parameter);
    }

    @ConstructorProperties(value={"schema"})
    private DefaultQuerySqlBuilder(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    public static DefaultQuerySqlBuilder of(RDBSchemaMetadata schema) {
        return new DefaultQuerySqlBuilder(schema);
    }
}

